<elements>
  <summary>
    <attribution license="cc4" from="Microsoft" modified="false" />
    <para>Contains the classes for LINQ to XML. LINQ to XML is an in-memory XML programming interface that enables you to modify XML documents efficiently and easily.</para>
  </summary>
  <remarks>
    <attribution license="cc4" from="Microsoft" modified="false" />
    <para>Using LINQ to XML, you can:</para>
    <list type="bullet">
      <item>
        <para>Load XML from files or streams.</para>
      </item>
      <item>
        <para>Serialize XML to files or streams.</para>
      </item>
      <item>
        <para>Create XML trees from scratch using functional construction.</para>
      </item>
      <item>
        <para>Query XML trees using LINQ queries.</para>
      </item>
      <item>
        <para>Manipulate in-memory XML trees.</para>
      </item>
      <item>
        <para>Validate XML trees using XSD.</para>
      </item>
      <item>
        <para>Use a combination of these features to transform XML trees from one shape into another. </para>
      </item>
    </list>
  </remarks>
  <class name="Extensions" fullname="System.Xml.Linq.Extensions" assembly="System.Xml.Linq">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Contains the sqltecxlinq extension methods.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Most of the sqltecxlinq extension methods are axis methods that are used in vbteclinq queries. The methods in this class operate on collections and return collections. These methods enumerate the source collection, call the appropriate axis method on each item in the collection, and concatenate the results.</para>
      <para>The two <see cref="Overload:System.Xml.Linq.Extensions.Remove" /> extension methods are not axis methods, however. These methods remove attributes or nodes from the XML tree.</para>
      <para>Note that there is another category of axis methods, implemented in the <see cref="T:System.Xml.Linq.XElement" />, <see cref="T:System.Xml.Linq.XDocument" />, and <see cref="T:System.Xml.Linq.XNode" /> classes. These other axis methods operate on a single object, and return a collection of <see cref="T:System.Xml.Linq.XElement" />, <see cref="T:System.Xml.Linq.XAttribute" />, or <see cref="T:System.Xml.Linq.XNode" /> objects. </para>
      <para>All of the axis extension methods use deferred execution. </para>
    </remarks>
  </class>
  <class name="LoadOptions" fullname="System.Xml.Linq.LoadOptions" assembly="System.Xml.Linq">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Specifies load options when parsing XML. </para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>If you preserve white space when loading, all insignificant white space in the XML tree is materialized in the XML tree as is. If you do not preserve white space, then all insignificant white space is discarded.</para>
      <para>There is a performance penalty if you set the <see cref="F:System.Xml.Linq.LoadOptions.SetBaseUri" /> and the <see cref="F:System.Xml.Linq.LoadOptions.SetLineInfo" /> flags.</para>
      <para>The base URI and the line information are accurate immediately after loading the XML document. If you modify the XML tree after loading the document, the base URI and line information may become meaningless.</para>
      <para>If the underlying <see cref="T:System.Xml.XmlReader" /> does not have base URI or line information, setting the <see cref="F:System.Xml.Linq.LoadOptions.SetBaseUri" /> and the <see cref="F:System.Xml.Linq.LoadOptions.SetLineInfo" /> flags will have no effect.</para>
      <para>This type allows you to control how LINQ to XML handles white space when loading or parsing. For more information, see <format type="text/html"><a href="093a7169-a04e-4638-b08c-d1cb98aa650d">Preserving White Space while Loading or Parsing XML</a></format> and <format type="text/html"><a href="fb146217-0a49-4efc-ac84-7265b91d3939">Preserving White Space While Serializing</a></format>.</para>
    </remarks>
  </class>
  <class name="ReaderOptions" fullname="System.Xml.Linq.ReaderOptions" assembly="System.Xml.Linq">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Specifies whether to omit duplicate namespaces when loading an <see cref="T:System.Xml.Linq.XDocument" /> with an <see cref="T:System.Xml.XmlReader" />.</para>
    </summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="SaveOptions" fullname="System.Xml.Linq.SaveOptions" assembly="System.Xml.Linq">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Specifies serialization options.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>If you disable formatting when serializing, all insignificant white space in the XML tree is serialized as is. If you do not disable formatting, then all insignificant white space in the XML tree is discarded, and the XML is formatted (indented) as it is serialized.</para>
      <para>This type allows you to control how LINQ to XML handles white space when serializing. For more information, see <format type="text/html"><a href="093a7169-a04e-4638-b08c-d1cb98aa650d">Preserving White Space while Loading or Parsing XML</a></format> and <format type="text/html"><a href="fb146217-0a49-4efc-ac84-7265b91d3939">Preserving White Space While Serializing</a></format>.</para>
    </remarks>
  </class>
  <class name="XAttribute" fullname="System.Xml.Linq.XAttribute" assembly="System.Xml.Linq">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents an XML attribute.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>An XML attribute is a name/value pair associated with an XML element. </para>
      <para>Each <see cref="T:System.Xml.Linq.XElement" /> contains a list of the attributes for that element. Attributes must have a qualified name that is unique to the element. Attributes are not derived from <see cref="T:System.Xml.Linq.XNode" />; they are not nodes in the XML tree. Instead, they are simply name/value pairs associated with an element.</para>
      <para>Attributes are maintained in the XML tree in the order that they were added to the element. When a collection of attributes is returned by <see cref="M:System.Xml.Linq.XElement.Attributes" />, they are returned in the order that they were added to the element, and are not sorted.</para>
      <para>Technically, in XML, namespace declarations are not attributes proper. However, this distinction is not normally made by many XML programmers. Instead, because namespace declarations have exactly the same XML syntax as attributes, most XML programmers think of namespaces as attributes. To simplify the sqltecxlinq programming interface, namespaces are represented in the XML tree as attributes. Such namespace attributes impact serialization of an XML tree. When serializing, sqltecxlinq attempts to serialize with the namespace prefix specified in namespace attributes. You can use the <see cref="P:System.Xml.Linq.XAttribute.IsNamespaceDeclaration" /> to determine if an attribute is really a namespace declaration.</para>
      <para>The <see cref="T:System.Xml.Linq.XAttribute" /> class derives from <see cref="T:System.Xml.Linq.XObject" />. You can add annotations to attributes, and observe events for them.</para>
      <para>Some <see cref="T:System.Xml.Linq.XAttribute" /> methods can be used from XAML. For more information, see <format type="text/html"><a href="0455f47c-4a68-4f2e-a3f8-dd1d85b99012">LINQ to XML Dynamic Properties</a></format>.</para>
    </remarks>
  </class>
  <class name="XCData" fullname="System.Xml.Linq.XCData" assembly="System.Xml.Linq">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents a text node that contains CDATA. </para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>An XML CDATA section allows you to store almost any arbitrary string as the contents of an XML element. This class represents the XML concept of a CDATA text node.</para>
      <para>This class derives from <see cref="T:System.Xml.Linq.XText" />, which represents XML text. CDATA sections are special cases of XML text.</para>
    </remarks>
  </class>
  <class name="XComment" fullname="System.Xml.Linq.XComment" assembly="System.Xml.Linq">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents an XML comment. </para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>You can add an XML comment as a child node of an element. You can also add an XML comment to an <see cref="T:System.Xml.Linq.XDocument" /> as a sibling of the root element node.</para>
    </remarks>
  </class>
  <class name="XContainer" fullname="System.Xml.Linq.XContainer" assembly="System.Xml.Linq">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents a node that can contain other nodes.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>This class provides functionality such as finding the next or previous sibling node, or enumerating the direct children of a node.</para>
      <para>The two classes that derive from <see cref="T:System.Xml.Linq.XContainer" /> are <see cref="T:System.Xml.Linq.XDocument" /> and <see cref="T:System.Xml.Linq.XElement" />.</para>
    </remarks>
  </class>
  <class name="XDeclaration" fullname="System.Xml.Linq.XDeclaration" assembly="System.Xml.Linq">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents an XML declaration.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>An XML declaration is used to declare the XML version, the encoding, and whether or not the XML document is standalone. This class represents the XML concept of an XML declaration. </para>
      <para>Just as in the XML standard, declarations are associated with a document. When you create a document, you have the option to specify the declaration for the document. The <see cref="T:System.Xml.Linq.XDocument" /> class contains the <see cref="P:System.Xml.Linq.XDocument.Declaration" /> property, which allows you to set or get the declaration. For information about how to serialize an XML tree with an XML declaration, see <format type="text/html"><a href="30f1b564-62b5-4e5d-9c36-884e51113feb">Saving With an XML Declaration</a></format>. </para>
    </remarks>
  </class>
  <class name="XDocument" fullname="System.Xml.Linq.XDocument" assembly="System.Xml.Linq">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents an XML document. For the components and usage of an <see cref="T:System.Xml.Linq.XDocument" /> object, see <format type="text/html"><a href="90f78331-1be8-42fb-93e7-bd1325826467">XDocument Class Overview</a></format>.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>For details about the valid content of an <see cref="T:System.Xml.Linq.XDocument" />, see <format type="text/html"><a href="aee2d319-5c5f-4b99-9bb4-2f58232577ae">Valid Content of XElement and XDocument Objects</a></format>.</para>
    </remarks>
  </class>
  <class name="XDocumentType" fullname="System.Xml.Linq.XDocumentType" assembly="System.Xml.Linq">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents an XML Document Type Definition (DTD). </para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Data Type Definitions (DTD) in XML are a way to do the following:</para>
      <list type="bullet">
        <item>
          <para>Validate XML trees to a limited extent.</para>
        </item>
        <item>
          <para>Expand entities, which is a form of text replacement.</para>
        </item>
        <item>
          <para>Supply default attributes.</para>
        </item>
      </list>
      <para>This class represents the XML concept of a DTD.</para>
      <para>DTD support in sqltecxlinq is limited. </para>
      <para>sqltecxlinq will expand internal entities by default, but it will not resolve external entity references unless an <see cref="T:System.Xml.XmlReader" /> with an associated <see cref="T:System.Xml.XmlResolver" /> is used to load the XML tree. </para>
      <para>sqltecxlinq will not validate a document against a DTD, but you can use a validating <see cref="T:System.Xml.XmlReader" /> to perform DTD validation if necessary.</para>
      <para>To validate an sqltecxlinq tree against an XML schema, use the <see cref="Overload:System.Xml.Schema.Extensions.Validate" /> method.</para>
      <para>When a document contains entity references that are defined in a DTD, the references are expanded upon creation of the XML tree. However, when you serialize or save the XML tree, the content of the expanded entities is preserved; the entity references are not.</para>
      <para>Default attributes from the DTD will be materialized as regular attributes in the XML tree. After a default attribute from the DTD is materialized, there is no way to determine that the attribute was a default attribute from the DTD.</para>
      <para>You can populate an XML tree with an XML document that contains an internal DTD. The XML tree will then contain a <see cref="P:System.Xml.Linq.XDocument.DocumentType" /> node. When you serialize or save the tree, the internal DTD will also be saved as part of the document.</para>
    </remarks>
  </class>
  <class name="XElement" fullname="System.Xml.Linq.XElement" assembly="System.Xml.Linq">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents an XML element.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>This class represents an XML element, the fundamental XML construct.</para>
      <para>An element has an <see cref="T:System.Xml.Linq.XName" />, optionally one or more attributes, and can optionally contain content (for more information, see <see cref="M:System.Xml.Linq.XContainer.Nodes" />).</para>
      <para>An <see cref="T:System.Xml.Linq.XElement" /> can contain the following types of content: </para>
      <list type="bullet">
        <item>
          <para>
            <see cref="T:System.Xml.Linq.XElement" />
          </para>
        </item>
        <item>
          <para>
            <see cref="T:System.Xml.Linq.XComment" />
          </para>
        </item>
        <item>
          <para>
            <see cref="T:System.Xml.Linq.XProcessingInstruction" />
          </para>
        </item>
        <item>
          <para>
            <see cref="T:System.Xml.Linq.XText" />
          </para>
        </item>
      </list>
      <para>For details about the valid content of an <see cref="T:System.Xml.Linq.XElement" />, see <format type="text/html"><a href="aee2d319-5c5f-4b99-9bb4-2f58232577ae">Valid Content of XElement and XDocument Objects</a></format>.</para>
      <para>
        <see cref="T:System.Xml.Linq.XElement" /> derives from <see cref="T:System.Xml.Linq.XContainer" />, which derives from <see cref="T:System.Xml.Linq.XNode" />.</para>
      <para>Some <see cref="T:System.Xml.Linq.XElement" /> methods can be used from XAML. For more information, see <format type="text/html"><a href="0455f47c-4a68-4f2e-a3f8-dd1d85b99012">LINQ to XML Dynamic Properties</a></format>.</para>
    </remarks>
  </class>
  <class name="XName" fullname="System.Xml.Linq.XName" assembly="System.Xml.Linq">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents a name of an XML element or attribute. </para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>XML names include a namespace and a local name. A <newTerm>fully qualified name</newTerm> is the combination of the namespace and local name. </para>
      <format type="text/html">
        <h2>Creating an XName Object</h2>
      </format>
      <para>
        <see cref="T:System.Xml.Linq.XName" /> does not contain any public constructors. Instead, this class provides an implicit conversion from <see cref="T:System.String" /> that allows you to create an <see cref="T:System.Xml.Linq.XName" />. The most common place you use this conversion is when constructing an element or attribute: The first argument to the <see cref="T:System.Xml.Linq.XElement" /> constructor is an <see cref="T:System.Xml.Linq.XName" />. By passing a string, you take advantage of the implicit conversion. The following code creates an element with a name that is in no namespace: </para>
      <code>XElement root = new XElement("ElementName", "content");
Console.WriteLine(root);</code>
      <para>In Visual Basic, it is more appropriate to use XML literals:</para>
      <code>Dim root As XElement = &lt;ElementName&gt;content&lt;/ElementName&gt;
Console.WriteLine(root)</code>
      <para>This example produces the following output:</para>
      <code>&lt;ElementName&gt;content&lt;/ElementName&gt;</code>
      <para>Assigning a string to an <see cref="T:System.Xml.Linq.XName" /> uses the implicit conversion from <see cref="T:System.String" />.</para>
      <para>The Visual Basic example creates the <see cref="T:System.Xml.Linq.XElement" /> using XML literals. Even though XML literals are used, an <see cref="T:System.Xml.Linq.XName" /> object is created for the <see cref="T:System.Xml.Linq.XElement" />.</para>
      <para>In addition, you can call the <see cref="Overload:System.Xml.Linq.XName.Get" /> method for an <see cref="T:System.Xml.Linq.XName" /> object. However, the recommended way is to use the implicit conversion from string.</para>
      <format type="text/html">
        <h2>Creating an XName in a Namespace</h2>
      </format>
      <para>As with XML, an <see cref="T:System.Xml.Linq.XName" /> can be in a namespace, or it can be in no namespace.</para>
      <para>For C#, the recommended approach for creating an <see cref="T:System.Xml.Linq.XName" /> in a namespace is to declare the <see cref="T:System.Xml.Linq.XNamespace" /> object, then use the override of the addition operator.</para>
      <para>For Visual Basic, the recommended approach is to use XML literals and global namespace declarations to create XML that is in a namespace.</para>
      <code>XNamespace aw = "http://www.adventure-works.com";
XElement root = new XElement(aw + "ElementName", "content");
Console.WriteLine(root);</code>
      <code>Imports &lt;xmlns="http://www.adventure-works.com"&gt;

Module Module1
    Sub Main()
        Dim root As XElement = &lt;ElementName&gt;content&lt;/ElementName&gt;
        Console.WriteLine(root)
    End Sub
End Module</code>
      <para>This example produces the following output:</para>
      <code>&lt;ElementName xmlns="http://www.adventure-works.com"&gt;content&lt;/ElementName&gt;</code>
      <format type="text/html">
        <h2>Creating an XName in no Namespace</h2>
      </format>
      <para>The <see cref="P:System.Xml.Linq.XName.Namespace" /> property of an <see cref="T:System.Xml.Linq.XName" /> object is guaranteed to not be null. If the <see cref="T:System.Xml.Linq.XName" /> is in no namespace, then the <see cref="P:System.Xml.Linq.XName.Namespace" /> property will be set to <see cref="P:System.Xml.Linq.XNamespace.None" />. The following code demonstrates this:</para>
      <code>XElement root = new XElement("ElementName", "content");
if (root.Name.Namespace == XNamespace.None)
    Console.WriteLine("The element is in no namespace.");
else
    Console.WriteLine("The element is in a namespace.");</code>
      <code>Dim root As XElement = &lt;ElementName&gt;content&lt;/ElementName&gt;
If (root.Name.Namespace Is XNamespace.None) Then
    Console.WriteLine("The element is in no namespace.")
Else
    Console.WriteLine("The element is in a namespace.")
End If</code>
      <para>This example produces the following output:</para>
      <code>The element is in no namespace.</code>
      <format type="text/html">
        <h2>Using Expanded Names</h2>
      </format>
      <para>You can also create an <see cref="T:System.Xml.Linq.XName" /> from a expanded XML name in the form {namespace}localname:</para>
      <code>XElement root = new XElement("{http://www.adventure-works.com}ElementName", "content");
Console.WriteLine(root);</code>
      <code>Dim root As XElement = New XElement("{http://www.adventure-works.com}ElementName", "content")
Console.WriteLine(root)</code>
      <para>This example produces the following output:</para>
      <code>&lt;ElementName xmlns="http://www.adventure-works.com"&gt;content&lt;/ElementName&gt;</code>
      <para>Be aware that creating an <see cref="T:System.Xml.Linq.XName" /> through an expanded name is less efficient than creating an <see cref="T:System.Xml.Linq.XNamespace" /> object and using the override of the addition operator. It is also less efficient than importing a global namespace and using XML literals in Visual Basic.</para>
      <para>If you create an <see cref="T:System.Xml.Linq.XName" /> using an expanded name, LINQ to XML must find the atomized instance of a namespace. This work must be repeated for every use of an expanded name. This additional time is likely to be negligible when writing LINQ queries; however, it might be significant when creating a large XML tree.</para>
      <format type="text/html">
        <h2>XName Objects are Atomized</h2>
      </format>
      <para>
        <see cref="T:System.Xml.Linq.XName" /> objects are guaranteed to be atomized; that is, if two <see cref="T:System.Xml.Linq.XName" /> objects have exactly the same namespace and exactly the same local name, they will share the same instance. The equality and comparison operators are also provided explicitly for this purpose.</para>
      <para>Among other benefits, this feature allows for faster execution of queries. When filtering on the name of elements or attributes, the comparisons expressed in predicates use identity comparison, not value comparison. It is much faster to determine that two references actually refer to the same object than to compare two strings.</para>
    </remarks>
  </class>
  <class name="XNamespace" fullname="System.Xml.Linq.XNamespace" assembly="System.Xml.Linq">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents an XML namespace. This class cannot be inherited. </para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>This class represents the XML construct of namespaces.</para>
      <para>Every <see cref="T:System.Xml.Linq.XName" /> contains an <see cref="T:System.Xml.Linq.XNamespace" />. Even if an element is not in a namespace, the element's <see cref="T:System.Xml.Linq.XName" /> still contains a namespace, <see cref="P:System.Xml.Linq.XNamespace.None" />. The <see cref="P:System.Xml.Linq.XName.Namespace" /> property is guaranteed to not be null. </para>
      <format type="text/html">
        <h2>Creating an XNamespace Object</h2>
      </format>
      <para>The most common way to create an <see cref="T:System.Xml.Linq.XNamespace" /> object is to simply assign a string to it. You can then combine the namespace with a local name by using the override of the addition operator. The following example shows this idiom:</para>
      <code>XNamespace aw = "http://www.adventure-works.com";
XElement root = new XElement(aw + "Root", "Content");
Console.WriteLine(root);</code>
      <code>Dim aw As XNamespace = "http://www.adventure-works.com"
Dim root As XElement = New XElement(aw + "Root", "Content")
Console.WriteLine(root)</code>
      <para>However, in Visual Basic, you would typically declare a global default namespace, as follows:</para>
      <code>Imports &lt;xmlns='http://www.adventure-works.com'&gt;

Module Module1
    Sub Main()
        Dim root As XElement = _
            &lt;Root&gt;Content&lt;/Root&gt;
        Console.WriteLine(root)
    End Sub
End Module</code>
      <para>This example produces the following output:</para>
      <code>&lt;Root xmlns="http://www.adventure-works.com"&gt;Content&lt;/Root&gt;</code>
      <para>Assigning a string to an <see cref="T:System.Xml.Linq.XNamespace" /> uses the implicit conversion from <see cref="T:System.String" />.</para>
      <para>See <format type="text/html"><a href="af4a595e-ffb2-4187-a61b-d5ed71642c4c">How to: Create a Document with Namespaces (LINQ to XML) (C#)</a></format> for more information and examples.</para>
      <para>See <format type="text/html"><a href="10b7ba7b-518c-4f14-899f-892575d14dcc">Namespaces in Visual Basic (LINQ to XML)</a></format> for more information on using namespaces in vbprvb.</para>
      <format type="text/html">
        <h2>Controlling Namespace Prefixes</h2>
      </format>
      <para>If you create an attribute that declares a namespace, the prefix specified in the attribute will be persisted in the serialized XML. To create an attribute that declares a namespace with a prefix, you create an attribute where the namespace of the name of the attribute is <see cref="P:System.Xml.Linq.XNamespace.Xmlns" />, and the name of the attribute is the namespace prefix. The value of the attribute is the URI of the namespace. The following example shows this idiom:</para>
      <code>XNamespace aw = "http://www.adventure-works.com";
XElement root = new XElement(aw + "Root",
    new XAttribute(XNamespace.Xmlns + "aw", "http://www.adventure-works.com"),
    "Content");
Console.WriteLine(root);</code>
      <code>Dim aw As XNamespace = "http://www.adventure-works.com"
Dim root As XElement = New XElement(aw + "Root", _
    New XAttribute(XNamespace.Xmlns + "aw", "http://www.adventure-works.com"), _
    "Content")
Console.WriteLine(root)</code>
      <para>In vbprvb, instead of creating a namespace node to control namespace prefixes, you would typically use a global namespace declaration:</para>
      <code>Imports &lt;xmlns:aw='http://www.adventure-works.com'&gt;

Module Module1
    Sub Main()
        Dim root As XElement = _
            &lt;aw:Root&gt;Content&lt;/aw:Root&gt;
        Console.WriteLine(root)
    End Sub
End Module</code>
      <para>This example produces the following output:</para>
      <code>&lt;aw:Root xmlns:aw="http://www.adventure-works.com"&gt;Content&lt;/aw:Root&gt;</code>
      <para>For more information, see <format type="text/html"><a href="a40d4479-f1b9-4d8b-8623-445648caed28">How to: Control Namespace Prefixes (C#) (LINQ to XML)</a></format>.</para>
      <format type="text/html">
        <h2>Creating a Default Namespace</h2>
      </format>
      <para>When constructing an attribute that will be a namespace, if the attribute name has the special value of "xmlns", then when the XML tree is serialized, the namespace will be declared as the default namespace. The special attribute with the name of "xmlns" itself is not in any namespace. The value of the attribute is the namespace URI.</para>
      <para>The following example creates an XML tree that contains an attribute that is declared in such a way that the namespace will become the default namespace:</para>
      <code>XNamespace aw = "http://www.adventure-works.com";
XElement root = new XElement(aw + "Root",
    new XAttribute("xmlns", "http://www.adventure-works.com"),
    new XElement(aw + "Child", "content")
);
Console.WriteLine(root);</code>
      <code>Dim aw As XNamespace = "http://www.adventure-works.com"
Dim root As XElement = New XElement(aw + "Root", _
    New XAttribute("xmlns", "http://www.adventure-works.com"), _
    New XElement(aw + "Child", "content") _
)
Console.WriteLine(root)</code>
      <para>In vbprvb, instead of creating a namespace node to create a default namespace, you would typically use a global default namespace declaration:</para>
      <code>Imports &lt;xmlns='http://www.adventure-works.com'&gt;

Module Module1
    Sub Main()
        Dim root As XElement = _
            &lt;Root&gt;
                &lt;Child&gt;content&lt;/Child&gt;
            &lt;/Root&gt;
        Console.WriteLine(root)
    End Sub
End Module</code>
      <para>This example produces the following output:</para>
      <code>&lt;Root xmlns="http://www.adventure-works.com"&gt;
  &lt;Child&gt;content&lt;/Child&gt;
&lt;/Root&gt;</code>
      <format type="text/html">
        <h2>XNamespace Atomization</h2>
      </format>
      <para>
        <see cref="T:System.Xml.Linq.XNamespace" /> objects are guaranteed to be atomized; that is, if two <see cref="T:System.Xml.Linq.XNamespace" /> objects have exactly the same URI, they will share the same instance. The equality and comparison operators are provided explicitly for this purpose.</para>
      <format type="text/html">
        <h2>Using Expanded Names</h2>
      </format>
      <para>Another way to specify a namespace and a local name is to use an expanded name in the form {namespace}name:</para>
      <para>[C#]</para>
      <code>XElement e = new XElement("{http://www.adventure-works.com}Root",
     new XAttribute("{http://www.adventure-works.com}Att", "content")
);
Console.WriteLine(e);</code>
      <code>Dim e As XElement = New XElement("{http://www.adventure-works.com}Root", _
     New XAttribute("{http://www.adventure-works.com}Att", "content") _
)
Console.WriteLine(e)</code>
      <para>This example produces the following output:</para>
      <code>&lt;Root p1:Att="content" xmlns:p1="http://www.adventure-works.com" xmlns="http://www.adventure-works.com" /&gt;</code>
      <para>This approach has performance implications. Each time that you pass a string that contains an expanded name to sqltecxlinq, it must parse the name, find the atomized namespace, and find the atomized name. This process takes CPU time. If performance is important, you may want to use a different approach.</para>
      <para>With Visual Basic, the recommended approach is to use XML literals, which does not involve the use of expanded names.</para>
    </remarks>
  </class>
  <class name="XNode" fullname="System.Xml.Linq.XNode" assembly="System.Xml.Linq">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents the abstract concept of a node (element, comment, document type, processing instruction, or text node) in the XML tree.  </para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>
        <see cref="T:System.Xml.Linq.XNode" /> is an abstract common base class for the following types:</para>
      <list type="bullet">
        <item>
          <para>
            <see cref="T:System.Xml.Linq.XComment" />
          </para>
        </item>
        <item>
          <para>
            <see cref="T:System.Xml.Linq.XContainer" />
          </para>
        </item>
        <item>
          <para>
            <see cref="T:System.Xml.Linq.XDocumentType" />
          </para>
        </item>
        <item>
          <para>
            <see cref="T:System.Xml.Linq.XProcessingInstruction" />
          </para>
        </item>
        <item>
          <para>
            <see cref="T:System.Xml.Linq.XText" />
          </para>
        </item>
      </list>
      <para>
        <see cref="T:System.Xml.Linq.XContainer" /> is an abstract common base class for the following types:</para>
      <list type="bullet">
        <item>
          <para>
            <see cref="T:System.Xml.Linq.XDocument" />
          </para>
        </item>
        <item>
          <para>
            <see cref="T:System.Xml.Linq.XElement" />
          </para>
        </item>
      </list>
      <para>Objects of classes that derive from <see cref="T:System.Xml.Linq.XContainer" /> can contain child nodes.</para>
      <block subset="none" type="note">
        <para>An <see cref="T:System.Xml.Linq.XAttribute" /> is not an <see cref="T:System.Xml.Linq.XNode" />. Attributes are maintained as a list of name/value pairs on an element.</para>
      </block>
      <para>If you are writing a complex XML application, such as an XML editor or a word processor that stores content as XML, you will often work at the node level. Typical activities when working at the node level include adding nodes, deleting nodes, transforming nodes, and iterating through axes that return collections of nodes. </para>
    </remarks>
  </class>
  <class name="XNodeDocumentOrderComparer" fullname="System.Xml.Linq.XNodeDocumentOrderComparer" assembly="System.Xml.Linq">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Contains functionality to compare nodes for their document order. This class cannot be inherited. </para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>This class implements <unmanagedCodeEntityReference>IComparer</unmanagedCodeEntityReference> and <unmanagedCodeEntityReference>IComparer&lt;XNode&gt;</unmanagedCodeEntityReference>. </para>
      <para>We recommend that instead of using this class directly, you use the <see cref="M:System.Xml.Linq.Extensions.InDocumentOrder``1(System.Collections.Generic.IEnumerable{``0})" /> method. This class is used internally by that method.</para>
    </remarks>
  </class>
  <class name="XNodeEqualityComparer" fullname="System.Xml.Linq.XNodeEqualityComparer" assembly="System.Xml.Linq">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Compares nodes to determine whether they are equal. This class cannot be inherited. </para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The purpose of this class is to implement <see cref="T:System.Collections.IEqualityComparer" /> and <see cref="T:System.Collections.Generic.IEqualityComparer`1" />. Classes that require identity (such as <see cref="T:System.Collections.Generic.Dictionary`2" /> ) require an instance of a class that implements one of these interfaces. </para>
    </remarks>
  </class>
  <class name="XObject" fullname="System.Xml.Linq.XObject" assembly="System.Xml.Linq">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents a node or an attribute in an XML tree. </para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>This class is the abstract common base class for <see cref="T:System.Xml.Linq.XNode" /> and <see cref="T:System.Xml.Linq.XAttribute" />. It provides some basic functionality that is common to both classes, such as annotations, and raising events when nodes have changed.</para>
      <para>Note that annotations are not part of the XML infoset; they are not serialized or deserialized.</para>
    </remarks>
  </class>
  <class name="XObjectChange" fullname="System.Xml.Linq.XObjectChange" assembly="System.Xml.Linq">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Specifies the event type when an event is raised for an <see cref="T:System.Xml.Linq.XObject" />.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>This enum specifies the event type when an event is raised for an <see cref="T:System.Xml.Linq.XObject" />.</para>
      <para>All operations that modify the XML tree break down to a series of primitives. There are four types of primitives. Two of the primitives (Add and Remove) act on collections. Two of them (Name and Value) act on instances. There is a corresponding event for each of these primitives. </para>
      <para>You should be careful when modifying an XML tree within one of these events, because doing this might lead to unexpected results. For example, if you receive a <see cref="E:System.Xml.Linq.XObject.Changing" /> event, and while the event is being processed you remove the node from the tree, you might not receive the <see cref="E:System.Xml.Linq.XObject.Changed" /> event. When an event is being processed, it is valid to modify an XML tree other than the one that contains the node that is receiving the event; it is even valid to modify the same tree provided the modifications do not affect the specific nodes on which the event was raised. However, if you modify the area of the tree that contains the node receiving the event, the events that you receive and the impact to the tree are undefined. </para>
    </remarks>
  </class>
  <class name="XObjectChangeEventArgs" fullname="System.Xml.Linq.XObjectChangeEventArgs" assembly="System.Xml.Linq">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Provides data for the <see cref="E:System.Xml.Linq.XObject.Changing" /> and <see cref="E:System.Xml.Linq.XObject.Changed" /> events.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The purpose of this class is to hold the argument that is passed to an event handler when sqltecxlinq raises events. </para>
    </remarks>
  </class>
  <class name="XProcessingInstruction" fullname="System.Xml.Linq.XProcessingInstruction" assembly="System.Xml.Linq">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents an XML processing instruction. </para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>You can use processing instructions in XML to indicate that an XML document can be processed by some processor, such as XSLT. </para>
      <para>Processing instructions are nodes in the XML tree. When a processing instruction is found in the XML being parsed, sqltecxlinq creates an <see cref="T:System.Xml.Linq.XProcessingInstruction" /> node. </para>
    </remarks>
  </class>
  <class name="XStreamingElement" fullname="System.Xml.Linq.XStreamingElement" assembly="System.Xml.Linq">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents elements in an XML tree that supports deferred streaming output.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>This class allows you to create an XML tree that supports deferred streaming output. You use this class to create an XML tree in a very similar fashion to creating an XML tree using <see cref="T:System.Xml.Linq.XElement" />. However, there is a fundamental difference. When you use a LINQ query to specify content when creating an XML tree using <see cref="T:System.Xml.Linq.XElement" />, the query variable is iterated at the time of construction of the XML tree, and the results of the query are added to the XML tree. In contrast, when you create an XML tree using <see cref="T:System.Xml.Linq.XStreamingElement" />, a reference to the query variable is stored in the XML tree without being iterated. Queries are iterated only upon serialization. This allows you to create larger XML trees while maintaining a smaller memory footprint.</para>
      <para>If you are streaming from an input source, such as a text file, then you can read a very large text file, and generate a very large XML document while maintaining a small memory footprint.</para>
      <para>Another scenario is that you have a large XML tree that has been loaded into memory, and you want to create a transformed version of the document. If you create a new document using <see cref="T:System.Xml.Linq.XElement" />, then you will have two large XML trees in memory upon completion of the transformation. However, if you create the new XML tree using <see cref="T:System.Xml.Linq.XStreamingElement" />, then your working set will be effectively cut in half.</para>
      <para>Note that when debugging a program that uses <see cref="T:System.Xml.Linq.XStreamingElement" />, displaying the value of an object causes its <see cref="Overload:System.Xml.Linq.XStreamingElement.ToString" /> method to be called. This causes the XML to be serialized. If the semantics of your streaming element query are such that the streaming element can only be streamed once, this may cause undesirable behavior in your debugging experience.</para>
    </remarks>
  </class>
  <class name="XText" fullname="System.Xml.Linq.XText" assembly="System.Xml.Linq">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents a text node. </para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>XML elements can contain text content. Sometimes the content is simple (the element only contains text content), and sometimes the content is mixed (the contents of the element contains both text and other elements). In either case, each chunk of text is represented as an <see cref="T:System.Xml.Linq.XText" /> node.</para>
      <para>sqltecxlinq developers will often have to write code to work with arbitrary sqltecxlinq trees that they did not create. If you are writing code that has to work with sqltecxlinq trees that you have no control over creating, you should be aware of certain behaviors of <see cref="T:System.Xml.Linq.XText" /> nodes.</para>
      <para>When processing the contents of an XML tree at the node level, you should be prepared for multiple <see cref="T:System.Xml.Linq.XText" /> nodes to be adjacent to each other. Further, you should be prepared for <see cref="T:System.Xml.Linq.XText" /> nodes that contain no text. It is possible through sqltecxlinq methods to remove the content of a text node. However, sqltecxlinq does not automatically delete the node. The node has identity, and might have annotations, so sqltecxlinq allows for zero-length nodes in the tree.</para>
      <para>For more information, see <format type="text/html"><a href="18680d1c-6e7c-4645-8d53-27b5a96f2d3f">Programming With Nodes</a></format>. </para>
    </remarks>
  </class>
</elements>