/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBEncoder;
import com.mongodb.LazyDBObject;
import com.mongodb.MongoException;
import java.io.IOException;
import org.bson.BSONObject;
import org.bson.io.OutputBuffer;

public class LazyDBEncoder
implements DBEncoder {
    public int writeObject(OutputBuffer buf, BSONObject o) {
        if (!(o instanceof LazyDBObject)) {
            throw new IllegalArgumentException("LazyDBEncoder can only encode BSONObject instances of type LazyDBObject");
        }
        LazyDBObject lazyDBObject = (LazyDBObject)o;
        try {
            lazyDBObject.pipe(buf);
        }
        catch (IOException e) {
            throw new MongoException("Exception serializing a LazyDBObject", e);
        }
        return lazyDBObject.getBSONSize();
    }
}

