// generated by ../../../../tools/tube_transfer.py
// tube: 12AX7
// plate current function: triode
// mu: 100
// kx: 1.4
// kg1: 1060
// kg2: 0
// kp: 600
// kvb: 300
// Uin_min: -5
// Uin_max: 5
// Vp: 250
// Rp: 100000

table1d_imp<2001> tubetable_12AX7[2] __rt_data = {
	{ // Ri = 68k
	-5,5,200,2001, {
	249.98706929001784,249.98685122494211,249.98662948898132,249.98640402054366,249.9861747570101,
	249.9859416347178,249.98570458894233,249.9854635538808,249.9852184626337,249.9849692471869,
	249.9847158383935,249.98445816595495,249.98419615840226,249.98392974307677,249.98365884611056,
	249.98338339240652,249.98310330561824,249.98281850812958,249.98252892103372,249.98223446411203,
	249.98193505581267,249.98163061322862,249.98132105207546,249.98100628666896,249.98068622990215,
	249.980360793222,249.98002988660568,249.9796934185369,249.97935129598116,249.9790034243611,
	249.97864970753136,249.978290047753,249.9779243456676,249.97755250027055,249.97717440888485,
	249.97678996713327,249.97639906891115,249.97600160635812,249.97559746982967,249.97518654786796,
	249.9747687271728,249.9743438925714,249.97391192698834,249.97347271141436,249.97302612487553,
	249.9725720444011,249.97211034499136,249.9716408995849,249.9711635790253,249.97067825202723,
	249.9701847851422,249.96968304272383,249.9691728868923,249.96865417749834,249.96812677208703,
	249.96759052586052,249.96704529164043,249.9664909198298,249.9659272583742,249.96535415272237,
	249.96477144578634,249.96417897790073,249.9635765867817,249.962964107485,249.96234137236377,
	249.961708211025,249.96106445028641,249.96040991413162,249.95974442366506,249.95906779706652,
	249.95837984954457,249.95768039328948,249.95696923742543,249.95624618796182,249.9555110477444,
	249.95476361640476,249.95400369031006,249.9532310625115,249.95244552269182,249.95164685711265,
	249.9508348485605,249.9500092762925,249.94916991598058,249.94831653965574,249.94744891565105,
	249.9465668085435,249.9456699790958,249.9447581841967,249.9438311768006,249.94288870586647,
	249.94193051629566,249.94095634886918,249.9399659401836,249.93895902258637,249.93793532411013,
	249.9368945684062,249.93583647467693,249.93476075760725,249.93366712729522,249.93255528918164,
	249.93142494397873,249.9302757875975,249.92910751107468,249.92791980049822,249.92671233693164,
	249.92548479633814,249.92423684950248,249.92296816195298,249.92167839388162,249.9203672000635,
	249.91903422977515,249.9176791267114,249.9163015289019,249.91490106862574,249.91347737232542,
	249.91203006051933,249.9105587477137,249.90906304231274,249.90754254652782,249.90599685628573,
	249.9044255611354,249.90282824415388,249.90120448185047,249.89955384407023,249.89787589389604,
	249.89617018754953,249.89443627429037,249.89267369631514,249.89088198865394,249.8890606790666,
	249.88720928793728,249.8853273281674,249.88341430506824,249.8814697162511,249.87949305151724,
	249.87748379274583,249.8754414137806,249.8733653803157,249.8712551497796,249.8691101712182,
	249.86692988517606,249.864713723577,249.86246110960255,249.8601714575697,249.85784417280695,
	249.85547865152918,249.85307428071104,249.85063043795904,249.84814649138232,249.8456217994619,
	249.84305571091878,249.84044756458053,249.8377966892467,249.8351024035522,249.83236401583068,
	249.82958082397494,249.8267521152971,249.82387716638715,249.82095524296986,249.81798559976045,
	249.81496748031932,249.81190011690495,249.80878273032565,249.80561452978998,249.80239471275593,
	249.79912246477858,249.79579695935675,249.7924173577781,249.7889828089633,249.7854924493082,
	249.78194540252585,249.77834077948626,249.77467767805567,249.77095518293396,249.76717236549166,
	249.7633282836048,249.7594219814899,249.75545248953622,249.7514188241386,249.74731998752785,
	249.7431549676007,249.73892273774888,249.73462225668666,249.73025246827794,249.72581230136188,
	249.72130066957803,249.7167164711905,249.71205858891088,249.70732588972092,249.70251722469402,
	249.69763142881618,249.69266732080604,249.68762370293447,249.68249936084334,249.67729306336392,
	249.67200356233468,249.66662959241825,249.66116987091863,249.6556230975975,249.64998795449,
	249.64426310572122,249.6384471973211,249.63253885704043,249.62653669416574,249.62043929933495,
	249.61424524435236,249.60795308200443,249.60156134587487,249.59506855016076,249.5884731894884,
	249.5817737387299,249.57496865282,249.56805636657347,249.56103529450309,249.55390383063835,
	249.546660348345,249.5393032001452,249.531830717539,249.5242412108263,249.51653296893053,
	249.50870425922338,249.50075332735045,249.49267839705902,249.4844776700264,249.47614932569098,
	249.46769152108428,249.45910239066512,249.45038004615543,249.44152257637862,249.4325280470997,
	249.42339450086806,249.41411995686195,249.40470241073672,249.39513983447432,249.3854301762366,
	249.37557136022113,249.36556128651986,249.35539783098136,249.34507884507627,249.3346021557658,
	249.32396556537412,249.3131668514648,249.30220376672,249.291074038825,249.2797753703559,
	249.26830543867194,249.25666189581239,249.24484236839743,249.2328444575346,249.22066573872945,
	249.20830376180137,249.19575605080482,249.1830201039554,249.17009339356224,249.15697336596492,
	249.14365744147707,249.13014301433554,249.1164274526557,249.10250809839306,249.08838226731126,
	249.07404724895648,249.05950030663922,249.0447386774218,249.02975957211427,249.01456017527633,
	248.99913764522742,248.98348911406393,248.96761168768415,248.95150244582103,248.93515844208312,
	248.9185767040031,248.90175423309523,248.88468800492075,248.86737496916217,248.84981204970572,
	248.8319961447335,248.8139241268237,248.79559284306077,248.77699911515404,248.75813973956645,
	248.73901148765216,248.7196111058045,248.69993531561272,248.67998081402973,248.65974427354877,
	248.63922234239095,248.61841164470246,248.59730878076238,248.57591032720075,248.55421283722714,
	248.53221284086968,248.50990684522492,248.4872913347182,248.46436277137488,248.4411175951024,
	248.41755222398317,248.39366305457864,248.3694464622437,248.34489880145316,248.320016406138,
	248.29479559003389,248.26923264703967,248.24332385158795,248.2170654590259,248.19045370600764,
	248.1634848108975,248.13615497418445,248.1084603789071,248.0803971910901,248.05196156019136,
	248.02314961955977,247.99395748690415,247.96438126477236,247.93441704104163,247.904060889419,
	247.87330886995184,247.84215702954972,247.8106014025152,247.77863801108546,247.74626286598374,
	247.71347196697994,247.68026130346178,247.64662685501435,247.6125645920097,247.5780704762051,
	247.54314046135013,247.50777049380244,247.4719565131523,247.4356944528547,247.3989802408702,
	247.36180980031276,247.32417905010573,247.2860839056444,247.24752027946639,247.20848408192768,
	247.16897122188615,247.12897760739017,247.08849914637392,247.04753174735777,247.0060713201537,
	246.96411377657628,246.92165503115748,246.87869100186614,246.8352176108312,246.79123078506854,
	246.74672645721103,246.70170056624127,246.6561490582272,246.61006788705922,246.56345301518974,
	246.5163004143737,246.46860606641025,246.420365963885,246.37157611091263,246.32223252387925,
	246.27233123218429,246.22186827898153,246.1708397219189,246.11924163387616,246.06707010370158,
	246.01432123694454,245.96099115658697,245.90707600377024,245.85257193851942,245.79747514046258,
	245.74178180954667,245.68548816674777,245.62859045477686,245.57108493877956,245.5129679070303,
	245.45423567161995,245.39488456913705,245.33491096134213,245.2743112358342,245.21308180670994,
	245.151219115215,245.0887196303863,245.02557984968627,244.96179629962793,244.89736553639,
	244.83228414642332,244.76654874704673,244.70015598703256,244.63310254718212,244.56538514089002,
	244.49700051469736,244.42794544883378,244.3582167577479,244.28781129062577,244.21672593189734,
	244.14495760173094,244.0725032565146,243.99935988932532,243.92552453038536,243.85099424750507,
	243.77576614651295,243.69983737167215,243.62320510608328,243.54586657207398,243.46781903157427,
	243.38905978647807,243.3095861789911,243.22939559196416,243.14848544921247,243.06685321582097,
	242.9844963984348,242.90141254553586,242.81759924770498,242.73305413786923,242.64777489153533,
	242.56175922700825,242.4750049055956,242.38750973179737,242.29927155348162,242.21028826204537,
	242.12055779256153,242.0300781239115,241.93884727890335,241.84686332437636,241.75412437129083,
	241.66062857480472,241.56637413433592,241.47135929361073,241.3755823406994,241.2790416080374,
	241.18173547243373,241.08366235506602,240.98482072146234,240.88520908147052,240.78482598921426,
	240.68367004303693,240.58173988543297,240.47903420296706,240.37555172618104,240.27129122948944,
	240.16625153106293,240.06043149270053,239.95383001969066,239.84644606066104,239.73827860741778,
	239.62932669477416,239.51958940036852,239.40906584447282,239.2977551897902,239.18565664124398,
	239.07276944575668,238.95909289201964,238.84462631025423,238.72936907196387,238.61332058967784,
	238.4964803166868,238.37884774677025,238.26042241391625,238.14120389203384,238.02119179465782,
	237.90038577464702,237.7787855238753,237.65639077291644,237.53320129072242,237.40921688429594,
	237.28443739835726,237.1588627150048,237.03249275337134,236.9053274692745,236.7773668548627,
	236.64861093825652,236.51905978318544,236.3887134886207,236.2575721884043,236.12563605087408,
	235.99290527848535,235.8593801074297,235.72506080725026,235.58994768045457,235.45404106212442,
	235.31734131952388,235.1798488517046,235.04156408910967,234.90248749317516,234.7626195559303,
	234.6219607995967,234.4805117761856,234.33827306709475,234.19524528270404,234.0514290619707,
	233.90682507202402,233.76143400775973,233.6152565914341,233.4682935722581,233.32054572599213,
	233.1720138545404,233.02269878554645,232.87260137198868,232.72172249177734,232.5700630473517,
	232.4176239652789,232.2644061958536,232.1104107126991,231.95563851236957,231.80009061395464,
	231.64376805868451,231.48667190953782,231.3288032508507,231.1701631879286,231.01075284665924,
	230.85057337312855,230.68962593323832,230.52791171232687,230.3654319147914,230.20218776371357,
	230.03818050048721,229.87341138444904,229.70788169251213,229.54159271880172,229.37454577429492,
	229.20674218646232,229.0381832989134,228.8688704710446,228.69880507769085,228.5279885087797,
	228.3564221689897,228.1841074774109,228.01104586720962,227.83723878529622,227.662687691996,
	227.48739406072397,227.311359377663,227.13458514144529,226.95707286283758,226.77882406442967,
	226.59984028032684,226.4201230558455,226.23967394721282,226.05849452126972,225.87658635517738,
	225.69395103612814,225.5105901610589,225.32650533636937,225.1416981776429,224.95617030937228,
	224.7699233646876,224.58295898508956,224.39527882018476,224.20688452742627,224.01777777185643,
	223.82796022585453,223.6374335688872,223.44619948726307,223.25425967389086,223.06161582804123,
	222.8682696551119,222.6742228663969,222.47947717885882,222.2840343149054,222.08789600216886,
	221.89106397328928,221.69353996570155,221.49532572142562,221.2964229868599,221.0968335125793,
	220.89655905313515,220.69560136685996,220.4939622156745,220.291643364899,220.08864658306726,
	219.88497364174435,219.68062631534747,219.4756063809702,219.26991561820975,219.06355580899782,
	218.85652873743436,218.64883618962452,218.44047995351897,218.23146181875723,218.0217835765136,
	217.8114470193471,217.6004539410537,217.3888061365216,217.17650540159002,216.96355353291014,
	216.74995232780978,216.53570358415996,216.32080910024564,216.1052706746378,215.8890901060696,
	215.6722691933143,215.4548097350667,215.23671352982674,215.0179823757859,214.79861807071637,
	214.57862241186294,214.35799719583696,214.13674421851337,213.91486527492995,213.69236215918932,
	213.4692366643632,213.24549058239893,213.0211257040291,212.7961438186826,212.5705467143988,
	212.34433617774366,212.11751399372812,211.89008194572907,211.66204181541238,211.43339538265778,
	211.20414442548662,210.97429071999127,210.74383604026673,210.51278215834483,210.28113084412962,
	210.04888386533565,209.81604298742786,209.5826099735636,209.3485865845366,209.11397457872295,
	208.87877571202912,208.64299173784138,208.4066244069782,208.1696754676431,207.93214666538066,
	207.69403974303364,207.45535644070225,207.21609849570464,206.9762676425401,206.73586561285325,
	206.4948941354005,206.2533549360177,206.01124973759,205.76858026002327,205.52534822021704,
	205.2815553320393,205.03720330630264,204.79229385074285,204.54682866999806,204.3008094655901,
	204.0542379359079,203.8071157761913,203.5594446785176,203.31122633178913,203.06246242172264,
	202.81315463084,202.56330463846066,202.31291412069567,202.06198475044323,201.81051819738573,
	201.5585161279886,201.30598020550016,201.05291208995385,200.79931343817117,200.54518590376676,
	200.29053113715491,200.0353507855575,199.77964649301347,199.52341990039037,199.26667264539682,
	199.0094063625968,198.75162268342612,198.49332323620953,198.23450964618036,197.97518353550097,
	197.7153465232859,197.4550002256256,197.19414625561285,196.93278622337004,196.67092173607898,
	196.40855439801203,196.14568581056514,195.88231757229266,195.61845127894412,195.35408852350312,
	195.08923089622752,194.82387998469224,194.5580373738338,194.29170464599693,194.02488338098334,
	193.75757515610252,193.48978154622466,193.22150412383627,192.9527444590975,192.68350411990224,
	192.4137846719405,192.14358767876317,191.8729147018496,191.6017673006773,191.33014703279508,
	191.05805545389808,190.78549411790655,190.5124645770467,190.23896838193525,189.96500708166673,
	189.69058222390413,189.41569535497266,189.1403480199574,188.86454176280373,188.58827812642213,
	188.31155865279655,188.03438488309607,187.75675835779165,187.47868061677596,187.20015319948843,
	186.92117764504385,186.64175549236649,186.3618882803282,186.081577547892,185.80082483426042,
	185.51963167902923,185.23799962234668,184.95593020507863,184.673424968979,184.39048545686688,
	184.1071132128098,183.8233097823133,183.53907671251758,183.2544155524013,182.96932785299217,
	182.68381516758586,182.397879051972,182.11152106466898,181.824742767167,181.5375457241795,
	181.2499315039047,180.96190167829545,180.6734578233398,180.38460151935104,180.09533435126934,
	179.80565790897313,179.51557378760265,179.22508358789537,178.9341889165334,178.64289138650366,
	178.35119261747167,178.05909423616848,177.76659787679256,177.4737051814259,177.180417800466,
	176.88673739307316,176.59266562763537,176.29820418224924,176.00335474521978,175.7081190155779,
	175.4124987036179,175.11649553145438,174.82011123360013,174.52334755756544,174.22620626447977,
	173.92868912973674,173.63079794366269,173.33253451221088,173.03390065768082,172.73489821946524,
	172.43552905482403,172.1357950396877,171.83569806949083,171.53524006003602,171.23442294839063,
	170.93324869381678,170.63171927873555,170.3298367097279,170.02760301857208,169.7250202633199,
	169.4220905294129,169.11881593084007,168.81519861133825,168.51124074563697,168.20694454074942,
	167.90231223731104,167.5973461109672,167.29204847381226,166.98642167588093,166.68046810669497,
	166.3741901968658,166.06759041975565,165.76067129319947,165.4534353812889,165.1458852962211,
	164.838023700214,164.52985330749047,164.22137688633373,163.91259726121604,163.60351731500313,
	163.29413999123662,162.98446829649706,162.67450530285024,162.3642541503786,162.05371804980075,
	161.74290028518195,161.43180421673796,161.12043328373403,160.8087910074848,160.4968809944489,
	160.1847069394394,159.87227262892935,159.5595819444733,159.24663886623867,158.93344747665324,
	158.62001196416912,158.30633662714777,157.99242587786787,157.678284246658,157.36391638615797,
	157.04932707570995,156.73452122588245,156.4195038831292,156.10428023458493,155.78885561299973,
	155.47323550181454,155.15742554037797,154.8414315293076,154.52525943599503,154.208915400257,
	153.892405740132,153.57573695782344,153.25891574578856,152.94194899297338,152.6248437911915,
	152.30760744164638,151.9902474615948,151.6727715911488,151.35518780021346,151.03750429555575,
	150.71972952800186,150.40187219975527,150.08394127183246,149.76594597160647,149.4478958004533,
	149.12980054149003,148.8116702673969,148.49351534831095,148.17534645978006,147.8571745907642,
	147.5390110516689,147.22086748239545,146.90275586039053,146.58468850867678,146.26667810384353,
	145.94873768397673,145.63088065650393,145.31312080592957,144.99547230143423,144.67794970430782,
	144.36056797518842,144.04334248107313,143.7262890020675,143.40942373783747,143.09276331372735,
	142.7763247865023,142.46012564967666,142.14418383838378,141.8285177337426,141.5131461666768,
	141.19808842113702,140.88336423667903,140.5689938103463,140.25499779780858,139.9413973137017,
	139.62821393111972,139.31546968020365,139.0031870457775,138.6913889639766,138.38009881781875,
	138.06934043166606,137.75913806452942,137.44951640216718,137.14050054793364,136.83211601233373,
	136.52438870124584,136.21734490277527,135.9110112727083,135.60541481853804,135.30058288204188,
	134.99654312039232,134.69332348579292,134.39095220363353,134.08945774917046,133.78886882274085,
	133.48921432353097,133.19052332192467,132.89282503046874,132.5961487734982,132.3005239554755,
	132.0059800281066,131.71254645630353,131.42025268307617,131.12912809344115,130.8392019774463,
	130.55050349241762,130.26306162454264,129.97690514991203,129.69206259514868,129.4085621977583,
	129.1264318663425,128.84569914081854,128.56639115279435,128.28853458624954,128.01215563867495,
	127.73727998282354,127.46393272922487,127.19213838961332,126.92192084141826,126.65330329345828,
	126.3863082529789,126.12095749416481,125.85727202825153,125.59527207535284,125.33497703811106,
	125.07640547726785,124.81957508924151,124.56450268578712,124.31120417580254,124.05969454933269,
	123.80998786381099,123.5620972325653,123.31603481560313,123.07181181267828,122.82943845862876,
	122.58892402096564,122.35027679967885,122.11350412921733,121.87861238258922,121.64560697751942,
	121.41449238459226,121.18527213730002,120.95794884390972,120.7325242010559,120.50899900896047,
	120.28737318817691,120.06764579775243,119.84981505469923,119.63387835466338,119.4198322936802,
	119.20767269090321,118.9973946121955,118.7889923944726,118.58245967068908,118.3777893953613,
	118.17497387052457,117.97400477202342,117.77487317604013,117.57756958576867,117.38208395814699,
	117.18840573056504,116.99652384747037,116.80642678679813,116.61810258615827,116.4315388687167,
	116.24672286871257,116.06364145656026,115.88228116348661,115.70262820566265,115.52466850779066,
	115.34838772611364,115.17377127081856,115.00080432780796,114.82947187982073,114.6597587268835,
	114.4916495060813,114.32512871063648,114.16018070828986,113.99678975898092,113.83494003182514,
	113.6746156213912,113.51580056328129,113.358478849021,113.20263444026644,113.0482512823382,
	112.89531331709377,112.74380449515019,112.59370878747093,112.44501019633188,112.29769276568139,
	112.15174059091105,112.00713782805366,111.86386870242606,111.7219175167341,111.58126865865776,
	111.44190660793474,111.30381594296004,111.16698134692044,111.03138761348117,110.89701965204338,
	110.76386249258981,110.6319012901359,110.5011213288044,110.37150802553953,110.24304693347759,
	110.11572374499049,109.9895242944175,109.86443456050077,109.74044066853982,109.61752889227888,
	109.49568565554195,109.37489753362806,109.25515125448109,109.13643369964555,109.01873190502148,
	108.9020330614295,108.7863245149976,108.67159376738049,108.55782847582142,108.44501645306704,
	108.33314566714436,108.2222042410086,108.11218045207157,108.00306273161749,107.89483966411535,
	107.78749998643448,107.68103258694521,107.57542650466816,107.4706709280772,107.36675519411101,
	107.26366878697603,107.16140133692113,107.05994261895778,106.95928255153221,106.85941119515313,
	106.76031875097974,106.66199555937447,106.5644320984237,106.46761898243066,106.37154696038391,
	106.27620691440417,106.18158985817327,106.08768693534769,105.99448941795902,105.90198870480486,
	105.81017631983138,105.71904391051054,105.6285832462137,105.53878621658357,105.44964482990632,
	105.3611512114855,105.27329760201928,105.18607635598259,105.09947994001523,105.01350093131742,
	104.92813201605374,104.84336598776683,104.75919574580115,104.67561429373858,104.59261473784578,
	104.51019028553463,104.42833424383652,104.34704001789015,104.26630110944474,104.1861111153781,
	104.10646372623033,104.02735272475395,103.94877198447985,103.87071546830045,103.79317722706962,
	103.71615139821982,103.63963220439646,103.56361395211019,103.4880910304064,103.41305790955293,
	103.33850913974528,103.26443934982979,103.19084324604484,103.11771561077988,103.04505130135239,
	102.97284524880259,102.90109245670618,102.82978800000458,102.75892702385303,102.688504742486,
	102.61851643810039,102.54895745975567,102.4798232222917,102.4111092052631,102.34281095189091,
	102.27492406803076,102.20744422115796,102.14036713936862,102.0736886103972,102.00740448065034,
	101.94151065425622,101.87600309212979,101.81087781105371,101.74613088277403,101.68175843311168,
	101.61775664108856,101.55412173806809,101.49085000691073,101.42793778114368,101.36538144414448,
	101.30317742833863,101.24132221441123,101.17981233053158,101.11864435159136,101.05781489845607,
	100.99732063722888,100.93715827852766,100.8773245767742,100.8178163294959,100.75863037663927,
	100.69976359989565,100.64121292203848,100.58297530627206,100.52504775559156,100.46742731215433,
	100.4101110566331,100.3530961077279,100.29637962138554,100.23995879034013,100.1838308435043,
	100.12799304540327,100.072442695619,100.01717712824349,99.96219371134228,99.90748984642661,
	99.85306296793526,99.79891054272524,99.74503006957119,99.69141907867373,99.63807513117618,
	99.58499581868978,99.53217876282699,99.47962161474307,99.42732205468545,99.375277791551,
	99.32348656245094,99.27194613228309,99.22065429331201,99.16960886475553,99.11880769237938,
	99.06824864809799,99.01792962958272,98.96784855987644,98.91800338701475,98.86839208365414,
	98.81901264670586,98.76986309697651,98.7209414788145,98.67224585976274,98.62377433021713,
	98.57552500309086,98.52749601348432,98.47968551836082,98.43209169622772,98.38471274682266,
	98.33754689080556,98.29059236945545,98.2438474443726,98.19731039718548,98.15097952926268,
	98.10485316142997,98.05892963369138,98.0132073049557,97.96768455276707,97.92235977304013,
	97.8772313797996,97.83229780492434,97.78755749789525,97.7430089255476,97.69865057182763,
	97.65448093755249,97.61049854017506,97.56670191355163,97.5230896077141,97.47966018864575,
	97.43641223806031,97.39334435318506,97.35045514654718,97.30774324576373,97.26520729333491,
	97.22284594644063,97.18065787674051,97.13864177017693,97.09679632678129,97.05512026048353,
	97.01361229892431,96.97227118327069,96.93109566803425,96.8900845208925,96.84923652251274,
	96.80855046637913,96.76802515862221,96.72765941785096,96.68745207498802,96.64740197310688,
	96.60750796727216,96.56776892438198,96.52818372301293,96.48875125326761,96.44947041662428,
	96.41034012578895,96.37135930454974,96.33252688763362,96.29384182056506,96.25530305952724,
	96.21690957122489,96.17866033274979,96.1405543314478,96.10259056478841,96.06476804023583,
	96.02708577512219,95.98954279652287,95.95213814113339,95.91487085514832,95.8777399941421,
	95.84074462295135,95.80388381555917,95.76715665498129,95.73056223315349,95.69409965082123,
	95.65776801743037,95.62156645101996,95.58549407811631,95.54955003362888,95.51373346074743,
	95.47804351084088,95.44247934335759,95.40704012572704,95.37172503326302,95.33653324906821,
	95.30146396394014,95.26651637627852,95.2316896919938,95.1969831243856,95.16239589418375,
	95.12792722926105,95.09357636468391,95.05934254259219,95.02522501211526,94.99122302928977,
	94.95733585697796,94.9235627647876,94.88990302899276,94.85635593245593,94.82292076455104,
	94.78959682108771,94.75638340423646,94.723279822455,94.69028539041558,94.6573994289333,
	94.62462126489551,94.591950231192,94.5593856666463,94.52692691594812,94.49457332958612,
	94.46232426378228,94.43017908042683,94.39813714701404,94.36619783657893,94.3343605276351,
	94.30262460411288,94.27098945529885,94.23945447577584,94.20801906536391,94.17668262906199,
	94.14544457699043,94.11430432433424,94.08326129128719,94.0523149029965,94.02146458950838,
	93.99070978571424,93.96004993129782,93.92948447068248,93.89901285297998,93.86863453193912,
	93.83834896589575,93.80815561772282,93.77805395478174,93.74804344887369,93.71812357619214,
	93.68829381727559,93.65855365696125,93.62890258433899,93.59934009270609,93.56986567952258,
	93.54047884636714,93.51117909889348,93.48196594678724,93.45283890372373,93.4237974873258,
	93.39484121912272,93.36596962450913,93.3371822327047,93.30847857671444,93.27985819328926,
	93.25132062288723,93.22286540963512,93.19449210129075,93.16620024920537,93.13798940828688,
	93.10985913696351,93.08180899714738,93.05383855419946,93.0259473768942,92.9981350373848,
	92.9704011111691,92.94274517705574,92.91516681713064,92.887665616724,92.860241164378,
	92.83289305181411,92.80562087390172,92.77842422862642,92.75130271705919,92.72425594332553,
	92.69728351457532,92.67038504095285,92.64356013556727,92.61680841446326,92.59012949659237,
	92.56352300378433,92.53698856071902,92.51052579489846,92.4841343366195,92.45781381894649,
	92.43156387768447,92.40538415135265,92.37927428115815,92.35323391097005,92.32726268729394,
	92.30136025924637,92.27552627852998,92.24976039940873,92.22406227868349,92.19843157566784,
	92.17286795216427,92.14737107244046,92.12194060320611,92.09657621358976,92.07127757511606,
	92.04604436168323,92.02087624954076,91.9957729172675,91.97073404574978,91.94575931815993,
	91.920848419935,91.89600103875583,91.87121686452606,91.8464955893518,91.82183690752117,
	91.79724051548419,91.77270611183306,91.7482333972823,91.72382207464953,91.6994718488361,
	91.6751824268082,91.65095351755022,91.62678483216067,91.60267608365696,91.5786269870788,
	91.55463725943879,91.53070661970483,91.50683478878233,91.483021489497,91.45926644657763,
	91.43556938663895,91.41193003816508,91.38834813149256,91.36482339879436,91.34135557406306,
	91.31794439309523,91.29458959347525,91.27129091455966,91.24804809746146,91.22486088503494,
	91.20172902186013,91.17865225422801,91.15563033012536,91.13266299922013,91.10975001284679,
	91.08689112399186,91.06408608727969,91.04133465895818,91.01863659688497,90.99599166051345,
	90.97339961087908,90.95086021058586,90.92837322379295,90.9059384162013,90.88355555504057,
	90.86122440905616,90.83894474849629,90.8167163450993,90.79453897208104,90.77241240412239,
	90.750336417357,90.72831078935896,90.70633529913076,90.68440972709138,90.6625338550644,
	90.64070746626628,90.61893034529479,90.59720227811752,90.57552305206052,90.55389245579696,
	90.5323102793362,90.51077631401265,90.48929035247477,90.46785218867443,90.44646161785614,
	90.42511843654653,90.40382244254371,90.3825734349072,90.3613712139473,90.3402155812152,
	90.3191063394928,90.29804329278276,90.2770262462987,90.25605500645524,90.23512938085864,
	90.21424917829691,90.19341420873054,90.17262428328306,90.15187921423161,90.13117881499808,
	90.11052290013951,90.08991128533954,90.0693437873991,90.04882022422788,90.02834041483528,
	90.00790417932187,89.98751133887087,89.96716171573948,89.94685513325058,89.92659141578423,
	89.90637038876964,89.8861918786767,89.86605571300811,89.84596172025057,89.82590973003806,
	89.80589957287255,89.78593108030832,89.76600408489283,89.74611842015918,89.72627392061857,
	89.70647042175263,89.68670776000614,89.6669857727796,89.64730429842189,89.62766317622307,
	89.60806224640731,89.58850135012564,89.56898032944898,89.5494990273612,89.53005728775214,
	89.51065495541098,89.49129187601916,89.4719678961439,89.45268286323143,89.4334366256005,
	89.4142290324358,89.39505993378144,89.37592918053461,89.35683662443925,89.33778211807969,
	89.31876551487443,89.29978666907004,89.28084543573493,89.26194167075332,89.2430752308063,
	89.22424597342804,89.20545375688332,89.18669844026577,89.1679798837957,89.14929794709589,
	89.13065249262934,89.11204338225453,89.09347047891706,89.07493364635675,89.05643274904014,
	89.03796765218772,89.01953822176164,89.00114432446067,88.9827858277145,88.96446259967884,
	88.94617450922996,88.92792142595974,88.90970322017039,88.89151976286944,88.87337092576477,
	88.85525658125955,88.83717660244727,88.81913086310709,88.80111923769857,88.78314160135723,
	88.76519782988966,88.74728779976876,88.72941138812901,88.71156847276201,88.69375893211166,
	88.67598264526976,88.65823949197132,88.6405293525903,88.62285210813494,88.6052076402434,
	88.5875958311795,88.5700165638283,88.55246972169179,88.53495518888458,88.51747285012983,
	88.50002259080594,88.48260429675013,88.46521785452737,88.44786315125344,88.43054007463196,
	88.41324851295047,88.39598835507634,88.3787594904529,88.36156180909556,88.3443952015879,
	88.3272595590777,88.31015477327331,88.29308073643976,88.27603734139501,88.2590244815063,
	88.24204205068635,88.22508994338976,88.20816805460939,88.19127627987275,88.17441451523838,
	88.15758265729237,88.14078060314485,88.1240082504264,88.10726549728484,88.09055224238145,
	88.07386838488786,88.05721382448263,88.0405884613477,88.0239921961654,88.00742493011488,
	87.99088656486897,87.97437700259097,87.95789614593143,87.94144389802476,87.9250201624865,
	87.90862484340975,87.89225784536232,87.87591907338349,87.85960843298115,87.84332583012859,
	87.82707117126151,87.81084436327518,87.79464531352126,87.77847392980502,87.76233012038239,
	87.74621379395704,87.73012485967749,87.71406322713439,87.69802880635751,87.68202150781306,
	87.66604124240092,87.65008792145183,87.63416145672463,87.61826176040361,87.6023887450958,
	87.58654232382831,87.57072241004559,87.5549289176069,87.5391617607837,87.52342085425694,
	87.50770611311464,87.49201745284925,87.47635478935518,87.46071803892616,87.44510711825298,
	87.4295219444207,87.41396243490651,87.39842850757714,87.38292008068639,87.36743707287287,
	87.35197940315754,87.33654699094134,87.32113975600294,87.30575761849626,87.2904004989483,
	87.27506831825677,87.25976099768788,87.24447845887401,87.22922062381159,87.21398741485862,
	87.19877875473288,87.18359456650931,87.16843477361822,87.15329929984273,87.13818806931701,
	87.12310100652398,87.10803803629317,87.09299908379869,87.07798407455715,87.0629929344256,
	87.04802558959945,87.03308196661048,87.01816199232482,87.0032655939409,86.98839269898757,
	86.97354323532198,86.95871713112773,86.94391431491299,86.92913471550835,86.91437826203472,
	86.89964488402019,86.88493451122379,86.87024707374741,86.85558250200604,86.84094072672596,
	86.82632167894288,86.81172529000017,86.797151491547,86.78260021553666,86.76807139422459,
	86.75356496016671,86.73908084621783,86.72461898552959,86.71017931154898,86.69576175801657,
	86.6813662589647,86.66699274871596,86.65264116188135,86.63831143335871,86.62400349833102,
	86.60971729226485,86.59545275090855,86.5812098102908,86.56698840671892,86.55278847677731,
	86.53860995732578,86.52445278549814,86.51031689870041,86.49620223460953,86.48210873117154,
	86.46803632660031,86.45398495937584,86.43995456824285,86.4259450922092,86.41195647054447,
	86.39798864277843,86.38404154869968,86.37011512835403,86.35620932204313,86.34232407032317,
	86.32845931400311,86.31461499414368,86.30079105205563,86.28698742929855,86.27320406767934,
	86.25944090925097,86.24569789631097,86.23197497140018,86.2182720773013,86.20458915703769,
	86.19092615387187,86.17728301130431,86.16365967307213,86.15005608314772,86.13647218573745,
	86.12290792528042,86.10936324644722,86.09583809413859,86.08233241348415,86.06884614984124,
	86.05537924879354,86.04193165614996,86.02850331794339,86.01509418042943,86.00170419008519,
	85.9883332936081,85.97498143791474,85.9616485701396,85.94833463763402,85.93503958796481,
	85.92176336891329,85.90850592847407,85.8952672148538,85.88204717647027,85.86884576195091,
	85.85566292013206,85.84249860005768,85.82935275097807,85.81622532234911,85.80311626383092,
	85.79002552528677,85.77695305678222,85.76389880858376,85.75086273115797,85.7378447751703,
	85.72484489148415,85.71186303115972,85.69889914545301,85.68595318581487,85.67302510388976,
	85.66011485151498,85.6472223807195,85.63434764372302,85.62149059293489,85.60865118095327,
	85.59582936056403,85.58302508473969,85.57023830663869,85.55746897960421,85.54471705716328,
	85.53198249302588,85.51926524108386,85.50656525541012,85.49388249025763,85.48121690005847,
	85.46856843942301,85.45593706313883,85.44332272616992,85.43072538365578,85.41814499091043,
	85.4055815034216,85.39303487684985,85.38050506702757,85.36799202995824,85.35549572181547,
	85.34301609894213,85.33055311784959,85.31810673521672,85.30567690788907,85.29326359287823,
	85.28086674736066,85.2684863286771,85.25612229433162,85.24377460199081,85.2314432094831,
	85.21912807479764,85.20682915608388,85.1945464116504,85.1822797999644,85.1700292796507,
	85.15779480949104,85.14557634842332,85.13337385554082,85.12118729009126,85.10901661147629,
	85.09686177925055,85.08472275312099,85.072599492946,85.06049195873484,85.04840011064668,
	85.0363239089901,85.02426331422213,85.01221828694761,85.00018878791856,84.98817477803321,
	84.97617621833555,84.9641930700144,84.9522252944029,84.94027285297757,84.92833570735785,
	84.91641381930518,84.9045071507225,84.89261566365337,84.88073932028149,84.86887808292984,
	84.85703191406017,84.84520077627204,84.8333846323026,84.82158344502547,84.80979717745035,
	84.79802579272231,84.78626925412112,84.77452752506049,84.7628005690877,84.75108834988266,
	84.73939083125747,84.7277079771557,84.71603975165175,84.70438611895031,84.69274704338565,
	84.681122489421,84.66951242164801,84.65791680478613,84.64633560368185,84.63476878330823,
	84.62321630876448,84.61167814527487,84.60015425818862,84.58864461297907,84.5771491752431,
	84.5656679107006,84.55420078519394,84.54274776468728,84.53130881526607,84.51988390313642,
	84.50847299462453,84.49707605617634,84.48569305435659,84.4743239558486,84.4629687274535,
	84.4516273360899,84.44029974879305,84.42898593271453,84.41768585512162,84.4063994833968,
	84.39512678503715,84.3838677276539,84.37262227897182,84.36139040682873,84.35017207913756,
	84.33896726403361,84.32777592965516,84.31659804428715,84.30543357632486,84.29428249427355,
	84.283144766748,84.27202036247186,84.26090925027735,84.24981139910459,84.23872677800108,
	84.22765535612146,84.21659710272674,84.20555198718395,84.1945199789657,84.1835010476496,
	84.17249516291776,84.16150229455647,84.15052241245559,84.1395554866082,84.12860148710993,
	84.11766038415875,84.10673214805428,84.09581674919758,84.08491415809038,84.07402434533498,
	84.06314728163342,84.05228293778734,84.04143128469751,84.03059229336309,84.01976593488155,
	84.00895218044803,83.99815100135496,83.98736236899165,83.97658625484377,83.965822630493,
	83.95507146761656,83.94433273798688,83.93360641347104,83.92289246603048,83.9121908677204,
	83.90150159068959,83.89082460717984,83.88015988952556,83.86950741015343,83.85886714158191,
	83.84823905642095,83.83762312737146,83.82701932722503,83.81642762886338,83.80584800525816,
	83.79528042947041,83.78472487465022,83.77418131403631,83.76364972095575,83.75313006882337,
	83.74262233114163,83.73212648150006,83.72164249357488,83.71117034112878,83.70070999801038,
	83.69026143815394,83.67982463557892,83.66939956438982,83.65898619877541,83.64858451300888,
	83.638194481447,83.62781607853007,83.61744927878146,83.6070940568072,83.59675038729574,
	83.58641824501753,83.57609760482461,83.56578844165043,83.55549073050932,83.54520444649623,
	83.53492956478647,83.52466606063516,83.51441390937703,83.50417308642616,83.49394356727542,
	83.48372532749639,83.4735183427387,83.46332258873015,83.4531380412759,83.44296467625854,
	83.43280246963748,83.42265139744876,83.41251143580476,83.40238256089376,83.39226474897974,
	83.38215797640197,83.37206221957473,83.36197745498707,83.35190365920232,83.34184080885795,
	83.3317888806652,83.32174785140877,83.31171769794643,83.30169839720895,83.29168992619948,
	83.28169226199354,83.27170538173854,83.26172926265352,83.25176388202888,83.24180921722609,
	83.2318652456774,83.22193194488545,83.21200929242315,83.2020972659332,83.19219584312798,
	83.18230500178916,83.17242471976739,83.16255497498217,83.15269574542133,83.14284700914098,
	83.13300874426513,83.12318092898532,83.11336354156059,83.1035565603169,83.09375996364716,
	83.08397373001063,83.07419783793303,83.0644322660059,83.05467699288663,83.04493199729794,
	83.03519725802782,83.0254727539292,83.0157584639196,83.00605436698103,82.99636044215954,
	82.98667666856514,82.97700302537142,82.96733949181538,82.9576860471971,82.94804267087949,
	82.93840934228817,82.92878604091105,82.91917274629812,82.9095694380613,82.89997609587402,
	82.89039269947119,82.88081922864879,82.87125566326364,82.86170198323326,82.85215816853551,
	82.84262419920844,82.83310005534999,82.82358571711774,82.81408116472885,82.80458637845949,
	82.79510133864497,82.78562602567919,82.77616042001473,82.76670450216228,82.75725825269062,
	82.7478216522264,82.73839468145383,82.72897732111443,82.71956955200696,82.71017135498698,
	82.70078271096683,82.69140360091528,82.68203400585733,82.67267390687407,82.6633232851023,
	82.65398212173453,82.6446503980185,82.6353280952573,82.62601519480872,82.61671167808555,
	82.60741752655484,82.59813272173818,82.5888572452111,82.57959107860307,82.57033420359723,
	82.56108660193019,82.55184825539185,82.54261914582509,82.53339925512579,82.52418856524235,
	82.51498705817568,82.50579471597891,82.49661152075723,82.4874374546677,82.478272499919,
	82.46911663877123,82.45996985353584,82.45083212657524,82.44170344030276,82.4325837771824,
	82.42347311972861,82.41437145050612,82.40527875212982,82.39619500726438,82.3871201986243,
	82.37805430897357,82.36899732112555,82.35994921794257,82.35090998233618,82.34187959726655,
	82.33285804574254,82.3238453108213,82.31484137560832,82.30584622325713,82.29685983696905,
	82.28788219999318
	}},
	{ // Ri = 250k
	-5,5,200,2001, {
	249.98706929001784,249.98685122494211,249.98662948898132,249.98640402054366,249.9861747570101,
	249.9859416347178,249.98570458894233,249.9854635538808,249.9852184626337,249.9849692471869,
	249.9847158383935,249.98445816595495,249.98419615840226,249.98392974307677,249.98365884611056,
	249.98338339240652,249.98310330561824,249.98281850812958,249.98252892103372,249.98223446411203,
	249.98193505581267,249.98163061322862,249.98132105207546,249.98100628666896,249.98068622990215,
	249.980360793222,249.98002988660568,249.9796934185369,249.97935129598116,249.9790034243611,
	249.97864970753136,249.978290047753,249.9779243456676,249.97755250027055,249.97717440888485,
	249.97678996713327,249.97639906891115,249.97600160635812,249.97559746982967,249.97518654786796,
	249.9747687271728,249.9743438925714,249.97391192698834,249.97347271141436,249.97302612487553,
	249.9725720444011,249.97211034499136,249.9716408995849,249.9711635790253,249.97067825202723,
	249.9701847851422,249.96968304272383,249.9691728868923,249.96865417749834,249.96812677208703,
	249.96759052586052,249.96704529164043,249.9664909198298,249.9659272583742,249.96535415272237,
	249.96477144578634,249.96417897790073,249.9635765867817,249.962964107485,249.96234137236377,
	249.961708211025,249.96106445028641,249.96040991413162,249.95974442366506,249.95906779706652,
	249.95837984954457,249.95768039328948,249.95696923742543,249.95624618796182,249.9555110477444,
	249.95476361640473,249.95400369031006,249.9532310625115,249.95244552269182,249.95164685711265,
	249.9508348485605,249.9500092762925,249.94916991598058,249.94831653965574,249.94744891565105,
	249.9465668085435,249.9456699790958,249.9447581841967,249.9438311768006,249.94288870586647,
	249.94193051629566,249.94095634886918,249.9399659401836,249.93895902258637,249.93793532411013,
	249.9368945684062,249.93583647467693,249.93476075760725,249.93366712729522,249.93255528918164,
	249.93142494397873,249.9302757875975,249.92910751107468,249.92791980049822,249.92671233693164,
	249.92548479633814,249.92423684950248,249.92296816195298,249.92167839388162,249.9203672000635,
	249.91903422977515,249.9176791267114,249.9163015289019,249.91490106862574,249.91347737232542,
	249.91203006051933,249.9105587477137,249.90906304231274,249.90754254652785,249.90599685628573,
	249.9044255611354,249.90282824415388,249.90120448185047,249.89955384407023,249.89787589389607,
	249.89617018754953,249.89443627429037,249.89267369631514,249.89088198865394,249.88906067906663,
	249.88720928793728,249.88532732816745,249.88341430506824,249.8814697162511,249.87949305151724,
	249.87748379274583,249.87544141378064,249.8733653803157,249.8712551497796,249.8691101712182,
	249.8669298851761,249.86471372357704,249.86246110960255,249.8601714575697,249.85784417280695,
	249.85547865152918,249.85307428071104,249.85063043795904,249.84814649138235,249.8456217994619,
	249.8430557109188,249.8404475645806,249.8377966892467,249.83510240355224,249.83236401583073,
	249.82958082397496,249.82675211529718,249.82387716638723,249.82095524296986,249.81798559976042,
	249.81496748031932,249.81190011690495,249.80878273032567,249.80561452979,249.80239471275596,
	249.79912246477863,249.79579695935675,249.7924173577782,249.78898280896334,249.78549244930826,
	249.78194540252588,249.77834077948634,249.77467767805572,249.77095518293402,249.76717236549172,
	249.7633282836049,249.75942198148994,249.75545248953634,249.75141882413868,249.74731998752793,
	249.74315496760073,249.73892273774896,249.73462225668675,249.73025246827802,249.72581230136197,
	249.72130066957814,249.71671647119058,249.712058588911,249.707325889721,249.70251722469416,
	249.69763142881632,249.69266732080624,249.68762370293464,249.68249936084345,249.67729306336412,
	249.67200356233482,249.66662959241845,249.66116987091888,249.6556230975977,249.64998795449023,
	249.64426310572148,249.63844719732137,249.63253885704066,249.626536694166,249.62043929933523,
	249.61424524435267,249.6079530820048,249.60156134587527,249.59506855016113,249.58847318948878,
	249.5817737387303,249.57496865282042,249.5680563665739,249.56103529450357,249.5539038306389,
	249.54666034834557,249.5393032001458,249.5318307175396,249.5242412108269,249.5165329689312,
	249.50870425922412,249.50075332735125,249.49267839705982,249.48447767002722,249.47614932569186,
	249.46769152108524,249.45910239066612,249.45038004615648,249.44152257637978,249.43252804710093,
	249.42339450086928,249.41411995686326,249.4047024107381,249.3951398344758,249.3854301762382,
	249.37557136022278,249.3655612865215,249.3553978309832,249.34507884507818,249.33460215576778,
	249.3239655653763,249.31316685146706,249.30220376672233,249.29107403882753,249.27977537035852,
	249.26830543867473,249.2566618958153,249.2448423684005,249.23284445753788,249.22066573873292,
	249.20830376180504,249.19575605080865,249.18302010395954,249.17009339356653,249.15697336596946,
	249.14365744148182,249.13014301434058,249.116427452661,249.10250809839866,249.08838226731712,
	249.0740472489627,249.05950030664576,249.04473867742874,249.02975957212158,249.014560175284,
	248.99913764523552,248.98348911407248,248.9676116876932,248.9515024458306,248.93515844209315,
	248.9185767040137,248.9017542331064,248.88468800493257,248.8673749691746,248.8498120497188,
	248.8319961447473,248.8139241268383,248.79559284307615,248.77699911517027,248.75813973958353,
	248.7390114876702,248.71961110582347,248.69993531563276,248.67998081405085,248.65974427357105,
	248.63922234241443,248.6184116447272,248.59730878078844,248.57591032722823,248.5542128372561,
	248.5322128409002,248.5099068452571,248.48729133475211,248.4643627714106,248.44111759514004,
	248.41755222402287,248.39366305462042,248.3694464622878,248.3448988014996,248.32001640618694,
	248.29479559008544,248.26923264709404,248.24332385164521,248.21706545908617,248.19045370607117,
	248.16348481096446,248.13615497425496,248.10846037898136,248.08039719116834,248.05196156027372,
	248.02314961964655,247.99395748699553,247.9643812648686,247.93441704114304,247.9040608895257,
	247.87330887006425,247.84215702966804,247.81060140263978,247.77863801121669,247.7462628661219,
	247.7134719671254,247.68026130361488,247.64662685517555,247.61256459217944,247.57807047638377,
	247.54314046153817,247.50777049400037,247.4719565133606,247.435694453074,247.39898024110096,
	247.36180980055562,247.3241790503613,247.28608390591333,247.24752027974935,247.20848408222548,
	247.16897122219947,247.12897760771983,247.08849914672075,247.04753174772267,247.00607132053756,
	246.9641137769801,246.92165503158225,246.87869100231296,246.83521761130112,246.7912307855628,
	246.74672645773083,246.701700566788,246.6561490588021,246.61006788766377,246.5634530158254,
	246.51630041504214,246.4686060671131,246.4203659646239,246.37157611168948,246.32223252469595,
	246.27233123304282,246.221868279884,246.1708397228675,246.1192416348733,246.06707010474958,
	246.014321238046,245.96099115774447,245.90707600498672,245.85257193979768,245.79747514180576,
	245.741781810958,245.68548816823068,245.62859045633488,245.57108494041637,245.51296790874986,
	245.4542356734263,245.39488457103454,245.3349109633353,245.27431123792763,245.21308180890864,
	245.1512191175241,245.08871963281132,245.02557985223288,244.96179630230208,244.89736553919795,
	244.83228414937165,244.7665487501422,244.70015599028247,244.633102550594,244.56538514447172,
	244.49700051845716,244.4279454527804,244.3582167618903,244.28781129497355,244.2167259364605,
	244.14495760651982,244.0725032615401,243.99935989459894,243.92552453591912,243.85099425331148,
	243.77576615260514,243.69983737806382,243.6232051127889,243.54586657910863,243.4678190389537,
	243.38905979421884,243.30958618711054,243.22939560048033,243.1484854581444,243.0668532251884,
	242.9844964082585,242.90141255583765,242.81759925850753,242.7330541491964,242.64777490341197,
	242.56175923946049,242.47500491865063,242.3875097454838,242.29927156782935,242.21028827708554,
	242.12055780832685,242.0300781404362,241.93884729622314,241.84686334252865,241.75412439031476,
	241.6606285947412,241.56637415522775,241.47135931550272,241.37558236363836,241.27904163207234,
	241.18173549761582,241.08366238144876,240.98482074910183,240.8852091104252,240.78482601954536,
	240.68367007480842,240.58173991871183,240.47903423782319,240.37555176268765,240.2712912677229,
	240.16625157110315,240.06043153463105,239.95383006359876,239.84644610663798,239.73827865555901,
	239.62932674517927,239.51958945314175,239.40906589972303,239.29775524763113,239.18565670179458,
	239.07276950914112,238.95909295836776,238.84462637970165,238.72936914465228,238.61332066575537,
	238.4964803963081,238.37884783009696,238.2604225011172,238.1412039832854,238.02119189014428,
	237.9003858745608,237.7787856284174,237.65639088229688,237.53320140516055,237.40921700402092,
	237.28443752360818,237.15886284603164,237.03249289043498,236.90532761264754,236.7773670048297,
	236.64861109511463,236.51905994724507,236.38871366020584,236.25757236785336,236.12563623854027,
	235.9929054747376,235.85938031265314,235.725061021847,235.5899479048444,235.45404129674554,
	235.3173415648338,235.17984910818103,235.04156435725105,234.90248777350195,234.76261984898582,
	234.621961105948,234.48051209642455,234.33827340183913,234.19524563259858,234.05142942768842,
	233.90682545426733,233.76143440726156,233.61525700895942,233.46829400860528,233.32054618199427,
	233.17201433106686,233.0226992835044,232.87260189232484,232.72172303547944,232.57006361545047,
	232.41762455884975,232.26440681601866,232.11041136062912,231.95563918928607,231.800091321132,
	231.64376879745228,231.48667268128304,231.3288040570205,231.1701640300326,231.01075372627218,
	230.85057429189325,230.68962689286843,230.52791271460995,230.3654329615921,230.20218885697685,
	230.03818164224174,229.87341257681086,229.70788293768814,229.54159401909396,229.37454713210417,
	229.2067436042925,229.038184779376,228.868872016863,228.6988066917053,228.5279901939523,
	228.35642392840933,228.18410931429878,228.01104778492493,227.8372407873417,227.66268978202427,
	227.4873962425438,227.31136165524592,227.1345875189323,226.95707534454667,226.77882665486288,
	226.59984298417834,226.4201258780095,226.23967689279218,226.05849759558447,225.8765895637744,
	225.69395438478998,225.51059365581432,225.3265089835034,225.1417019837079,224.95617428119866,
	224.76992750939618,224.5829633101033,224.39528333324168,224.20688923659253,224.01778268554028,
	223.82796535282054,223.6374389182713,223.4462050685881,223.25426549708297,223.0616219034464,
	222.86827599351392,222.67422947903546,222.47948407744886,222.28404151165677,222.08790350980715,
	221.89107180507753,221.69354813546246,221.49533424356517,221.2964318763918,221.0968427851501,
	220.89656872505108,220.69561145511418,220.49397273797587,220.29165433970206,220.08865802960335,
	219.8849855800539,219.68063876631388,219.47561936635492,219.26992916068897,219.06356993220064,
	218.8565434659823,218.64885154917314,218.4404959708007,218.2314785216263,218.02180099399288,
	217.81146518167654,217.60047287974103,217.38882588439523,217.17652599285367,216.9635750032003,
	216.74997471425496,216.5357269254431,216.32083343666835,216.1052960481877,215.88911656049035,
	215.6722967741785,215.45483848985174,215.2367435079939,215.01801362886263,214.79865065238207,
	214.57865637803786,214.35803260477553,214.13678113090066,213.91490375398243,213.69240227075974,
	213.46927847704973,213.24553416765897,213.0211711362974,212.79619117549473,212.57059607651922,
	212.3443876292994,212.1175676223479,211.890137842688,211.6621000757827,211.4334561054658,
	211.204207713876,210.97435668139326,210.74390478657736,210.51285380610892,210.28120551473287,
	210.04896168520455,209.81612408823756,209.58269449245446,209.3486746643397,209.1140663681947,
	208.87887136609547,208.64309141785242,208.4067282809725,208.1697837106237,207.93225945960174,
	207.6941572782993,207.45547891467714,207.21622611423786,206.97640062000195,206.73600417248608,
	206.49503850968333,206.25350536704656,206.01140647747332,205.76874357129367,205.52551837625964,
	205.2817326175379,205.03738801770427,204.79248629674072,204.54702917203468,204.30101835838119,
	204.05445556798688,203.80734251047699,203.55968089290442,203.31147241976197,203.062718792996,
	202.8134217120242,202.56358287375457,202.31320397260794,202.06228670054293,201.81083274708362,
	201.5588437993502,201.30632154209206,201.05326765772446,200.79968382636727,200.54557172588787,
	200.29093303194574,200.03576941804144,199.78008255556816,199.52387411386667,199.26714576028365,
	199.00989916023335,198.75213597726326,198.49385787312266,198.2350665078354,197.97576353977652,
	197.71595062575227,197.45562942108484,197.1948015797009,196.93346875422395,196.67163259607224,
	196.4092947555597,196.1464568820028,195.8831206238315,195.6192876287054,195.35495954363464,
	195.09013801510696,194.8248246892187,194.55902121181308,194.2927292286229,194.0259503854202,
	193.75868632817122,193.49093870319882,193.22270915735027,192.95399933817322,192.68481089409752,
	192.41514547462506,192.1450047305274,191.87439031405034,191.6033038791277,191.33174708160269,
	191.05972157945837,190.78722903305749,190.5142711053908,190.24084946233603,189.96696577292627,
	189.69262170962926,189.41781894863735,189.14255917016771,188.86684405877662,188.59067530368313,
	188.31405459910698,188.03698364461857,187.75946414550307,187.48149781313805,187.20308636538584,
	186.92423152700073,186.64493503005198,186.36519861436287,186.08502402796677,185.80441302758032,
	185.52336737909476,185.24188885808633,184.9599792503459,184.6776403524285,184.39487397222447,
	184.1116819295517,183.82806605677106,183.54402819942445,183.2595702168978,182.97469398310895,
	182.6894013872217,182.4036943343868,182.11757474651145,181.83104456305725,181.5441057418691,
	181.25676026003492,180.96901011477811,180.6808573243835,180.39230392915834,180.10335199242945,
	179.81400360157784,179.52426086911208,179.23412593378222,178.9436009617352,178.65268814771343,
	178.36138971629816,178.06970792319936,177.7776450565934,177.48520343851024,177.19238542627247,
	176.8991934139871,176.60562983409247,176.31169715896235,176.0173979025685,175.72273462220426,
	175.42770992027118,175.13232644613024,174.83658689802076,174.54049402504808,174.24405062924305,
	173.9472595676957,173.65012375476493,173.3526461643663,173.05482983234182,172.75667785891287,
	172.45819341121904,172.15937972594594,171.86024011204395,171.5607779535415,171.26099671245382,
	170.96089993179226,170.6604912386745,170.35977434754014,170.05875306347312,169.7574312856351,
	169.4558130108107,169.15390233706938,168.8517034675447,168.54922071433523,168.2464585025285,
	167.94342137435112,167.6401139934479,167.33654114929138,167.03270776172494,166.72861888564117,
	166.42427971579818,166.1196955917745,165.81487200306591,165.50981459432427,165.2045291707407,
	164.89902170357334,164.59329833582117,164.28736538804392,163.98122936432816,163.6748969583997,
	163.36837505988143,163.06167076069542,162.75479136160797,162.44774437891516,162.14053755126952,
	161.83317884662836,161.52567646935762,161.21803886743845,160.910274739806,160.60239304380065,
	160.29440300272648,159.9863141135099,159.67813615444828,159.36987919303925,159.0615535938795,
	158.7531700266202,158.44473947396642,158.13627323970482,157.82778295674362,157.5192805951481,
	157.21077847015073,156.90228925011735,156.59382596444573,156.2854020113734,155.97703116566873,
	155.66872758617873,155.3605058232037,155.05238082566842,154.74436794805754,154.4364829570803,
	154.12874203802832,153.82116180078918,153.5137592854751,153.2065519676259,152.89955776294286,
	152.5927950315086,152.286282581447,151.98003967197556,151.67408601580115,151.36844178080906,
	151.0631275909955,150.75816452659063,150.4535741233216,150.1493783707623,149.8455997097184,
	149.54226102859656,149.23938565870543,148.9369973684407,148.63512035630458,148.33377924271372,
	148.03299906055256,147.73280524442953,147.43322361860024,147.1342803835219,146.83600210101073,
	146.53841567797673,146.24154834871624,145.9454276557492,145.650081429193,145.35553776467157,
	145.0618249997678,144.76897168903147,144.47700657756607,144.1859585732231,143.89585671744462,
	143.60673015479955,143.31860810127176,143.03151981136438,142.745494544095,142.46056152796515,
	142.17674992499593,141.89408879393025,141.6126070527101,141.33233344034522,141.05329647829612,
	140.77552443150128,140.499045269184,140.223886625579,139.95007576072354,139.67763952146004,
	139.40660430280008,139.13699600980027,138.86884002010086,138.6021611472754,138.33698360514012,
	138.07333097316504,137.8112261631272,137.5506913871387,137.2917481271768,137.03441710623517,
	136.77871826120733,136.52467071760276,136.2722927661884,136.02160184163466,135.77261450323644,
	135.5253464177656,135.27981234450223,135.03602612247616,134.79400065994196,134.55374792609555,
	134.3152789450296,134.07860379191362,133.84373159137232,133.61067051802635,133.3794277991468,
	133.15000971936877,132.9224216273963,132.69666794462617,132.47275217560892,132.2506769202582,
	132.03044388771673,131.81205391177863,131.59550696776688,131.3808021907601,131.16793789506042,
	130.95691159479398,130.74772002553414,130.54035916683634,130.33482426557833,130.13110985999518,
	129.92920980430603,129.72911729382835,129.53082489048066,129.33432454857677,129.13960764082012,
	128.94666498440895,128.75548686716917,128.56606307363603,128.37838291100954,128.19243523491548,
	128.00820847490638,127.8256906596438,127.64486944170783,127.46573212198342,127.28826567357983,
	127.11245676524271,126.93829178422384,126.7657568585775,126.59483787885712,126.42552051918913,
	126.25779025770585,126.09163239632241,125.92703207984555,125.76397431440672,125.6024439852137,
	125.44242587361815,125.28390467349963,125.1268650069679,124.97129143938857,124.81716849373807,
	124.66448066429724,124.5132124296921,124.36334826529422,124.21487265499263,124.06777010235108,
	123.922025141165,123.77762234543373,123.63454633876388,123.49278180322023,123.35231348764094,
	123.21312621543508,123.0752048918787,122.93853451092816,122.80310016156763,122.66888703370867,
	122.5358804236593,122.40406573918007,122.27342850414384,122.14395436281704,122.01562908377814,
	121.8884385634902,121.76236882954346,121.63740604358333,121.51353650393891,121.39074664796753,
	121.26902305412865,121.14835244380193,121.0287216828623,120.9101177830258,120.79252790297782,
	120.67593934929685,120.56033957715844,120.44571619099199,120.33205694468948,120.21934974193793,
	120.10758263625456,119.99674383091038,119.88682167872183,119.77780468171846,119.66968149069541,
	119.5624409046583,119.45607187016833,119.35056348059452,119.24590497528003,119.1420857386293,
	119.03909529912156,118.9369233282572,118.83555963944218,118.73499418681585,118.63521706402713,
	118.53621850296378,118.43798887243913,118.34051867684066,118.24379855474405,118.14781927749699,
	118.05257174777556,117.95804699811704,117.86423618943216,117.77113060949964,117.67872167144543,
	117.5870009122102,117.49595999100633,117.4055906877674,117.3158849015922,117.22683464918501,
	117.13843206329403,117.05066939115005,116.96353899290628,116.87703334008165,116.79114501400808,
	116.70586670428372,116.62119120723312,116.53711142437507,116.4536203608996,116.37071112415497,
	116.28837692214512,116.20661106203893,116.1254069486915,116.04475808317838,115.96465806134339,
	115.88510057236017,115.80607939730847,115.72758840776507,115.64962156441038,115.57217291565004,
	115.4952365962532,115.41880682600626,115.34287790838337,115.26744422923358,115.19250025548436,
	115.11804053386247,115.04405968963127,114.97055242534545,114.89751351962269,114.82493782593248,
	114.75282027140183,114.68115585563855,114.6099396495711,114.53916679430579,114.46883250000074,
	114.39893204475703,114.32946077352618,114.26041409703474,114.19178749072533,114.12357649371403,
	114.05577670776431,113.98838379627698,113.92139348329619,113.8548015525316,113.78860384639583,
	113.72279626505788,113.65737476551175,113.59233536066029,113.5276741184142,113.4633871608058,
	113.39947066311758,113.33592085302507,113.27273400975429,113.20990646325295,113.14743459337598,
	113.08531482908457,113.02354364765864,112.96211757392295,112.90103317948608,112.84028708199257,
	112.77987594438775,112.71979647419501,112.66004542280577,112.60061958478117,112.5415157971662,
	112.48273093881537,112.42426192973014,112.36610573040751,112.30825934120031,112.25071980168805,
	112.19348419005892,112.13654962250259,112.07991325261304,112.02357227080246,111.9675239037245,
	111.91176541368007,111.85629409817562,111.80110728919973,111.74620235280635,111.69157668855556,
	111.63722772899497,111.5831529391494,111.5293498160199,111.47581588809135,111.42254871484838,
	111.36954588629992,111.31680502251177,111.26432377314751,111.21209981701696,111.16013086163285,
	111.10841464277472,111.05694892406073,111.00573149652656,110.95476017821163,110.90403281375252,
	110.85354727398338,110.80330145554287,110.75329328048832,110.70352069591617,110.65398167358896,
	110.60467420956887,110.55559632385713,110.50674606004003,110.45812148494049,110.40972068827604,
	110.36154178232216,110.31358290158165,110.26584220245932,110.2183178629425,110.17100808228655,
	110.12391108070607,110.077025099071,110.03034839860794,109.98387926060663,109.93761598613096,
	109.89155689573523,109.8457003291849,109.80004464518198,109.75458822109529,109.70932945269475,
	109.6642667538903,109.6193985564754,109.57472330987422,109.53023948089341,109.48594555347796,
	109.44184002847072,109.39792142337627,109.35418827212845,109.31063912486168,109.26727254768609,
	109.22408712246627,109.18108144660371,109.1382541328226,109.09560380895913,109.05312911775441,
	109.01082871665044,108.96870127758962,108.9267454868173,108.88496004468746,108.84334366547176,
	108.80189507717144,108.76061302133222,108.71949625286219,108.67854353985258,108.63775366340154,
	108.59712541744021,108.55665760856213,108.51634905585516,108.47619859073563,108.43620505678577,
	108.39636730959306,108.35668421659253,108.31715465691138,108.2777775212159,108.23855171156092,
	108.19947614124146,108.16054973464692,108.12177142711711,108.08314016480092,108.044654904517,
	108.00631461361645,107.96811826984761,107.93006486122337,107.89215338588977,107.85438285199731,
	107.81675227757356,107.77926069039829,107.7419071278801,107.70469063693503,107.66761027386697,
	107.63066510424999,107.59385420281227,107.55717665332169,107.52063154847356,107.48421798977945,
	107.44793508745806,107.41178196032763,107.37575773569979,107.33986154927516,107.30409254504045,
	107.2684498751669,107.23293269991046,107.1975401875133,107.16227151410678,107.12712586361569,
	107.09210242766424,107.05720040548306,107.02241900381755,106.98775743683795,106.95321492605024,
	106.91879070020856,106.88448399522886,106.85029405410374,106.81622012681854,106.7822614702686,
	106.74841734817767,106.71468703101768,106.68106979592932,106.64756492664392,106.61417171340662,
	106.58088945290001,106.54771744816969,106.51465500855019,106.48170144959212,106.44885609299065,
	106.41611826651439,106.38348730393578,106.35096254496224,106.31854333516817,106.28622902592814,
	106.2540189743507,106.2219125432134,106.18990910089848,106.15800802132948,106.12620868390881,
	106.09451047345618,106.0629127801475,106.0314149994553,106.00001653208923,105.96871678393792,
	105.93751516601121,105.90641109438343,105.8754039901374,105.844493279309,105.81367839283268,
	105.78295876648771,105.7523338408448,105.72180306121396,105.69136587759266,105.6610217446148,
	105.63077012150026,105.60061047200537,105.57054226437369,105.5405649712877,105.51067806982095,
	105.48088104139099,105.45117337171273,105.42155455075253,105.39202407268299,105.36258143583792,
	105.33322614266837,105.30395769969903,105.27477561748499,105.24567941053682,105.21666859741092,
	105.18774270046649,105.15890124596109,105.1301437639757,105.10146978837481,105.072878856767,
	105.04437051046621,105.01594429445319,104.98759975733776,104.95933645132136,104.93115393216004,
	104.90305175912805,104.87502949498175,104.84708670592406,104.8192229615694,104.79143783490875,
	104.76373090227564,104.73610174331216,104.70854994093548,104.681075081305,104.65367675378951,
	104.62635455093513,104.59910806843345,104.57193690508998,104.54484066279328,104.51781894648413,
	104.49087136412524,104.46399752667132,104.4371970480396,104.41046954508037,104.38381463754845,
	104.35723194807419,104.33072110213581,104.3042817280311,104.2779134568501,104.251615922448,
	104.22538876141803,104.19923161306511,104.1731441193795,104.14712592501093,104.12117667724293,
	104.09529602596754,104.06948362366025,104.04373912535526,104.01806218862112,103.99245247353643,
	103.9669096426661,103.94143336103767,103.91602329611791,103.89067911779,103.86540049833037,
	103.84018711238654,103.8150386369546,103.78995475135727,103.76493513722217,103.73997947846021,
	103.7150874612444,103.6902587739888,103.66549310732772,103.64079015409509,103.61614960930432,
	103.59157117012796,103.56705453587807,103.54259940798636,103.51820548998498,103.49387248748715,
	103.46960010816817,103.44538806174673,103.42123605996629,103.39714381657672,103.37311104731604,
	103.34913746989272,103.32522280396755,103.30136677113643,103.2775690949127,103.25382950071021,
	103.23014771582605,103.20652346942403,103.18295649251779,103.1594465179546,103.13599328039888,
	103.11259651631619,103.08925596395737,103.06597136334271,103.04274245624646,103.01956898618131,
	102.99645069838323,102.97338733979643,102.95037865905832,102.92742440648485,102.90452433405588,
	102.88167819540075,102.85888574578397,102.83614674209106,102.81346094281466,102.79082810804047,
	102.76824799943385,102.74572038022606,102.72324501520092,102.70082167068149,102.67845011451702,
	102.65613011606989,102.63386144620277,102.61164387726596,102.58947718308471,102.56736113894677,
	102.54529552159009,102.52328010919065,102.50131468135027,102.47939901908475,102.45753290481206,
	102.43571612234048,102.41394845685723,102.39222969491674,102.37055962442953,102.3489380346509,
	102.32736471616967,102.30583946089735,102.28436206205713,102.26293231417317,102.2415500130598,
	102.22021495581107,102.19892694079023,102.17768576761935,102.15649123716906,102.13534315154843,
	102.11424131409488,102.0931855293643,102.07217560312098,102.05121134232817,102.03029255513816,
	102.00941905088281,101.98859064006409,101.96780713434471,101.94706834653871,101.92637409060251,
	101.90572418162549,101.8851184358213,101.86455667051867,101.84403870415261,101.82356435625593,
	101.80313344745015,101.78274579943721,101.76240123499086,101.74209957794831,101.72184065320171,
	101.70162428669015,101.68145030539125,101.66131853731324,101.6412288114868,101.62118095795718,
	101.60117480777629,101.58121019299502,101.56128694665529,101.54140490278262,101.52156389637848,
	101.50176376341277,101.48200434081633,101.46228546647377,101.4426069792159,101.42296871881275,
	101.4033705259663,101.38381224230338,101.36429371036863,101.34481477361767,101.32537527641009,
	101.30597506400252,101.28661398254222,101.26729187905991,101.24800860146357,101.22876399853146,
	101.20955791990593,101.19039021608677,101.17126073842486,101.15216933911583,101.13311587119385,
	101.11410018852523,101.09512214580236,101.07618159853766,101.05727840305741,101.0384124164958,
	101.01958349678894,101.00079150266906,100.98203629365855,100.96331773006425,100.94463567297169,
	100.92598998423942,100.90738052649336,100.88880716312123,100.87026975826699,100.8517681768254,
	100.83330228443654,100.81487194748051,100.79647703307185,100.77811740905472,100.75979294399706,
	100.74150350718591,100.72324896862196,100.70502919901453,100.68684406977653,100.66869345301937,
	100.65057722154813,100.63249524885643,100.61444740912172,100.5964335772004,100.5784536286229,
	100.56050743958907,100.54259488696341,100.5247158482703,100.5068702016896,100.48905782605172,
	100.4712786008334,100.45353240615295,100.43581912276586,100.41813863206043,100.40049081605328,
	100.38287555738485,100.36529273931545,100.34774224572064,100.33022396108704,100.31273777050826,
	100.29528355968053,100.27786121489869,100.26047062305199,100.24311167162007,100.22578424866893,
	100.20848824284684,100.19122354338045,100.17399004007082,100.15678762328949,100.13961618397471,
	100.12247561362736,100.10536580430744,100.08828664863012,100.07123803976194,100.05421987141727,
	100.03723203785452,100.02027443387242,100.00334695480657,99.98644949652568,99.96958195542814,
	99.95274422843835,99.93593621300333,99.91915780708915,99.90240890917765,99.88568941826277,
	99.8689992338473,99.85233825593959,99.83570638505003,99.8191035221879,99.80252956885793,
	99.7859844270573,99.7694679992721,99.75298018847433,99.73652089811864,99.72009003213918,
	99.7036874949466,99.68731319142475,99.67096702692767,99.65464890727665,99.63835873875705,
	99.62209642811543,99.60586188255638,99.58965500973987,99.5734757177779,99.55732391523203,
	99.54119951111022,99.52510241483213,99.50903253635501,99.49298978597605,99.47697407446059,
	99.46098531300646,99.4450234132411,99.42908828721875,99.41317984741795,99.39729800673872,
	99.38144267849982,99.36561377643635,99.34981121469681,99.3340349078407,99.31828477083597,
	99.30256071905627,99.28686266827863,99.27119053468066,99.25554423483831,99.23992368572324,
	99.22432880470042,99.20875950952559,99.19321571834296,99.17769734968263,99.16220432245836,
	99.14673655596519,99.1312939698769,99.1158764842439,99.10048401949074,99.08511649641393,
	99.0697738361796,99.05445596032118,99.03916279073724,99.02389424968923,99.00865025979925,
	98.99343074404788,98.97823562577186,98.96306482866217,98.9479182767617,98.93279589446314,
	98.91769760650688,98.90262333797888,98.88757301430876,98.8725465612674,98.85754390496518,
	98.84256497184974,98.82760968870411,98.8126779826446,98.79776978111887,98.7828850119038,
	98.76802360310381,98.75318548314858,98.73837058079135,98.72357882510691,98.70881014548964,
	98.69406447165173,98.67934173362124,98.66464186174018,98.64996478666278,98.63531043935352,
	98.6206787510854,98.60606965343807,98.59148307829604,98.57691895784689,98.5623772245796,
	98.54785781128254,98.5333606510421,98.51888567724043,98.50443282355431,98.49000202395294,
	98.4755932126966,98.46120632433467,98.44684129370417,98.43249805592804,98.41817654641346,
	98.4038767008502,98.38959845520904,98.3753417457401,98.36110650897128,98.3468926817067,
	98.33270020102502,98.31852900427792,98.3043790290886,98.29025021335002,98.27614249522377,
	98.26205581313806,98.24799010578657,98.23394531212672,98.21992137137833,98.20591822302208,
	98.19193580679793,98.17797406270387,98.16403293099427,98.15011235217855,98.13621226701979,
	98.12233261653301,98.10847334198421,98.09463438488862,98.08081568700945,98.06701719035651,
	98.0532388371847,98.03948056999279,98.02574233152211,98.01202406475501,97.99832571291365,
	97.98464721945868,97.97098852808789,97.95734958273482,97.94373032756769,97.93013070698778,
	97.91655066562848,97.90299014835378,97.88944910025705,97.87592746665992,97.86242519311087,
	97.84894222538405,97.83547850947802,97.82203399161465,97.80860861823766,97.79520233601166,
	97.78181509182085,97.76844683276781,97.7550975061723,97.74176705957024,97.72845544071224,
	97.71516259756278,97.70188847829888,97.68863303130895,97.67539620519162,97.6621779487548,
	97.64897821101435,97.6357969411931,97.62263408871969,97.6094896032274,97.59636343455321,
	97.58325553273657,97.57016584801852,97.5570943308403,97.54404093184263,97.53100560186446,
	97.51798829194195,97.50498895330739,97.49200753738829,97.47904399580622,97.46609828037587,
	97.45317034310398,97.44026013618836,97.42736761201691,97.41449272316659,97.40163542240239,
	97.38879566267646,97.37597339712703,97.36316857907745,97.35038116203536,97.33761109969149,
	97.32485834591891,97.31212285477204,97.29940458048564,97.28670347747398,97.27401950032976,
	97.26135260382338,97.2487027429019,97.23606987268813,97.2234539484798,97.2108549257486,
	97.1982727601393,97.18570740746885,97.17315882372557,97.16062696506813,97.14811178782486,
	97.13561324849273,97.12313130373657,97.11066591038826,97.09821702544578,97.08578460607235,
	97.07336860959576,97.06096899350736,97.0485857154613,97.0362187332738,97.02386800492208,
	97.01153348854388,96.99921514243636,96.98691292505549,96.97462679501517,96.96235671108646,
	96.95010263219675,96.93786451742903,96.92564232602118,96.91343601736494,96.9012455510055,
	96.88907088664043,96.87691198411912,96.86476880344182,96.85264130475926,96.84052944837148,
	96.82843319472731,96.81635250442362,96.80428733820457,96.79223765696096,96.78020342172931,
	96.76818459369133,96.75618113417312,96.74419300464456,96.73222016671843,96.72026258214987,
	96.70832021283562,96.69639302081329,96.6844809682608,96.67258401749554,96.66070213097377,
	96.64883527128997,96.63698340117612,96.62514648350101,96.61332448126974,96.60151735762277,
	96.58972507583559,96.57794759931778,96.56618489161261,96.55443691639616,96.54270363747689,
	96.53098501879491,96.51928102442132,96.50759161855761,96.49591676553511,96.48425642981421,
	96.47261057598391,96.46097916876101,96.4493621729898,96.43775955364114,96.42617127581201,
	96.41459730472494,96.40303760572729,96.39149214429082,96.37996088601095,96.36844379660627,
	96.35694084191798,96.3454519879091,96.33397720066422,96.32251644638868,96.31106969140812,
	96.29963690216792,96.28821804523245,96.27681308728484,96.26542199512613,96.25404473567482,
	96.2426812759665,96.23133158315291,96.21999562450185,96.2086733673962,96.19736477933378,
	96.18606982792652,96.17478848090013,96.16352070609348,96.15226647145803,96.14102574505739,
	96.12979849506686,96.11858468977269,96.10738429757184,96.09619728697125,96.08502362658751,
	96.07386328514623,96.06271623148157,96.05158243453577,96.04046186335867,96.02935448710713,
	96.01826027504465,96.00717919654082,95.9961112210708,95.98505631821503,95.97401445765843,
	95.96298560919021,95.9519697427033,95.94096682819381,95.92997683576068,95.91899973560513,
	95.90803549803023,95.8970840934405,95.88614549234126,95.87521966533843,95.8643065831379,
	95.85340621654511,95.84251853646474,95.83164351389998,95.82078111995241,95.80993132582131,
	95.79909410280342,95.78826942229236,95.77745725577822,95.76665757484719,95.75587035118106,
	95.74509555655695,95.73433316284664,95.72358314201634,95.71284546612621,95.70212010732996,
	95.69140703787434,95.68070623009896,95.67001765643566,95.6593412894081,95.64867710163156,
	95.6380250658123,95.62738515474737,95.61675734132402,95.60614159851944,95.59553789940037,
	95.58494621712254,95.57436652493051,95.56379879615712,95.55324300422312,95.54269912263698,
	95.53216712499412,95.521646984977,95.51113867635434,95.50064217298097,95.49015744879743,
	95.4796844778295,95.46922323418798,95.45877369206816,95.44833582574958,95.43790960959566,
	95.42749501805322,95.41709202565228,95.40670060700559,95.39632073680829,95.38595238983767,
	95.37559554095259,95.36525016509339,95.35491623728132,95.34459373261836,95.33428262628682,
	95.32398289354892,95.31369450974651,95.3034174503009,95.29315169071214,95.282897206559,
	95.27265397349858,95.26242196726588,95.25220116367356,95.24199153861157,95.23179306804681,
	95.22160572802292,95.21142949465978,95.20126434415326,95.19111025277502,95.18096719687196,
	95.17083515286618,95.16071409725436,95.15060400660765,95.14050485757143,95.13041662686473,
	95.12033929128015,95.11027282768346,95.10021721301331,95.09017242428096,95.08013843856989,
	95.07011523303561,95.06010278490525,95.0501010714774,95.04011007012166,95.03012975827848,
	95.02016011345873,95.01020111324357,95.00025273528405,94.99031495730081,94.98038775708388,
	94.97047111249236,94.96056500145403,94.9506694019653,94.94078429209061,94.93090964996254,
	94.92104545378116,94.91119168181396,94.90134831239558,94.8915153238924,94.88169269484355,
	94.8718804037471,94.86207842920335,94.85228674987833,94.84250534450355,94.83273419187569,
	94.82297327085642,94.81322256037208,94.80348203941341,94.79375168703542,94.7840314823568,
	94.77432140456011,94.76462143289122,94.75493154665908,94.7452517252356,94.73558194805526,
	94.72592219461495,94.71627244447367,94.7066326772523,94.69700287263333,94.6873830103607,
	94.67777307023938,94.66817303213533,94.65858287597511,94.64900258174566,94.6394321294942,
	94.62987149932779,94.62032067141315,94.61077962597653,94.60124834330338,94.59172680373815,
	94.58221498768398,94.57271287560258,94.56322044801395,94.55373768549606,94.54426456868485,
	94.53480107827377,94.52534719501372,94.51590289971256,94.50646817323532,94.49704299650357,
	94.48762735049544,94.47822121624525,94.46882457484345,94.4594374074362,94.45005969522529,
	94.44069141946798,94.43133256147662,94.42198310261853,94.41264302431573,94.40331230804485,
	94.39399093533676,94.38467888777649,94.37537614700295,94.36608269470868,94.3567985126398,
	94.34752358259561,94.33825788642854,94.3290014060438,94.31975412339939,94.31051602050567,
	94.30128707942525,94.29206728227282,94.28285661121494,94.27365504846979,94.264462576307,
	94.25527917704751,94.24610483306331,94.23693952677719,94.22778324066269,94.2186359572438,
	94.20949765909485,94.20036832884016,94.19124794915405,94.1821365027605,94.17303397243306,
	94.16394034099459,94.15485559131714,94.14577970632169,94.13671266897802,94.1276544623045,
	94.11860506936792,94.1095644732833,94.1005326572137,94.09150960437006,94.08249529801103,
	94.07348972144271,94.06449285801861,94.05550469113932,94.04652520425245,94.03755438085237,
	94.02859220448015,94.01963865872322,94.01069372721543,94.00175739363652,93.99282964171236,
	93.9839104552145,93.97499981796008,93.96609771381165,93.95720412667711,93.94831904050926,
	93.93944243930602,93.93057430710996,93.92171462800826,93.91286338613249,93.90402056565848,
	93.89518615080625,93.88636012583964,93.87754247506629,93.86873318283752,93.85993223354794,
	93.85113961163562,93.84235530158166,93.83357928791018,93.8248115551881,93.81605208802496,
	93.8073008710729,93.79855788902627,93.78982312662173,93.78109656863789,93.77237819989534,
	93.76366800525633
	}}
};
table1d_imp<2001> tubetable2_12AX7[2] __rt_data = {
	{ // Ri = 68k
	-5,5,200,2001, {
	107069048.23743129,105392174.78838265,103741722.07577392,102117272.43912883,100518414.82119504,
	98944744.71680723,97395863.91792704,95871380.6772921,94370909.36532225,92894070.48447181,
	91440490.52891436,90009801.9741921,88601643.05107075,87215657.76537625,85851495.7408349,
	84508812.15729606,83187267.68499689,81886528.3326566,80606265.40051086,79346155.44117261,
	78105880.07200333,76885126.01281577,75683584.88938914,74500953.25309323,73336932.44764875,
	72191228.5318826,71063552.23644808,69953618.89884748,68861148.30066755,67785864.71445023,
	66727496.772842236,65685777.36613838,64660443.65864953,63651236.96481916,62657902.69393595,
	61680190.2503012,60717853.07730931,59770648.4537256,58838337.534924276,57920685.25355528,
	57017460.26273295,56128434.866906695,55253384.993136734,54392090.10142144,53544333.128903866,
	52709900.48211592,51888581.9183997,51080170.5414609,50284462.71830191,49501258.0354619,
	48730359.25620786,47971572.27216647,47224706.0226486,46489572.49728668,45765986.64069795,
	45053766.33318738,44352732.3313391,43662708.23125047,42983520.42143579,42314998.02716874,
	41656972.88634323,41009279.487877965,40371754.94693918,39744238.94350318,39126573.7021429,
	38518603.941261604,37920176.82776173,37331141.95456852,36751351.28396123,36180659.12529839,
	35618922.08508724,35065999.04377891,34521751.10608115,33986041.57801751,33458735.91999447,
	32939701.722955313,32428808.672042772,31925928.50883687,31430935.000833787,30943703.914456353,
	30464112.978947796,29992041.850540858,29527372.092578888,29069987.137311455,28619772.25974932,
	28176614.54537806,27740402.866218805,27311027.84767197,26888381.84510052,26472358.913073324,
	26062854.778249305,25659766.81607147,25262994.022853557,24872436.989202328,24487997.87649407,
	24109580.39067407,23737089.75801839,23370432.702533927,23009517.419651583,22654253.554156143,
	22304552.18005397,21960325.771507792,21621488.187422674,21287954.645145535,20959641.700694382,
	20636467.226893097,20318350.393772915,20005211.645684965,19696972.68401339,19393556.445680972,
	19094887.08266338,18800889.944256064,18511491.558969628,18226619.613059517,17946202.934068374,
	17670171.47293652,17398456.285697665,17130989.515861325,16867704.377303254,16608535.137558183,
	16353417.101015145,16102286.592136698,15855080.940130878,15611738.46278565,15372198.449851058,
	15136401.149331953,14904287.751130465,14675800.372050812,14450882.042408813,14229476.689954542,
	14011529.127070865,13796985.035994047,13585790.955106167,13377894.265559696,13173243.178215832,
	12971786.719945535,12773474.72113544,12578257.80284215,12386087.364231719,12196915.5706573,
	12010695.340889372,11827380.33596328,11646924.946655996,11469284.282643408,11294414.160658795,
	11122271.093725508,10952812.27960185,10785995.590636916,10621779.562370462,10460123.383911472,
	10300986.88676655,10144330.535258777,9990115.416210404,9838303.229250757,9688856.27720527,
	9541737.45638481,9396910.247309513,9254338.705539547,9113987.45235729,8975821.666201398,
	8839807.073523026,8705909.940281913,8574097.06340123,8444335.762451967,8316593.871238582,
	8190839.729846565,8067042.176602708,7945170.540058976,7825194.631465762,7707084.737103136,
	7590811.610554823,7476346.465739478,7363660.969210521,7252727.233343678,7143517.80909609,
	7036005.679235208,6930164.2513858965,6825967.351341339,6723389.216618317,6622404.489762214,
	6522988.212019148,6425115.817165346,6328763.125067435,6233906.335889033,6140522.023795062,
	6048587.131265951,5958078.963182424,5868975.1811489705,5781253.797846137,5694893.1715141935,
	5609872.000431549,5526169.317668177,5443764.485693767,5362637.191276858,5282767.440281302,
	5204135.55270403,5126722.157679034,5050508.188611364,4975474.878414023,4901603.754717111,
	4828876.635282692,4757275.623403806,4686783.103401577,4617381.736199523,4549054.454982275,
	4481784.460850307,4415555.218664232,4350350.452833378,4286154.143255484,4222950.521289876,
	4160724.065767983,4099459.4991252352,4039141.7835417907,3979756.1171831125,3921287.930457086,
	3863722.8823759174,3807046.856954259,3751245.9596443675,3696306.5138756456,3642215.05760076,
	3588958.3399286834,3536523.317778415,3484897.152651109,3434067.2073522992,3384021.04286434,
	3334746.4152041217,3286231.27235773,3238463.7512701256,3191432.174852442,3145125.049056685,
	3099531.060010604,3054639.071163362,3010438.12050655,2966917.4178237873,2924066.341984946,
	2881874.4382839506,2840331.4158312157,2799427.1449634978,2759151.65471494,2719495.1303192903,
	2680447.910749387,2642000.4863033965,2604143.496223757,2566867.7263536686,2530164.106834272,
	2494023.709830302,2458437.747306912,2423397.5688183317,2388894.659359845,2354920.63722688,
	2321467.2519262116,2288526.3821131657,2256090.0335570276,2224150.337153489,2192699.5469469884,
	2161730.03820909,2131234.3055204945,2101204.9609069987,2071634.731989644,2042516.4601734509,
	2013843.098856428,1985607.71167397,1957803.4707667707,1930423.6550781257,1903461.648676287,
	1876910.9391083145,1850765.1157696003,1825017.868312904,1799662.9850679457,1774694.3515015438,
	1750105.9486862873,1725891.8518042488,1702046.2286728336,1678563.3382887393,1655437.52940003,
	1632663.2390992746,1610234.9914366344,1588147.396060492,1566395.1468729714,1544973.0207094543,
	1523875.8760417977,1503098.6516976887,1482636.3656002646,1462484.1135333236,1442637.06791854,
	1423090.4766165037,1403839.661746427,1384880.0185225182,1366207.0141104457,1347816.1865012331,
	1329703.1434030312,1311863.5611501765,1294293.1836299584,1276987.8212252485,1259943.349775401,
	1243155.7095523516,1226620.9042530223,1210335.0000079786,1194294.124405948,1178494.4655323653,
	1162932.271024998,1147603.8471430354,1132505.5578516882,1117633.8239200928,1102985.1220348773,
	1088555.9839270683,1074342.9955122098,1060342.7960449175,1046552.0772857628,1032967.5826831006,
	1019586.1065651438,1006404.4933469357,993419.6367485176,980628.4790268893,968028.0102180156,
	955615.2673920318,943387.3339206033,931341.3387545368,919474.4557132333,907783.9027859675,
	896266.9414433932,884920.8759599816,873743.052747118,862730.8596971147,851881.7255369752,
	841193.1191922859,830662.5491616264,820287.5629003386,810065.746213833,799994.7226609929,
	790072.152966555,780295.7344423555,770663.2004185508,761172.319682491,751820.8959279032,
	742606.7672110592,733527.8054168982,724581.9157325112,715767.0361293264,707081.1368530273,
	698522.2199219869,690088.3186330348,681777.4970749997,673587.8496501999,665517.5006028191,
	657564.6035553108,649727.3410513675,642003.9241064212,634392.5917650447,626891.6106651584,
	619499.2746091963,612213.9041415772,605033.8461332531,597957.473372261,590983.1841608789,
	584109.401918906,577334.5747932878,570657.1752734288,564075.6998130382,557588.6684571325,
	551194.624475371,544892.1340009242,538679.7856747393,532556.1902955152,526519.980475037,
	520569.8102988164,514704.3549918767,508922.31058998575,503222.3936156153,497603.3407591313,
	492063.90856482467,486602.8731217911,481219.0297595493,475911.19274837704,470678.19500426186,
	465518.8877984077,460432.14047113893,455416.8401502724,450471.89147379476,445596.21631690586,
	440788.75352298666,436048.4586390225,431374.3036548693,426765.27674662636,422220.38202389586,
	417738.639280965,413319.08375175786,408960.7658685776,404662.7510245751,400424.1193397939,
	396243.96543084434,392121.3981840541,388055.5405322183,384045.5292346688,380090.5146606782,
	376189.66057631274,372342.1439344214,368547.1546679411,364803.89548629633,361111.5816749514,
	357469.4408980297,353876.71300396445,350332.6498340893,346836.5150342151,343387.58386905055,
	339985.14303946425,336628.49050258996,333316.9352946693,330049.797356536,326826.4073619536,
	323646.1065483546,320508.2465503685,317412.18923581083,314357.3065442042,311342.9803277411,
	308368.6021947963,305433.5733557462,302537.3044711386,299679.2155022741,296858.7355640721,
	294075.3027801393,291328.3641401029,288617.37535919563,285941.80073986546,283301.11303565715,
	280694.79331713164,278122.3308398309,275583.2229143228,273076.9747782347,270603.0994702333,
	268161.117706034,265750.5577562191,263370.9553260227,261021.85343696838,258702.80231029575,
	256413.35925226187,254153.08854113822,251921.56131604649,249718.355467464,247543.055529455,
	245395.25257354724,243274.54410432433,241180.53395656176,239112.83219404437,237071.05500989148,
	235054.82462850865,233063.76920899155,231097.52275012885,229155.72499680205,227238.02134792402,
	225344.06276577318,223473.50568678096,221626.01193369835,219801.24862913473,217998.88811049933,
	216218.60784623187,214460.09035337353,212723.02311643754,211007.0985075814,209312.01370796698,
	207637.4706304674,205983.1758435048,204348.84049614437,202734.18024435235,201138.91517845046,
	199562.76975168448,198005.47270996115,196466.75702266805,194946.35981463097,193444.02229913353,
	191959.48971200036,190492.51124675406,189042.83999076486,187610.2328624897,186194.45054962445,
	184795.2574483444,183412.42160342782,182045.7146494065,180694.9117526216,179359.7915542316,
	178040.1361141112,176735.7308556925,175446.36451165073,174171.8290704869,172911.91972398257,
	171666.43481546894,170435.1757889675,169217.94713913393,168014.55636200626,166824.8139065509,
	165648.5331270346,164485.53023609065,163335.6242586143,162198.63698637372,161074.3929333762,
	159962.7192919273,158863.44588945186,157776.40514597628,156701.43203232152,155638.3640289799,
	154587.04108565734,153547.3055814697,152519.0022857954,151501.97831977525,150496.0831184263,
	149501.16839338402,148517.0880962456,147543.69838253688,146580.8575762251,145628.42613487,
	144686.26661529404,143754.2436398458,142832.2238632158,141920.07593977512,141017.67049148242,
	140124.8800762855,139241.579157077,138367.64407111864,137502.953000017,136647.38594014326,
	135800.8246735859,134963.1527395463,134134.2554062235,133314.0196431613,132502.33409404545,
	131699.08904994724,130904.17642302565,130117.48972063763,129338.92401989107,128568.37594262259,
	127805.74363077342,127050.92672217904,126303.82632676269,125564.34500311418,124832.38673546354,
	124107.8569110229,123390.66229771594,122680.71102227308,121977.91254867098,121282.1776569651,
	120593.41842242425,119911.54819505081,119236.48157942184,118568.13441485698,117906.4237559299,
	117251.26785329287,116602.58613481229,115960.29918703012,115324.32873692017,114694.59763395197,
	114071.02983244395,113453.55037421799,112842.08537152912,112236.5619902914,111636.90843356056,
	111043.0539253104,110454.92869446082,109872.4639591827,109295.59191144536,108724.24570183732,
	108158.35942461745,107597.8681030371,107042.70767487705,106492.81497824215,105948.12773758188,
	105408.58454994064,104874.12487143915,104344.68900397545,103820.21808214084,103300.65406035449,
	102785.93970021285,102276.01855804046,101770.83497264587,101270.33405328635,100774.46166781904,
	100283.16443105006,99796.3896932819,99314.0855290374,98836.20072597537,98362.68477398297,
	97893.48785445212,97428.56082972366,96967.85523271392,96511.32325669924,96058.91774527697,
	95610.59218248197,95166.3006830727,94725.99798296786,94289.6394298411,93857.18097387221,
	93428.57915864428,93003.79111219334,92582.77453819216,92165.4877072936,91751.8894486015,
	91341.93914128645,90935.5967063319,90532.82259841684,90133.57779793536,89737.82380313173,
	89345.52262237165,88956.63676654019,88571.12924155587,88188.9635410066,87810.10363890647,
	87434.51398256836,87062.15948558983,86693.00552095033,86327.01791422529,85964.1629368986,
	85604.40729979333,85247.71814659824,84894.06304750344,84543.40999293413,84195.72738738863,
	83850.98404336744,83509.14917540674,83170.19239420345,82834.08370082994,82500.79348104603,
	82170.29249970037,81842.55189521474,81517.54317416667,81195.2382059427,80875.60921749321,
	80558.62878815221,80244.2698445542,79932.5056556231,79623.3098276379,79316.65629938208,
	79012.51933736372,78710.87353111894,78411.69378857335,78114.95533149279,77820.63369099406,
	77528.70470313028,77239.14450454607,76951.92952819442,76667.03649912479,76384.44243034064,
	76104.12461870702,75826.0606409404,75550.22834964405,75276.60586941517,75005.1715930038,
	74735.90417754401,74468.78254082431,74203.78585763143,73940.89355614429,73680.08531438017,
	73421.34105670126,73164.6409503689,72909.96540215699,72657.29505500729,72406.61078474861,
	72157.89369685262,71911.12512324752,71666.28661917949,71423.35996011485,71182.3271386968,
	70943.17036174725,70705.87204730567,70470.41482172393,70236.7815167961,70004.95516693784,
	69774.91900639964,69546.65646653177,69320.15117308269,69095.38694353921,68872.34778450965,
	68651.01788914143,68431.38163458083,68213.42357946612,67997.12846146115,67782.48119482554,
	67569.46686801716,67358.07074133455,67148.27824458847,66940.07497481607,66733.44669401672,
	66528.37932693098,66324.8589588487,66122.87183344706,65922.4043506629,65723.44306459348,
	65525.97468142919,65329.986057417635,65135.464196851746,64942.39625009385,64750.7695116211,
	64560.57141810603,64371.789546518674,64184.41161225832,63998.42546731224,63813.819098441,
	63630.58062538517,63448.69829910626,63268.16050004143,63088.95573639221,62911.072642434316,
	62734.49997684426,62559.22662106546,62385.24157767926,62212.5339688091,62041.093034546946,
	61870.90813139514,61701.968730738605,61534.264417329694,61367.7848877984,61202.5199491836,
	61038.459517482785,60875.59361621954,60713.91237503797,60553.40602830667,60394.064913747636,
	60235.87947108413,60078.84024070269,59922.93786233594,59768.16307376438,59614.50670953055,
	59461.959699677696,59310.51306849612,59160.15793329583,59010.8855031871,58862.687077883464,
	58715.55404651552,58569.47788646244,58424.45016220094,58280.46252416448,58137.50670762032,
	57995.574531561055,57854.65789760989,57714.7487889391,57575.839269203185,57437.92148148684,
	57300.9876472636,57165.03006536902,57030.04111098835,56896.01323465293,56762.938961254404,
	56630.81088906589,56499.62168878026,56369.364102555235,56240.03094307509,56111.61509262076,
	55984.10950215246,55857.50719040312,55731.80124298419,55606.98481149935,55483.05111267279,
	55359.993427483976,55237.80510031615,55116.479538113825,54996.010209550055,54876.39064420237,
	54757.614431743285,54639.67522113437,54522.566719833645,54406.28269301313,54290.81696278116,
	54176.16340742029,54062.31596062775,53949.26861077227,53837.01540015127,53725.550424265384,
	53614.86783109598,53504.96182039468,53395.82664297957,53287.45660004084,53179.8460424577,
	53072.989370118514,52966.88103125521,52861.51552178239,52756.88738464797,52652.99120919144,
	52549.82163050973,52447.37332883548,52345.641028920225,52244.619499430264,52144.303552349316,
	52044.688042392314,51945.7678664286,51847.53796291269,51749.99331133026,51653.128931648134,
	51556.93988378018,51461.42126706157,51366.568219734145,51272.37591844632,51178.839577759565,
	51085.95444967448,50993.715823164726,50902.119023726715,50811.159412942405,50720.83238805871,
	50631.13338158043,50542.05786088085,50453.60132782844,50365.7593184314,50278.5274025023,
	50191.90118333939,50105.876297432595,50020.448414187245,49935.613235671786,49851.36649639185,
	49767.70396308659,49684.62143455117,49602.114741489524,49520.179746395,49438.81234346037,
	49358.00845852278,49277.76404904041,49198.07510410471,49118.937644491045,49040.34772274672,
	48962.301423320074,48884.79486273303,48807.82418979585,48731.38558587086,48655.475265181594,
	48580.089475172455,48505.2244969221,48430.876645608194,48357.04227102842,48283.71775817886,
	48210.89952789116,48138.584037530025,48066.767781753064,47995.44729333336,47924.61914404647,
	47854.27994562436,47784.42635077188,47715.05505425479,47646.16279405073,47577.746352568254,
	47509.80255793292,47442.328285336494,47375.320458454415,47308.77605092045,47242.69208786434,
	47177.06564750806,47111.89386281255,47047.173923175964,46982.90307617692,46919.078629357435,
	46855.69795203961,46792.758477168354,46730.257703173505,46668.19319584247,46606.562590195106,
	46545.363592347196,46484.59398135925,46424.25161104839,46364.33441175941,46304.84039208104,
	46245.76764048661,46187.11432689321,46128.878704118775,46071.05910922331,46013.6539647185,
	45956.6617796265,45900.08115037732,45843.910761520616,45788.14938623876,45732.79588664929,
	45677.84921387047,45623.30840784276,45569.17259688814,45515.440996994854,45462.11291080871,
	45409.18772632989,45356.6649152948,45304.54403123758,45252.8247072279,45201.50665327466,
	45150.58965339446,45100.0735623454,45049.95830202577,45000.24385754338,44950.930272959056,
	44902.01764671639,44853.50612676857,44805.395905413265,44757.68721385663,44710.38031652491,
	44663.47550513778,44616.973092581226,44570.873406590574,44525.17678328257,44479.883560559356,
	44434.99407141975,44390.508637206054,44346.427560823744,44302.75111996211,44259.479560357664,
	44216.61308912709,44174.1518682098,44132.09600795005,44090.44556085202,44049.20051554151,
	44008.36079096259,43967.92623083742,43927.896598419225,43888.27157155914,43849.05073811122,
	43810.23359169715,43771.81952784397,43733.807840513604,43696.19771903389,43658.98824543941,
	43622.17839223223,43585.76702055975,43549.75287881761,43514.13460166885,43478.91070947925,
	43444.079608161424,43409.63958941422,43375.58883135185,43341.92539950505,43308.64724818085,
	43275.75222216244,43243.238058732655,43211.10238999971,43179.34274550769,43147.95655510722,
	43116.941152066494,43086.29377639842,43056.01157838508,43026.09162227473,42996.53089012741,
	42967.326285791605,42938.47463898612,42909.97270946806,42881.817191270246,42854.00471697817,
	42826.53186204157,42799.39514909347,42772.59105225937,42746.116001449314,42719.96638661218,
	42694.13856193437,42668.62884998298,42643.43354576951,42618.54892073273,42593.971226624395,
	42569.69669929814,42545.72156238331,42522.04203085076,42498.654314453954,42475.554621046664,
	42452.739159775236,42430.204144136085,42407.945794907246,42385.96034293732,42364.244031811926,
	42342.79312037457,42321.60388512465,42300.67262247487,42279.99565088185,42259.56931284931,
	42239.389976801795,42219.454038835414,42199.7579243489,42180.298089557495,42161.07102288902,
	42142.07324627101,42123.30131631241,42104.75182537964,42086.42140257254,42068.30671460486,
	42050.404466594475,42032.711402762434,42015.22430705441,41997.94000366853,41980.85535752472,
	41963.96727464694,41947.2727024815,41930.7686301545,41914.452088658625,41898.32015099027,
	41882.36993222626,41866.598589551526,41851.003322238146,41835.581371579545,41820.33002078047,
	41805.24659480919,41790.32846021549,41775.573024901045,41760.977737886074,41746.540089016045,
	41732.25760866134,41718.12786738248,41704.14847557984,41690.31708311738,41676.631378929094,
	41663.08909061135,41649.68798399576,41636.42586270943,41623.30056772815,41610.3099769114,
	41597.45200453045,41584.72460079472,41572.1257513596,41559.653476837804,41547.30583230381,
	41535.08090679089,41522.976822786244,41510.991735743475,41499.12383354673,41487.37133602507,
	41475.732494438096,41464.20559097361,41452.78893824208,41441.48087877382,41430.27978451849,
	41419.18405634953,41408.19212356703,41397.30244341491,41386.5135005865,41375.82380674854,
	41365.23190006214,41354.73634471096,41344.33573043554,41334.0286720704,41323.81380908812,
	41313.68980515038,41303.65534766243,41293.70914733486,41283.84993775349,41274.07647494771,
	41264.38753697813,41254.78192351654,41245.25845544174,41235.81597443919,41226.45334260274,
	41217.16944205157,41207.96317454588,41198.83346111181,41189.779241671924,41180.7994746877,
	41171.893136792314,41163.05922245307,41154.29674362289,41145.60472939794,41136.98222569713,
	41128.42829492783,41119.94201566795,41111.52248236096,41103.16880499793,41094.880108820405,
	41086.65553402962,41078.49423548818,41070.39538244338,41062.35815824236,41054.381760063276,
	41046.465398643515,41038.608298023304,41030.80969527839,41023.068840280124,41015.38499543582,
	41007.75743545678,41000.18544711189,40992.66832900348,40985.20539133446,40977.79595568387,
	40970.43935479156,40963.13493234515,40955.88204276152,40948.68005099252,40941.528332314265,
	40934.426272136516,40927.373265805014,40920.36871841248,40913.412044617406,40906.5026684558,
	40899.640023171996,40892.8235510346,40886.05270316995,40879.326939404324,40872.645728081356,
	40866.00854592203,40859.41487784476,40852.86421683995,40846.35606379466,40839.8899273567,
	40833.465323793884,40827.08177684032,40820.73881756713,40814.43598424893,40808.17282221823,
	40801.948883753495,40795.7637279311,40789.61692052149,40783.50803385095,40777.43664669102,
	40771.40234413462,40765.4047174866,40759.44336414968,40753.517887512426,40747.627896843536,
	40741.77300717912,40735.95283924106,40730.16701930306,40724.415179112206,40718.696955791944,
	40713.011991733874,40707.359934516935,40701.74043680952,40696.15315628132,40690.59775551662,
	40685.07390192217,40679.581267648064,40674.11952950792,40668.68836888931,40663.28747168117,
	40657.91652819281,40652.575233072064,40647.26328524754,40641.98038783607,40636.72624808164,
	40631.50057727804,40626.303090711684,40621.13350757715,40615.99155092525,40610.87694759032,
	40605.78942812724,40600.72872675106,40595.69458127591,40590.68673304774,40585.70492689632,
	40580.748911070696,40575.81843718151,40570.91326014787,40566.03313814472,40561.17783254408,
	40556.34710786586,40551.540731724876,40546.75847478647,40542.00011070545,40537.26541608252,
	40532.554170428506,40527.866156092554,40523.201158239026,40518.558964793985,40513.93936639573,
	40509.34215636362,40504.76713063766,40500.21408775999,40495.68282881253,40491.17315739016,
	40486.68487955217,40482.21780379192,40477.77174099412,40473.34650439719,40468.941909556386,
	40464.55777430909,40460.193918746016,40455.85016515885,40451.52633802352,40447.22226396154,
	40442.937771703786,40438.67269206151,40434.42685788838,40430.200104062846,40425.99226744672,
	40421.803186854086,40417.632703032374,40413.480658616376,40409.3468981243,40405.23126790127,
	40401.133616118466,40397.053792725645,40392.99164943497,40388.947039696955,40384.91981866737,
	40380.90984318381,40376.916971748884,40372.941064496925,40368.981983174235,40365.03959111312,
	40361.11375320934,40357.20433590786,40353.31120716632,40349.434236442146,40345.573294670954,
	40341.728254243855,40337.89898898519,40334.0853741325,40330.28728632195,40326.504603560425,
	40322.73720521084,40318.98497197426,40315.24778586829,40311.525530205945,40307.81808958504,
	40304.125349866736,40300.44719815631,40296.783522788086,40293.13421331055,40289.49916045597,
	40285.87825614769,40282.27139346384,40278.67846663568,40275.09937101723,40271.53400308445,
	40267.98226040704,40264.44404164872,40260.919246534584,40257.40777585691,40253.909531440244,
	40250.42441614249,40246.95233383501,40243.493189392306,40240.04688867408,40236.61333851654,
	40233.192446717105,40229.784122026744,40226.38827412502,40223.0048136184,40219.63365204126,
	40216.27470180621,40212.92787622711,40209.59308949613,40206.27025666401,40202.95929364237,
	40199.66011719165,40196.37264489066,40193.09679515756,40189.83248721292,40186.579641083954,
	40183.33817758291,40180.108018311286,40176.88908564033,40173.681302700046,40170.48459337758,
	40167.29888230196,40164.124094831786,40160.96015705708,40157.80699578055,40154.66453850979,
	40151.53271345505,40148.41144951415,40145.30067626541,40142.20032395815,40139.11032351228,
	40136.030606495966,40132.961105132024,40129.90175228634,40126.85248144579,40123.813226735794,
	40120.783922889874,40117.76450525864,40114.75490978761,40111.755073028995,40108.76493211383,
	40105.78442476067,40102.81348925595,40099.85206446879,40096.90008980994,40093.957505257,
	40091.02425133593,40088.10026910839,40085.185500175714,40082.2798866672,40079.383371235504,
	40076.495897047025,40073.61740778377,40070.747847633625,40067.887161275314,40065.03529388979,
	40062.19219114349,40059.35779918031,40056.532064624604,40053.71493457678,40050.90635659614,
	40048.10627870312,40045.314649379245,40042.53141755004,40039.756532584695,40036.989944304376,
	40034.231602955166,40031.4814592168,40028.73946419473,40026.00556941397,40023.27972681765,
	40020.561888755976,40017.85200799776,40015.15003770045,40012.45593143003,40009.769643142536,
	40007.09112718115,40004.42033827731,40001.75723154833,39999.101762474114,39996.45388692601,
	39993.813561127754,39991.180741680386,39988.555385536674,39985.937450015175,39983.326892781086,
	39980.72367185076,39978.12774558493,39975.53907269358,39972.95761221626,39970.38332353325,
	39967.81616635255,39965.256100716666,39962.70308697943,39960.15708582874,39957.618058266664,
	39955.085965605846,39952.560769474105,39950.042431805545,39947.53091483601,39945.02618111108,
	39942.52819346488,39940.03691503527,39937.55230924969,39935.07433981895,39932.60297074611,
	39930.138166320554,39927.67989110934,39925.22810995104,39922.78278796739,39920.343890551245,
	39917.911383357045,39915.48523231565,39913.06540362042,39910.651863718485,39908.244579325205,
	39905.8435174077,39903.44864518354,39901.0599301248,39898.67733995401,39896.30084263743,
	39893.93040638089,39891.56599964308,39889.20759110887,39886.85514970744,39884.50864459922,
	39882.16804517759,39879.8333210604,39877.50444210911,39875.18137839021,39872.86410021019,
	39870.55257807993,39868.24678274186,39865.94668515151,39863.652256477384,39861.36346810189,
	39859.08029161813,39856.80269882862,39854.530661737495,39852.26415256504,39850.00314371615,
	39847.747607811565,39845.497517666525,39843.25284629302,39841.013566893766,39838.77965287373,
	39836.55107781952,39834.32781551294,39832.10983992578,39829.897125212694,39827.68964571105,
	39825.48737594365,39823.290290612924,39821.09836460339,39818.91157297501,39816.72989096233,
	39814.55329397807,39812.38175760367,39810.21525759389,39808.053769879465,39805.8972705477,
	39803.74573585716,39801.59914223337,39799.457466267624,39797.320684711,39795.18877446809,
	39793.06171260993,39790.93947637209,39788.822043135486,39786.70939043757,39784.60149597453,
	39782.498337589124,39780.39989327891,39778.30614119386,39776.21705962451,39774.13262701124,
	39772.05282194511,39769.97762314994,39767.90700950889,39765.84096003741,39763.77945388444,
	39761.722470357796,39759.66998888031,39757.6219890337,39755.57845051865,39753.539353177715,
	39751.50467699169,39749.47440206362,39747.448508635316,39745.42697707225,39743.40978787412,
	39741.39692166362,39739.38835920046,39737.38408135497,39735.38406913064,39733.388303662294,
	39731.39676618758,39729.40943808237,39727.42630083748,39725.44733605953,39723.472525484074,
	39721.50185094733,39719.53529441943,39717.572837972664,39715.6144637995,39713.66015421064,
	39711.709891617145,39709.76365855521,39707.821437661994,39705.88321168443,39703.948963492054,
	39702.018676047075,39700.09233242334,39698.169915804305,39696.25140947128,39694.336796815114,
	39692.42606133407,39690.519186625206,39688.616156384225,39686.716954412455,39684.82156461357,
	39682.9299709829,39681.04215762497,39679.158108728676,39677.277808568804,39675.40124161589,
	39673.52839227024,39671.659245143615,39669.79378490895,39667.93199633375,39666.073864278165,
	39664.21937369796,39662.3685096348,39660.52125722156,39658.67760168643,39656.83752833707,
	39655.00102257366,39653.168069894244,39651.338655863445,39649.51276614661,39647.69038648964,
	39645.87150273583,39644.05610078121,39642.244166642624,39640.435686460914,39638.6306462066,
	39636.82903232465,39635.030831071344,39633.23602886007,39631.44461217701,39629.65656758559,
	39627.8718817395,39626.09054135468,39624.31253324278,39622.537844264014,39620.7664613877,
	39618.99837163159,39617.233562111236,39615.47202000163,39613.713732549004,39611.95868708966,
	39610.206871012735,39608.45827179116,39606.712876981415,39604.97067417901,39603.23165108105,
	39601.49579543391,39599.76309506744,39598.033537871604,39596.30711181354,39594.58380491591,
	39592.86360528039,39591.14650107335,39589.432480522664,39587.721531928546,39586.01364365288,
	39584.30880411414,39582.607001820485,39580.90822531715,39579.21246323196,39577.519704241065,
	39575.82993710431,39574.143150615164,39572.459333646424,39570.7784751371,39569.10056407046,
	39567.42558950795,39565.75354055871,39564.08440639941,39562.418176252875,39560.75483942319,
	39559.09438525087,39557.43680314862,39555.782082576035,39554.130213056415,39552.48118416676,
	39550.83498555116,39549.19160688796,39547.55103793509,39545.913268490316,39544.27828840501,
	39542.646087590096,39541.01665602056,39539.38998370225,39537.7660607153,39536.144877180464,
	39534.52642327636,39532.910689230106,39531.2976653237,39529.68734188924,39528.07970931208,
	39526.47475801731,39524.872478495476,39523.272861285404,39521.67589696653,39520.08157616854,
	39518.489889579825,39516.90082793229,39515.31438199501,39513.73054260062,39512.14930062341,
	39510.570646992266,39508.994572665106,39507.42106866709,39505.85012605495,39504.28173593173,
	39502.715889460145,39501.15257783784,39499.591792310595,39498.03352415772,39496.47776472511,
	39494.9245053847,39493.373737559166,39491.82545271839,39490.279642357724,39488.73629804106,
	39487.195411365465,39485.656973953,39484.12097750042,39482.58741371855,39481.05627437366,
	39479.5275512669,39478.00123624487,39476.477321195736,39474.95579804002,39473.43665875841,
	39471.91989533869,39470.405499846325,39468.89346435174,39467.38378099493,39465.87644192637,
	39464.37143935884,39462.86876552703,39461.36841271573,39459.870373238584,39458.37463946078,
	39456.881203768666,39455.390058587676,39453.90119639239,39452.41460968615,39450.930291009565,
	39449.44823293276,39447.96842808007,39446.490869091685,39445.01554865589,39443.5424594869,
	39442.07159435091,39440.602946027044,39439.13650734794,39437.6722711678,39436.2102303781,
	39434.75037791226,39433.29270673106,39431.83720982525,39430.38388022951,39428.93271100216,
	39427.483695232964,39426.03682605302,39424.592096626075,39423.149500141895,39421.70902981901,
	39420.27067892608,39418.83444074549,39417.40030859658,39415.9682758329,39414.53833583674,
	39413.1104820201,39411.68470782612,39410.261006729284,39408.839372244285,39407.41979789847,
	39406.00227725733,39404.58680391929,39403.17337150879,39401.761973684224,39400.352604123516,
	39398.94525654632,39397.53992469389,39396.1366023344,39394.735283272006,39393.335961327895,
	39391.93863036808,39390.54328426847,39389.14991694943,39387.75852234712,39386.369094431364,
	39384.98162719409,39383.59611466876,39382.21255089276,39380.83092994725,39379.451245936376,
	39378.07349299708,39376.69766527397,39375.32375696283,39373.95176226436,39372.581675417125,
	39371.213490673916,39369.84720233689,39368.48280470934,39367.12029213461,39365.759658968396,
	39364.4008996011,39363.04400845467,39361.68897995892,39360.33580857505,39358.9844887867,
	39357.63501511946,39356.28738210462,39354.941584297456,39353.59761628091,39352.25547267192,
	39350.91514808913,39349.5766371923,39348.23993466825,39346.905035207536,39345.571933543986,
	39344.24062441426,39342.91110259831,39341.583362888836,39340.25740010171,39338.933209067036,
	39337.6107846577,39336.29012174765,39334.97121524461,39333.65406007863,39332.3386512003,
	39331.02498357972,39329.713052200896,39328.40285208105,39327.094378263755,39325.78762579704,
	39324.48258975748,39323.179265247876,39321.87764738812,39320.577731324,39319.2795121982,
	39317.98298520757,39316.68814555359,39315.39498845022,39314.10350914173,39312.81370289947,
	39311.52556499178,39310.2390907304,39308.954275435986,39307.671114450844,39306.3896031286,
	39305.10973685823,39303.831511034594,39302.55492108165,39301.27996243028,39300.0066305463,
	39298.73492090131,39297.46482898582,39296.196350325175,39294.9294804352,39293.664214877674,
	39292.40054921767,39291.138479043424,39289.87799996061,39288.619107593266,39287.36179758509,
	39286.106065588414,39284.85190728142,39283.59931837001,39282.34829455259,39281.098831565876,
	39279.85092515508,39278.6045710885,39277.359765140565,39276.11650311319,39274.87478082996,
	39273.63459410955,39272.3959388173,39271.15881080985,39269.923205971914,39268.68912020722,
	39267.45654942392,39266.225489567965,39264.99593657864,39263.76788641642,39262.541335069356,
	39261.3162785383,39260.09271283318,39258.87063398464,39257.65003803704,39256.430921047926,
	39255.2132790982,39253.99710827339,39252.782404692174,39251.569164471446,39250.35738375495,
	39249.14705868417,39247.93818543541,39246.73076019007,39245.52477915009,39244.32023852998,
	39243.11713455647,39241.915463470665,39240.715221527236,39239.51640501617,39238.31901020704,
	39237.123033402335,39235.92847092879,39234.73531911337,39233.54357429509,39232.35323283217,
	39231.164291109846,39229.97674549725,39228.79059241161,39227.60582826185,39226.422449472346,
	39225.24045249157,39224.059833771025,39222.88058978137,39221.702717014115,39220.52621194948,
	39219.35107111007,39218.1772910131,39217.00486820814,39215.8337992243,39214.66408064039,
	39213.495709022645,39212.32868096768,39211.16299307157,39209.99864195545,39208.83562425195,
	39207.67393658387,39206.51357561024,39205.35453800682,39204.19682044396,39203.04041961711,
	39201.88533222303,39200.73155497171,39199.57908461147,39198.427917869434,39197.27805149275,
	39196.12948226145,39194.982206934794,39193.83622231174,39192.69152519553,39191.54811239245,
	39190.40598072255,39189.26512702521,39188.12554815387,39186.98724096525,39185.85020232463,
	39184.71442911885,39183.57991824006,39182.44666659481,39181.314671100976,39180.183928681574,
	39179.05443628412,39177.92619085683,39176.799189359524,39175.67342876157,39174.548906048905,
	39173.42561821546,39172.30356227262,39171.18273523181,39170.06313411323,39168.94475597142,
	39167.82759785162,39166.71165679987,39165.59692990214,39164.48341423463,39163.371106885934,
	39162.26000495942,39161.15010556326,39160.04140583167,39158.93390288812,39157.82759387627,
	39156.72247594546,39155.61854627035,39154.51580201987,39153.414240382,39152.313858541354,
	39151.21465370235,39150.116623088805,39149.019763918724,39147.92407342519,39146.82954884949,
	39145.73618745755,39144.64398649765,39143.55294324358,39142.463054981374,39141.37431901062,
	39140.2867326141,39139.200293120215,39138.11499784102,39137.03084410542,39135.947829252495,
	39134.865950634885,39133.785205610446,39132.70559153901,39131.62710580377,39130.54974578661,
	39129.47350888209,39128.398392486706,39127.32439402611,39126.25151091862,39125.17974058055,
	39124.109080464455,39123.039528019086,39121.97108069485,39120.90373596179,39119.83749128851,
	39118.77234416655,39117.70829208101,39116.645332527354,39115.58346301953,39114.52268108833,
	39113.46298424049,39112.40437001608,39111.346835961194,39110.29037962598,39109.234998562424,
	39108.180690344605,39107.12745255408,39106.07528276842,39105.024178573774,39103.97413758667,
	39102.925157402315,39101.87723563944,39100.83036993208,39099.784557896375,39098.73979719458,
	39097.696085456635,39096.65342034786,39095.61179953956,39094.571220686725,39093.53168148228,
	39092.49317960822,39091.45571276236,39090.41927865763,39089.383874989864,39088.34949948889,
	39087.31614986477,39086.28382387416,39085.25251923864,39084.22223371952,39083.19296506628,
	39082.164711045894,39081.137469427034,39080.11123799448,39079.08601452965,39078.06179681455,
	39077.03858267641,39076.01636988896,39074.995156297635,39073.974939708685,39072.955717954406,
	39071.93748887064,39070.920250296775,39069.90400009512,39068.8887361209,39067.874456216785,
	39066.861158277534,39065.84884017501,39064.83749979064,39063.82713502812,39062.81774377224,
	39061.8093239316,39060.80187342097,39059.795390165935,39058.789872081004,39057.785317105365,
	39056.78172317438,39055.779088246156,39054.777410252034,39053.7766871639,39052.77691695887,
	39051.778097581024,39050.78022703547,39049.783303291544,39048.78732434748,39047.79228820393,
	39046.7981928536,39045.8050363196,39044.81281661342,39043.82153175216,39042.83117978554,
	39041.84175872499,39040.85326663432,39039.86570154244,39038.879061523,39037.89334462201,
	39036.90854890443,39035.924672465764,39034.941713353954,39033.95966968175,39032.97853951565,
	39031.99832097207,39031.01901214928,39030.040611150864,39029.0631160955,39028.086525098464,
	39027.11083629734,39026.13604781065,39025.16215778937,39024.189164380856,39023.21706571736,
	39022.24585996317,39021.27554527948,39020.30611984658,39019.33758181356,39018.36992936942,
	39017.40316070769,39016.437274002405,39015.47226746434,39014.50813927439,39013.54488765959,
	39012.58251082046,39011.62100697677,39010.66037434935,39009.70061117066,39008.741715667325,
	39007.78368608893,39006.82652067687,39005.87021767836,39004.91477534039,39003.96019193428,
	39003.00646573122,39002.05359499027,39001.101577996116,39000.15041302047,38999.20009836155,
	38998.25063231183,38997.302013152716,38996.35423919857,38995.407308757705,38994.46122014373,
	38993.51597166699,38992.57156164756,38991.627988431945,38990.685250335875,38989.74334570027,
	38988.80227287542,38987.86203019617,38986.92261602613,38985.98402872609,38985.04626665205,
	38984.109328166945,38983.173211647336,38982.23791547103,38981.30343802121,38980.36977768532,
	38979.43693285733,38978.50490192341,38977.57368328304,38976.643275368064,38975.7136765625,
	38974.78488529543,38973.85689997453,38972.92971904087,38972.00334091061,38971.07776402465,
	38970.15298682219,38969.22900773839,38968.305825226875,38967.383437735254,38966.4618437271,
	38965.54104166351,38964.62102999993,38963.70180722635,38962.783371799924,38961.86572220941,
	38960.948856930714
	}},
	{ // Ri = 250k
	-5,5,200,2001, {
	107069048.23743129,105392174.78838265,103741722.07577392,102117272.43912883,100518414.82119504,
	98944744.71680723,97395863.91792704,95871380.6772921,94370909.36532225,92894070.48447181,
	91440490.52891436,90009801.9741921,88601643.05107075,87215657.76537625,85851495.7408349,
	84508812.15729606,83187267.68499689,81886528.3326566,80606265.40051086,79346155.44117261,
	78105880.07200333,76885126.01281577,75683584.88938914,74500953.25309323,73336932.44764875,
	72191228.5318826,71063552.23644808,69953618.89884748,68861148.30066755,67785864.71445023,
	66727496.772842236,65685777.36613838,64660443.65864953,63651236.96481916,62657902.69393595,
	61680190.2503012,60717853.07730931,59770648.4537256,58838337.534924276,57920685.25355528,
	57017460.26273295,56128434.866906695,55253384.993136734,54392090.095996335,53544333.128903866,
	52709900.48211592,51888581.9183997,51080170.5414609,50284462.71830191,49501258.0354619,
	48730359.25620786,47971572.27216647,47224706.0226486,46489572.49718019,45765986.64069795,
	45053766.33328721,44352732.3313391,43662708.23125047,42983520.42143579,42314998.02716874,
	41656972.88634323,41009279.487877965,40371754.94693918,39744238.94121385,39126573.704330586,
	38518603.941261604,37920176.82776173,37331141.95456852,36751351.28396123,36180659.12529839,
	35618922.08508724,35065999.04377891,34521751.10608115,33986041.57801751,33458735.91999447,
	32939701.722909346,32428808.672039706,31925928.50883687,31430935.000833787,30943703.91559274,
	30464112.977849238,29992041.850540858,29527372.092578888,29069987.138272148,28619772.25974932,
	28176614.54537806,27740402.866218805,27311027.84767197,26888381.84587455,26472358.912328754,
	26062854.77753312,25659766.815385632,25262994.022853557,24872436.989202328,24487997.87649407,
	24109580.39067407,23737089.75856829,23370432.702533927,23009517.419630844,22654253.55464105,
	22304552.18005592,21960325.771507792,21621488.1874209,21287954.645145535,20959641.70028338,
	20636467.22689156,20318350.393413555,20005211.645684965,19696972.684340183,19393556.44566464,
	19094887.08236012,18800889.94451455,18511491.558691613,18226619.61279543,17946202.933812503,
	17670171.47293652,17398456.285687234,17130989.515863936,16867704.377313975,16608535.137763252,
	16353417.101001993,16102286.59212757,15855080.940309495,15611738.46278696,15372198.45002572,
	15136401.149489336,14904287.75097921,14675800.372054067,14450882.042260544,14229476.689962866,
	14011529.12706467,13796985.035994047,13585790.955106167,13377894.265551494,13173243.178200722,
	12971786.720041232,12773474.72102331,12578257.802725699,12386087.364139361,12196915.570663465,
	12010695.340980595,11827380.335969646,11646924.946650364,11469284.282638965,11294414.160725106,
	11122271.093715684,10952812.279602293,10785995.590622388,10621779.562431842,10460123.383960152,
	10300986.88682207,10144330.535255538,9990115.416202078,9838303.229246719,9688856.27720588,
	9541737.456378078,9396910.247317169,9254338.705536498,9113987.4523876,8975821.666225584,
	8839807.07352045,8705909.940273719,8574097.063395077,8444335.76241474,8316593.871232792,
	8190839.729870521,8067042.176595752,7945170.540056831,7825194.631486992,7707084.7370967325,
	7590811.610569768,7476346.465730939,7363660.969202223,7252727.233339269,7143517.809106437,
	7036005.679250802,6930164.251374476,6825967.351338061,6723389.216628724,6622404.489753881,
	6522988.212022008,6425115.817156182,6328763.1250745775,6233906.33588037,6140522.023785135,
	6048587.131268894,5958078.963181507,5868975.1811477365,5781253.797856088,5694893.171504767,
	5609872.000431472,5526169.31766904,5443764.4856930375,5362637.191281201,5282767.4402863365,
	5204135.552705912,5126722.157681635,5050508.1886156695,4975474.878416271,4901603.754725241,
	4828876.635288501,4757275.623407355,4686783.103403947,4617381.736207934,4549054.454983806,
	4481784.460855625,4415555.218664655,4350350.452833229,4286154.1432563765,4222950.521293908,
	4160724.0657678093,4099459.4991280017,4039141.783546744,3979756.117183024,3921287.930459358,
	3863722.8823818057,3807046.8569550547,3751245.9596456797,3696306.513878967,3642215.0576065043,
	3588958.3399320017,3536523.3177843513,3484897.1526577547,3434067.2073587417,3384021.04286983,
	3334746.415208044,3286231.2723644483,3238463.7512773587,3191432.174855831,3145125.0490620704,
	3099531.060015106,3054639.071170252,3010438.120514202,2966917.4178315187,2924066.3419907335,
	2881874.4382908936,2840331.415837839,2799427.144970544,2759151.654723209,2719495.1303265914,
	2680447.9107559966,2642000.4863096722,2604143.4962317133,2566867.7263619313,2530164.106841763,
	2494023.7098395037,2458437.7473151684,2423397.5688273455,2388894.659369566,2354920.637236761,
	2321467.251936472,2288526.3821225693,2256090.033567367,2224150.337163528,2192699.546957637,
	2161730.038219409,2131234.3055309057,2101204.9609173136,2071634.732000815,2042516.4601849746,
	2013843.0988683556,1985607.711686148,1957803.4707794352,1930423.6550901677,1903461.648689579,
	1876910.9391214491,1850765.115783348,1825017.868326289,1799662.9850824205,1774694.3515159127,
	1750105.9487009782,1725891.851819203,1702046.2286887157,1678563.3383049308,1655437.5294163923,
	1632663.2391157662,1610234.9914537536,1588147.396078297,1566395.1468904836,1544973.0207276347,
	1523875.8760608798,1503098.6517165091,1482636.3656200035,1462484.113553275,1442637.0679389562,
	1423090.4766373665,1403839.6617675973,1384880.0185443226,1366207.0141328163,1347816.186524197,
	1329703.143426579,1311863.561174287,1294293.18365467,1276987.8212504305,1259943.3498011783,
	1243155.7095787327,1226620.9042800602,1210335.0000355549,1194294.1244341,1178494.4655611552,
	1162932.271054416,1147603.8471732885,1132505.5578824072,1117633.8239515107,1102985.1220670827,
	1088555.983959997,1074342.995545855,1060342.7960793343,1046552.0773212153,1032967.5827193472,
	1019586.1066022035,1006404.4933846986,993419.6367872893,980628.4790665052,968028.01025841,
	955615.2674335737,943387.3339630202,931341.3387978203,919474.4557575514,907783.9028312954,
	896266.9414897817,884920.8760074208,873743.0527957104,862730.8597468846,851881.7255877958,
	841193.1192443575,830662.5492148455,820287.5629547647,810065.7462694858,799994.7227180407,
	790072.1530248572,780295.7345020741,770663.2004795362,761172.3197449361,751820.8959916915,
	742606.7672763556,733527.805483774,724581.915800922,715767.036199252,707081.1369246014,
	698522.2199952009,690088.3187079439,681777.4971516528,673587.8497285732,665517.5006830307,
	657564.6036373693,649727.3411352858,642003.9241923053,634392.5918529453,626891.610755081,
	619499.2747011916,612213.9042356968,605033.846229569,597957.4734707747,590983.1842616348,
	584109.4020219817,577334.5748987471,570657.1753813641,564075.6999234484,557588.6685700944,
	551194.6245909464,544892.1341191742,538679.785795713,532556.1904192925,526519.9806016842,
	520569.8104283852,514704.3551244476,508922.3107256147,503222.39375438244,497603.34090109984,
	492063.9087100784,486602.873270436,481219.0299116089,475911.19290397904,470678.19516347104,
	465518.887961305,460432.14063780924,455416.8403207892,450471.89164826996,445596.2164954323,
	440788.7537056558,436048.458825931,431374.30384612567,426765.27694231574,422220.38222412247,
	417738.639485849,413319.0839613945,408960.76608310046,404662.7512440929,400424.11956441,
	396243.96566067653,392121.3984192249,388055.5407728926,384045.5294809376,380090.514912689,
	376189.66083418415,372342.1441983065,368547.15493798454,364803.89576264075,361111.5819577244,
	357469.44118741556,353876.7133001038,350332.65013715473,346836.51534436253,343387.5841864362,
	339985.143364281,336628.49083501205,333316.9356348481,330049.7977046875,326826.40771826124,
	323646.1069130145,320508.2469235753,317412.1896177683,314357.30693511147,311342.98072782485,
	308368.60260428546,305433.57377484353,302537.30490007804,299679.21594129904,296858.7360134242,
	294075.30324005947,291328.36461085547,288617.37584102625,285941.80123304034,283301.1135404642,
	280694.7938338375,278122.33136872365,275583.2234556973,273076.9753323882,270603.10003748897,
	268161.11828669196,265750.5583506061,263370.95593447215,261021.85405981733,258702.80294789674,
	256413.35990496384,254153.0892093144,251921.5620000682,249718.35616771452,247543.0562463272,
	245395.25330745036,243274.54485566381,241180.5347257678,239112.83298154426,237071.05581613802,
	235054.8254539474,233063.77005409735,231097.52361538066,229155.72588268813,227238.0222549509,
	225344.0636944544,223473.50663764638,221626.01290728967,219801.24962600815,217998.8891312269,
	216218.60889138933,214460.09142356686,212723.02421228125,211007.09962969864,209312.0148570109,
	207637.47180709228,205983.17704839134,204348.84172997886,202734.18150785897,201138.91647235543,
	199562.77107673686,198005.47406692733,196466.75841232928,194946.36123780106,193444.02375664085,
	191959.4912046932,190492.512775499,189042.84155645632,187610.23446603824,186194.45219197264,
	184795.25913044636,183412.42332627406,182045.7164140034,180694.9135600146,179359.79340547332,
	178040.13801029584,176735.7327979373,175446.3665010976,174171.83110831483,172911.92181139445,
	171666.4369536997,170435.17797928955,169217.94938284255,168014.55866043182,166824.816261065,
	165648.5355390339,164485.53270701217,163335.62678993263,162198.63957960627,161074.39559006353,
	159962.7220136653,158863.4486778721,157776.40800274443,156701.43495915938,155638.36702764453,
	154587.04415795425,153547.30872924416,152519.00551095122,151501.98162425627,150496.08650423025,
	149501.17186255826,148517.0916508916,147543.70202480696,146580.86130833015,145628.42995907686,
	144686.27053392865,143754.24765529344,142832.22797792032,141920.08015625135,141017.6748122983,
	140124.8845040863,139241.58369456552,138367.64872108077,137502.957765297,136647.3908236697,
	135800.82967835522,134963.15786863616,134134.26066279024,133314.02503044173,132502.33961536066,
	131699.09470870707,130904.18222272348,130117.49566485971,129338.93011231908,128568.38218702741,
	127805.7500310283,127050.9332822558,126303.83305073668,125564.35189516666,124832.39379988218,
	124107.86415220772,123390.66972018275,122680.71863065264,121977.92034771877,121282.1856515521,
	120593.42661755302,119911.55659585273,119236.49019116355,118568.14324293952,117906.43280589703,
	117251.27713082643,116602.59564575077,115960.3089373578,115324.33873277946,114694.60788164292,
	114071.04033843159,113453.56114513565,112842.09641418314,112236.57331166542,111636.92004081995,
	111043.06582580511,110454.94089573683,109872.47646897749,109295.60473770087,108724.2588526991,
	108158.37290844992,107597.88192841683,107042.72185060587,106492.8295133507,105948.14264133631,
	105408.59983185194,104874.14054126297,104344.70507172283,103820.2345580818,103300.67095502997,
	102785.95702443678,102276.03632290973,101770.85318954589,101270.35273390102,100774.4808241362,
	100283.18407537004,99796.40983822619,99314.10618755674,98836.22191135927,98362.70649986668,
	97893.51013482468,97428.58367894265,96967.87866551112,96511.34728818826,96058.94239096664,
	95610.61745828617,95166.32660532025,94726.02456841157,94289.6666956746,93857.20893773476,
	93428.60783863586,93003.82052688453,92582.80470663817,92165.51864904817,91751.92118372524,
	91341.97169036469,90935.63009048469,90532.85683931653,90133.6129178172,89737.85982480881,
	89345.55956925395,88956.67466264615,88571.16811152581,88189.0034101259,87810.14453311614,
	87434.5559284852,87062.20251052103,86693.04965291492,86327.06318196817,85964.20936991257,
	85604.45492833627,85247.76700171454,84894.11316104159,84543.46139756967,84195.78011664364,
	83851.03813163431,83509.2046579693,83170.24930725669,82834.14208150675,82500.85336744106,
	82170.35393089318,81842.61491129546,81517.60781626051,81195.30451623938,80875.67723926656,
	80558.69856579692,80244.34142360842,79932.5790827976,79623.38515084673,79316.73356777293,
	79012.59860134887,78710.95484240456,78411.77720019584,78115.04089784782,77820.72146787457,
	77528.79474775947,77239.23687561166,76952.02428588571,76667.13370517227,76384.54214804934,
	76104.22691300079,75826.16557839824,75550.33599854192,75276.71629976606,75005.28487660467,
	74736.02038801402,74468.90175365226,74203.90815022246,73941.01900786371,73680.21400660239,
	73421.4730728579,73164.77637599954,72910.1043249584,72657.43756488747,72406.75697387714,
	72158.04365971679,71911.27895670752,71666.44442252339,71423.5218351178,71182.49318968036,
	70943.34069563748,70706.04677369568,70470.59405293722,70236.96536795059,70005.14375600887,
	69775.1124542899,69546.85489713683,69320.35471336085,69095.59572358358,68872.5619376186,
	68651.23755189338,68431.60694690897,68213.65468473434,67997.36550654449,67782.72433018599,
	67569.71624778892,67358.32652340308,67148.54059067828,66940.34405057262,66733.72266909824,
	66528.66237509526,66325.14925804446,66123.1695659065,65922.70970299626,65723.75622788566,
	65526.29585133896,65330.31543427373,65135.801985758,64942.742661031865,64751.12475955598,
	64560.93572309445,64372.16313381647,64184.79471243466,63998.81831636304,63814.221937902956,
	63630.99370245749,63449.121866768546,63268.59481717852,63089.40106791823,62911.52925942025,
	62734.9681566527,62559.706647477586,62385.733741035125,62213.03856614689,62041.610369743845,
	61871.438515312846,61702.51248137213,61534.821859959535,61368.35635514668,61203.10578157392,
	61039.06006300318,60876.20923089242,60714.54342299065,60554.05288195031,60394.72795395985,
	60236.559087396876,60079.536831496145,59923.65183503953,59768.89484506298,59615.256705579515,
	59462.728356322914,59311.30083150611,59160.96525859897,59011.71285712146,58863.534937452234,
	58716.42289966097,58570.368232344816,58425.362511492305,58281.39739935812,58138.464643353815,
	57996.556074955,57855.66360862489,57715.77924075169,57576.895048602615,57439.00318929255,
	57302.095898767446,57166.16549080448,57031.20435602651,56897.20496092917,56764.15984692855,
	56632.06162941758,56500.902996841745,56370.676709788895,56241.37560009212,56112.99256995255,
	55985.52059107245,55858.952703805655,55733.28201632581,55608.50170380684,55484.60500762299,
	55361.5852345607,55239.43575605253,55118.150007423574,54997.72148715645,54878.14375617515,
	54759.410437144754,54641.51521379185,54524.45183024122,54408.214090375324,54292.79585720978,
	54178.19105229405,54064.39365513115,53951.39770261793,53839.19728851167,53727.78656291792,
	53617.15973180525,53507.31105654222,53398.234853463604,53289.925493463976,53182.37740161902,
	53075.58505683773,52969.54299154441,52864.24579139491,52759.68809502604,52655.86459383879,
	52552.77003182001,52450.39920540151,52348.746963358855,52247.80820675106,52147.577888905485,
	52048.05101544252,51949.222644353205,51851.08788611907,51753.64190388498,51656.879913684184,
	51560.797184710194,51465.389039655565,51370.65085509724,51276.57806194272,51183.16614593845,
	51090.41064823769,50998.307166031074,50906.85135324244,50816.03892128695,50725.86563989855,
	50636.32733802197,50547.41990477069,50459.1392904547,50371.481507673016,50284.44263247315,
	50198.01880557796,50112.20623367117,50027.00119075349,49942.40001955151,49858.399132987026,
	49774.99501570026,49692.18422562261,49609.96339559185,49528.329235012745,49447.27853154285,
	49366.80815281252,49286.915048158284,49207.596250368086,49128.848877428,49050.670134256594,
	48973.05731442107,48896.00780181832,48819.51907231221,48743.58869530788,48668.21433525616,
	48593.393753064396,48519.124807405555,48445.40545590078,48372.23375616667,48299.60786670365,
	48227.52604760732,48155.98666109176,48084.98817179479,48014.52914685683,47944.60825575141,
	47875.22426984804,47806.3760616941,47738.062603995175,47670.28296828186,47603.03632324716,
	47536.32193274153,47470.13915341406,47404.4874319913,47339.366302185146,47274.77538122554,
	47210.71436601114,47147.18302888414,47084.18121302448,47021.70882747164,46959.76584178154,
	46898.352280327425,46837.46821626134,46777.11376514737,46717.28907829291,46657.99433579322,
	46599.22973931946,46540.99550467651,46483.29185415728,46426.11900873355,46369.4771801085,
	46313.366562675496,46257.78732541539,46202.73960377404,46148.223491561184,46094.23903290623,
	46040.786214317995,45987.864956883524,45935.475108649385,45883.61643722334,45832.288622636275,
	45781.49125049293,45731.223805459624,45681.485665108274,45632.27609415137,45583.59423909989,
	45535.43912335749,45487.80964278265,45440.70456173024,45394.122509590496,45348.06197783175,
	45302.521317562176,45257.49873760597,45212.992303104955,45168.99993462923,45125.51940780948,
	45082.548353464575,45040.0842582225,44998.124465624285,44956.66617767789,44915.70645686413,
	44875.2422285561,44835.2702838406,44795.78728271022,44756.789757605766,44718.27411727664,
	44680.23665094088,44642.67353270498,44605.580826225436,44568.95448958133,44532.790380323604,
	44497.08426068429,44461.8318029099,44427.028594695046,44392.6701446915,44358.75188806954,
	44325.26919210107,44292.217361755276,44259.59164526729,44227.38723967958,44195.599296322616,
	44164.22292622551,44133.253205438974,44102.68518025511,44072.51387231296,44042.73428357759,
	44013.34140118237,43984.330202123834,43955.695657809105,43927.43273843371,43899.536417205025,
	43872.00167438906,43844.823501189545,43817.996903448606,43791.516905177275,43765.37855190217,
	43739.57691384368,43714.107088916186,43688.96420555276,43664.14342536418,43639.63994562508,
	43615.44900159892,43591.56586869694,43567.9858644869,43544.7043505397,43521.71673413679,
	43499.01846982485,43476.60506084079,43454.47206039272,43432.615072821194,43411.02975463102,
	43389.71181540645,43368.65701861585,43347.8611823023,43327.32017967549,43307.029939607746,
	43286.986447032104,43267.18574325864,43247.62392619083,43228.29715050062,43209.201627687005,
	43190.33362609072,43171.68947083869,43153.2655437262,43135.05828304051,43117.06418333771,
	43099.27979516278,43081.70172473072,43064.32663356347,43047.15123808235,43030.17230917362,
	43013.386671718545,42996.79120408802,42980.382837616424,42964.15855605019,42948.11539496741,
	42932.25044119134,42916.56083216098,42901.04375533538,42885.69644750944,42870.516194185395,
	42855.50032890514,42840.64623257218,42825.95133277339,42811.41310309337,42797.02906242368,
	42782.796774268914,42768.713846051534,42754.77792841376,42740.986714521925,42727.33793937083,
	42713.8293790895,42700.45885024952,42687.224209176726,42674.123351267124,42661.15421030894,
	42648.31475780307,42635.60300229994,42623.016988732445,42610.55479776137,42598.21454512559,
	42585.99438099785,42573.892489351834,42561.90708733259,42550.036424640435,42538.27878291698,
	42526.63247514424,42515.095845046795,42503.667266511715,42492.34514300734,42481.12790701641,
	42470.01401947712,42459.00196923349,42448.09027249055,42437.277472289155,42426.56213797463,
	42415.94286468758,42405.41827285619,42394.98700770295,42384.64773874957,42374.39915934823,
	42364.2399862049,42354.168958918,42344.184839528665,42334.28641207523,42324.4724821576,
	42314.741876508415,42305.093442574995,42295.52604810924,42286.03858076396,42276.62994769635,
	42267.2990751814,42258.044908236894,42248.86641024098,42239.76256258099,42230.73236428597,
	42221.77483167899,42212.88899803903,42204.07391326247,42195.3286435311,42186.652270994375,
	42178.04389345335,42169.50262404997,42161.027590965045,42152.617937122326,42144.272819902755,
	42135.9914108499,42127.77289540414,42119.61647262284,42111.52135491248,42103.486767778275,
	42095.51194955253,42087.59615116342,42079.73863587093,42071.938679045896,42064.19556791472,
	42056.50860135278,42048.87708964243,42041.30035425747,42033.77772765133,42026.30855304304,
	42018.89218421068,42011.5279852943,42004.21533058675,41996.95360435411,41989.74220063723,
	41982.580523069635,41975.46798468841,41968.40400777004,41961.38802364888,41954.41947254233,
	41947.49780339016,41940.62247369534,41933.79294935125,41927.008704494096,41920.26922135174,
	41913.57399008647,41906.92250865438,41900.314282654166,41893.74882519662,41887.22565675622,
	41880.744305044245,41874.30430487057,41867.905198017776,41861.54653311462,41855.227865509405,
	41848.94875714383,41842.70877645647,41836.50749823083,41830.34450350687,41824.21937946286,
	41818.131719300975,41812.08112214404,41806.067192932984,41800.089542317415,41794.14778655678,
	41788.241547426784,41782.370452110976,41776.53413311959,41770.73222818891,41764.96438018561,
	41759.230237027456,41753.52945159077,41747.861681622366,41742.22658965865,41736.62384294427,
	41731.05311334994,41725.51407728974,41720.00641564776,41714.52981370479,41709.083961055345,
	41703.66855153996,41698.283283174496,41692.927858078045,41687.601982401095,41682.30536626583,
	41677.03772368975,41671.79877253144,41666.58823441826,41661.40583468888,41656.251302325996,
	41651.124369909485,41646.024773540455,41640.9522527932,41635.90655066214,41630.887413494056,
	41625.89459094445,41620.92783592076,41615.98690452912,41611.07155601906,41606.18155274196,
	41601.31666009423,41596.476646471434,41591.66128321781,41586.87034458859,41582.10360768809,
	41577.36085243779,41572.64186153251,41567.94642038219,41563.27431708642,41558.625342386935,
	41553.99928962055,41549.395954683416,41544.8151359974,41540.25663445883,41535.72025340684,
	41531.20579859229,41526.713078124536,41522.241902453985,41517.792084322646,41513.363438738,
	41508.95578293124,41504.568936328826,41500.20272052093,41495.85695922405,41491.531478248355,
	41487.22610547811,41482.94067082308,41478.675006198966,41474.42894550613,41470.2023245752,
	41465.99498116523,41461.80675491952,41457.63748734626,41453.48702178293,41449.35520337867,
	41445.241879055546,41441.14689750409,41437.07010913759,41433.01136606979,41428.97052210528,
	41424.9474326983,41420.941954938105,41416.95394752076,41412.98327073412,41409.029786427775,
	41405.09335799374,41401.17385034414,41397.271129891116,41393.38506452338,41389.515523591006,
	41385.662377877576,41381.82549958092,41378.00476230515,41374.20004102769,41370.41121208482,
	41366.63815315269,41362.88074323125,41359.13886262719,41355.41239293093,41351.70121699764,
	41348.0052189408,41344.32428410817,41340.65829905971,41337.00715156457,41333.37073056864,
	41329.74892619848,41326.141629724014,41322.54873356281,41318.97013124862,41315.40571742986,
	41311.85538784592,41308.31903931539,41304.79656972412,41301.287878009156,41297.79286414287,
	41294.31142912727,41290.84347497065,41287.3889046772,41283.947622244115,41280.51953263549,
	41277.104541772176,41273.7025565287,41270.313484712664,41266.937235051155,41263.573717190375,
	41260.22284166834,41256.88451991756,41253.55866424595,41250.24518782686,41246.94400469065,
	41243.65502971148,41240.37817860002,41237.11336788141,41233.8605149105,41230.61953783255,
	41227.39035558561,41224.172887902794,41220.96705528082,41217.772778985236,41214.58998103084,
	41211.41858419352,41208.25851196352,41205.109688579716,41201.97203899194,41198.84548885239,
	41195.729964525824,41192.62539306626,41189.53170221385,41186.448820385864,41183.37667666328,
	41180.31520079312,41177.264323173804,41174.22397485023,41171.19408749888,41168.174593435724,
	41165.16542558702,41162.16651750627,41159.17780334731,41156.199217866524,41153.23069641535,
	41150.27217493082,41147.32358993583,41144.38487851413,41141.455978317324,41138.53682758259,
	41135.62736507219,41132.727530107884,41129.83726254443,41126.95650278217,41124.08519174404,
	41121.22327087505,41118.370682146844,41115.52736802438,41112.693271499724,41109.86833604462,
	41107.05250564006,41104.24572474579,41101.44793831013,41098.659091753274,41095.87913097237,
	41093.10800233644,41090.34565266787,41087.592029246785,41084.84707981202,41082.11075253734,
	41079.38299605302,41076.66375941525,41073.95299211877,41071.25064408255,41068.55666565446,
	41065.871007587055,41063.19362106678,41060.5244576712,41057.86346939222,41055.21060862034,
	41052.56582814375,41049.929081143295,41047.300321184564,41044.67950222036,41042.06657857925,
	41039.461504972,41036.86423646906,41034.27472852763,41031.69293695174,41029.1188179089,
	41026.55232793724,41023.9934239064,41021.442063045506,41018.8982029353,41016.36180148358,
	41013.83281695025,41011.31120792158,41008.79693331747,41006.28995238847,41003.790224707685,
	41001.29771015857,40998.81236896248,40996.33416164653,40993.86304904377,40991.39899230304,
	40988.94195286809,40986.49189250426,40984.04877325775,40981.612557476794,40979.183207798334,
	40976.76068716491,40974.34495878342,40971.93598616345,40969.53373309142,40967.13816362405,
	40964.749242106845,40962.36693315068,40959.99120163408,40957.622012716754,40955.25933180626,
	40952.903124587974,40950.553356994045,40948.20999522839,40945.87300573529,40943.5423552272,
	40941.2180106486,40938.89993920747,40936.58810835088,40934.28248576538,40931.983039383995,
	40929.689737375826,40927.40254814356,40925.12144032474,40922.846382795215,40920.5773446474,
	40918.31429521014,40916.05720403458,40913.806040895426,40911.56077578935,40909.32137892485,
	40907.08782073388,40904.86007186415,40902.6381031698,40900.4218857187,40898.21139078748,
	40896.00658985955,40893.807454624184,40891.61395696192,40889.42606898019,40887.24376295636,
	40885.06701138231,40882.89578694256,40880.73006251668,40878.56981116303,40876.415006152194,
	40874.26562092492,40872.121629115136,40869.98300454459,40867.84972121625,40865.721753308826,
	40863.59907518688,40861.4816613982,40859.36948665663,40857.26252585809,40855.160754066914,
	40853.06414653023,40850.9726786536,40848.88632601776,40846.80506436718,40844.72886961239,
	40842.65771784123,40840.591585282404,40838.53044834519,40836.47428359458,40834.423067739146,
	40832.376777669706,40830.335390419124,40828.29888317016,40826.26723327447,40824.240418220346,
	40822.21841565492,40820.20120337847,40818.18875931991,40816.18106158165,40814.17808839532,
	40812.17981814232,40810.18622934494,40808.197300659194,40806.213010901876,40804.23333901177,
	40802.25826406912,40800.28776530065,40798.32182205698,40796.36041383017,40794.40352024129,
	40792.451121050195,40790.50319614438,40788.55972554215,40786.62068938862,40784.686067962895,
	40782.75584165783,40780.829991014136,40778.90849667688,40776.99133942664,40775.07850015869,
	40773.169959901425,40771.26569979329,40769.36570109402,40767.46994519157,40765.57841357699,
	40763.6910878709,40761.80794980286,40759.9289812235,40758.05416408637,40756.18348047329,
	40754.316912564704,40752.45444265573,40750.59605316361,40748.74172659666,40746.89144558225,
	40745.04519285447,40743.202951255036,40741.36470372615,40739.53043332465,40737.70012320068,
	40735.873756621775,40734.051316938225,40732.23278762395,40730.418152234626,40728.6073944409,
	40726.80049800575,40724.99744679334,40723.198224762236,40721.40281596813,40719.611204570734,
	40717.823374816704,40716.039311054235,40714.258997713136,40712.48241933117,40710.70956053323,
	40708.94040603901,40707.17494064375,40705.413149260086,40703.65501687214,40701.900528552556,
	40700.14966946228,40698.40242486708,40696.658780103615,40694.91872059068,40693.18223185075,
	40691.44929946859,40689.71990913784,40687.99404661997,40686.27169776265,40684.552848495325,
	40682.83748483547,40681.125592872566,40679.41715878442,40677.71216882225,40676.01060932912,
	40674.31246670972,40672.61772745394,40670.92637813755,40669.23840540685,40667.55379597365,
	40665.87253665314,40664.1946143063,40662.52001588601,40660.84872841859,40659.1807389944,
	40657.516034785964,40655.854603034415,40654.19643105803,40652.54150624166,40650.88981604003,
	40649.24134798222,40647.59608966199,40645.95402875249,40644.31515298751,40642.67945017084,
	40641.046908179786,40639.417514944544,40637.79125847929,40636.16812685733,40634.54810821245,
	40632.93119075417,40631.3173627564,40629.706612546994,40628.098928527856,40626.494299160695,
	40624.892712969406,40623.2941585511,40621.69862454439,40620.10609967258,40618.516572700646,
	40616.9300324709,40615.34646787971,40613.76586787599,40612.18822148659,40610.61351777399,
	40609.041745874536,40607.47289498974,40605.906954366656,40604.34391330748,40602.78376118155,
	40601.22648741521,40599.67208147665,40598.12053290838,40596.57183130251,40595.025966303336,
	40593.48292760928,40591.942704972185,40590.405288209025,40588.87066717677,40587.33883180314,
	40585.80977204501,40584.28347792209,40582.759939524425,40581.239146969834,40579.72109043795,
	40578.20576015884,40576.69314640814,40575.18323952007,40573.67602987968,40572.17150791392,
	40570.66966410531,40569.17048898097,40567.673973122786,40566.18010715877,40564.68888175758,
	40563.20028764643,40561.71431560053,40560.23095643701,40558.75020101241,40557.272040242526,
	40555.79646509461,40554.32346656218,40552.853035702545,40551.385163603794,40549.919841414245,
	40548.4570603068,40546.996811529054,40545.539086336044,40544.083876054756,40542.63117205139,
	40541.18096572602,40539.73324852311,40538.288011938435,40536.84524749989,40535.40494678792,
	40533.967101414215,40532.53170304716,40531.09874338331,40529.66821415412,40528.24010715905,
	40526.814414212226,40525.39112716868,40523.97023795038,40522.55173848736,40521.13562076829,
	40519.721876810516,40518.310498683764,40516.90147847381,40515.49480833626,40514.09048043482,
	40512.68848699228,40511.28882026223,40509.891472535026,40508.496436123496,40507.10370341707,
	40505.71326680243,40504.32511871892,40502.939251646494,40501.55565809374,40500.17433061142,
	40498.79526178116,40497.4184442164,40496.043870574336,40494.671533544344,40493.30142584811,
	40491.93354024329,40490.56786953513,40489.204406533696,40487.8431441023,40486.48407515041,
	40485.12719258932,40483.772489390365,40482.4199585474,40481.06959308014,40479.72138606434,
	40478.375330581555,40477.03141976261,40475.68964675964,40474.35000476995,40473.012487006854,
	40471.677086728174,40470.34379722128,40469.01261179835,40467.68352380732,40466.35652662045,
	40465.031613647676,40463.708778329135,40462.38801414674,40461.0693145784,40459.75267315617,
	40458.43808345218,40457.12553904182,40455.81503354937,40454.506560616115,40453.200113922045,
	40451.89568716818,40450.59327408658,40449.292868447366,40447.99446403146,40446.698054661654,
	40445.403634184724,40444.11119646524,40442.82073541962,40441.532244965696,40440.24571906417,
	40438.961151691896,40437.678536878055,40436.39786863464,40435.11914104232,40433.84234818631,
	40432.56748419346,40431.29454319534,40430.023519358394,40428.75440688912,40427.48720000713,
	40426.22189295062,40424.95848000114,40423.69695545099,40422.43731362336,40421.17954886773,
	40419.923655554165,40418.669628084775,40417.4174608737,40416.16714838029,40414.91868505689,
	40413.67206541437,40412.42728396519,40411.18433525441,40409.943213844934,40408.703914330705,
	40407.46643132879,40406.230759462305,40404.996893409654,40403.76482784543,40402.53455747378,
	40401.3060770305,40400.07938126421,40398.854464951495,40397.63132288443,40396.40994988588,
	40395.190340805464,40393.97249049146,40392.756393841824,40391.54204575435,40390.32944116654,
	40389.118575032124,40387.90944231387,40386.702038006246,40385.49635712746,40384.29239471589,
	40383.09014582116,40381.889605534925,40380.69076894192,40379.493631168596,40378.29818735424,
	40377.10443265111,40375.91236225229,40374.721971349085,40373.533255176764,40372.346208957715,
	40371.16082795876,40369.97710746421,40368.7950427768,40367.61462920898,40366.435862105216,
	40365.25873682167,40364.083248731244,40362.90939324552,40361.737165764855,40360.56656172732,
	40359.39757659696,40358.23020582813,40357.06444492806,40355.90028940296,40354.73773477722,
	40353.57677659173,40352.41741042689,40351.25963184555,40350.103436463774,40348.94881989631,
	40347.79577777987,40346.644305761474,40345.49439952006,40344.34605474042,40343.199267129436,
	40342.05403241864,40340.91034633823,40339.768204654065,40338.62760313432,40337.48853758259,
	40336.35100380974,40335.21499763218,40334.080514889145,40332.94755145721,40331.81610319605,
	40330.68616600725,40329.55773579623,40328.430808492645,40327.30538003204,40326.18144637878,
	40325.05900350025,40323.93804739388,40322.81857405566,40321.700579510616,40320.58405980605,
	40319.469010977526,40318.355429105075,40317.243310271384,40316.132650573025,40315.023446125444,
	40313.91569304857,40312.80938750281,40311.70452564195,40310.60110364216,40309.49911768831,
	40308.39856398857,40307.29943875405,40306.201738240525,40305.1054586774,40304.010596335436,
	40302.91714748943,40301.825108427714,40300.73447546607,40299.64524491888,40298.5574131286,
	40297.47097644159,40296.38593120843,40295.30227381826,40294.22000066025,40293.13910813757,
	40292.05959267029,40290.981450689,40289.90467864543,40288.829272989984,40287.75523019088,
	40286.68254675554,40285.611219162514,40284.54124393688,40283.47261760437,40282.40533669118,
	40281.33939776581,40280.27479738215,40279.21153212384,40278.14959857828,40277.088993360536,
	40276.02971308154,40274.97175436346,40273.91511384602,40272.859788194815,40271.80577407395,
	40270.75306817274,40269.70166716514,40268.651567760346,40267.60276667466,40266.55526064724,
	40265.5090464097,40264.46412072201,40263.42048033636,40262.378122042144,40261.337042629886,
	40260.297238885374,40259.25870763137,40258.221445698844,40257.18544990781,40256.15071712012,
	40255.117244184155,40254.08502798876,40253.054065389406,40252.024353304674,40250.995888619815,
	40249.968668263165,40248.94268916081,40247.91794825041,40246.89444248308,40245.872168810245,
	40244.85112422089,40243.831305682965,40242.81271020037,40241.79533476707,40240.779176409415,
	40239.764232154805,40238.750499030306,40237.737974084295,40236.72665438487,40235.71653699118,
	40234.70761899014,40233.699897469865,40232.6933695232,40231.68803227317,40230.68388283055,
	40229.680918326936,40228.67913591652,40227.67853273094,40226.67910596022,40225.6808527435,
	40224.68377028327,40223.68785576351,40222.69310638661,40221.699519367554,40220.70709193868,
	40219.715821302205,40218.725704728975,40217.73673946058,40216.748922743034,40215.762251869266,
	40214.77672410348,40213.7923367331,40212.80908707212,40211.826972420095,40210.8459900928,
	40209.86613741798,40208.88741173529,40207.909810382465,40206.93333072884,40205.95797011831,
	40204.98372594524,40204.01059556813,40203.03857639934,40202.06766583308,40201.097861281676,
	40200.12916014661,40199.16155987863,40198.19505790033,40197.229651658716,40196.265338604404,
	40195.30211619987,40194.33998193425,40193.37893325632,40192.41896767443,40191.46008268725,
	40190.50227579421,40189.54554450425,40188.589886346526,40187.63529885369,40186.68177956051,
	40185.72932600938,40184.777935772305,40183.82760639861,40182.8783354687,40181.9301205644,
	40180.98295926771,40180.03684917746,40179.09178790266,40178.14777305067,40177.20480225028,
	40176.262873127205,40175.32198331884,40174.38213046372,40173.44331222621,40172.50552626306,
	40171.56877023936,40170.63304183609,40169.69833872599,40168.764658617176,40167.831999205904,
	40166.90035819014,40165.96973328879,40165.04012222272,40164.11152273284,40163.183932539716,
	40162.257349401625,40161.331771063706,40160.40719529195,40159.48361985004,40158.56104251313,
	40157.63946105286,40156.7188732765,40155.799276970756,40154.880669942635,40153.96304999727,
	40153.04641495897,40152.13076264852,40151.21609090011,40150.302397545514,40149.38968044755,
	40148.477937450625,40147.56716640639,40146.657365197156,40145.74853169558,40144.840663772506,
	40143.93375932618,40143.02781623965,40142.12283242749,40141.21880578508,40140.31573423781,
	40139.413615711564,40138.51244811601,40137.612229405415,40136.71295751205,40135.81463038529,
	40134.917245984296,40134.02080225934,40133.12529720066,40132.23072875885,40131.33709492688,
	40130.444393695245,40129.55262305498,40128.661780999064,40127.7718655441,40126.88287469229,
	40125.99480647979,40125.10765891254,40124.22143003655,40123.33611788331,40122.45172049603,
	40121.568235935825,40120.68566224668,40119.803997494084,40118.92323975947,40118.04338709487,
	40117.164437602834,40116.28638935712,40115.40924045221,40114.53298898924,40113.65763307935,
	40112.78317083314,40111.909600347804,40111.03691976654,40110.16512720921,40109.29422081318,
	40108.42419871033,40107.55505906682,40106.686800019124,40105.81941972314,40104.952916340044,
	40104.087288048526,40103.22253301974,40102.35864942402,40101.49563546881,40100.633489322696,
	40099.77220919594,40098.91179328429,40098.05223979939,40097.193546957016,40096.33571296313,
	40095.478736064106,40094.62261446373,40093.767346420005,40092.91293015645,40092.05936393795,
	40091.20664599918,40090.354774599495,40089.50374800819,40088.65356448403,40087.80422231408,
	40086.955719753896,40086.108055098215,40085.26122663442,40084.415232666746,40083.570071478694,
	40082.72574137079,40081.88224067097,40081.0395676773,40080.197720719494,40079.356698109106,
	40078.516498184144,40077.677119279935,40076.83855972242,40076.000817876746,40075.163892071905,
	40074.327780673,40073.49248204736,40072.65799453525,40071.82431652354,40070.99144637626,
	40070.15938247669,40069.32812321049,40068.49766696119,40067.668012114984,40066.83915709451,
	40066.01110027875,40065.1838400711,40064.357374903375,40063.53170317358,40062.70682332178,
	40061.8827337566,40061.059432912385,40060.23691922505,40059.41519114778,40058.59424711187,
	40057.774085558536,40056.9547049502,40056.136103757985,40055.31828041548,40054.50123341581,
	40053.68496121632,40052.869462291215,40052.054735143465,40051.240778215266,40050.427590038234,
	40049.61516908623,40048.803513854225,40047.99262284541,40047.1824945825,40046.373127557206,
	40045.5645203032
	}}
};
