/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jkate;

import com.fluendo.jkate.Event;
import com.fluendo.jkate.KateSpaceMetric;
import com.fluendo.jkate.Region;
import com.fluendo.jkate.Style;
import com.fluendo.utils.Debug;
import java.awt.Dimension;

public final class Tracker {
    private Dimension window;
    private Dimension frame;
    public Event ev = null;
    public boolean[] has = new boolean[64];
    public static final int has_region = 0;
    public static final int has_text_alignment_int = 1;
    public static final int has_text_alignment_ext = 2;
    public float region_x;
    public float region_y;
    public float region_w;
    public float region_h;

    public Tracker(Event event) {
        this.ev = event;
    }

    public boolean update(double d, Dimension dimension, Dimension dimension2) {
        this.window = dimension;
        this.frame = dimension2;
        Region region = this.ev.kr;
        Style style = this.ev.ks;
        if (style == null && region != null && region.style >= 0) {
            style = this.ev.ki.styles[region.style];
        }
        int n = 0;
        while (n < this.has.length) {
            this.has[n] = false;
            ++n;
        }
        if (region != null) {
            if (region.metric == KateSpaceMetric.kate_metric_percentage) {
                this.region_x = (float)(region.x * dimension2.width) / 100.0f;
                this.region_y = (float)(region.y * dimension2.height) / 100.0f;
                this.region_w = (float)(region.w * dimension2.width) / 100.0f;
                this.region_h = (float)(region.h * dimension2.height) / 100.0f;
            } else if (region.metric == KateSpaceMetric.kate_metric_millionths) {
                this.region_x = (float)(region.x * dimension2.width) / 1000000.0f;
                this.region_y = (float)(region.y * dimension2.height) / 1000000.0f;
                this.region_w = (float)(region.w * dimension2.width) / 1000000.0f;
                this.region_h = (float)(region.h * dimension2.height) / 1000000.0f;
            } else if (region.metric == KateSpaceMetric.kate_metric_pixels) {
                this.region_x = region.x;
                this.region_y = region.y;
                this.region_w = region.w;
                this.region_h = region.h;
            } else {
                Debug.debug("Invalid metrics");
                return false;
            }
            this.has[0] = true;
        }
        return true;
    }
}

