/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapper;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.gradle.wrapper.IDownload;
import org.gradle.wrapper.Logger;

public class Download
implements IDownload {
    private static final int PROGRESS_CHUNK = 20000;
    private static final int BUFFER_SIZE = 10000;
    private final Logger logger;
    private final String appName;
    private final String appVersion;

    public Download(Logger logger, String appName, String appVersion) {
        this.logger = logger;
        this.appName = appName;
        this.appVersion = appVersion;
        this.configureProxyAuthentication();
    }

    private void configureProxyAuthentication() {
        if (System.getProperty("http.proxyUser") != null) {
            Authenticator.setDefault(new ProxyAuthenticator());
        }
    }

    public void download(URI address, File destination) throws Exception {
        destination.getParentFile().mkdirs();
        this.downloadInternal(address, destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadInternal(URI address, File destination) throws Exception {
        BufferedOutputStream out = null;
        InputStream in = null;
        try {
            int numRead;
            URL url = Download.safeUri(address).toURL();
            out = new BufferedOutputStream(new FileOutputStream(destination));
            URLConnection conn = url.openConnection();
            this.addBasicAuthentication(address, conn);
            String userAgentValue = this.calculateUserAgent();
            conn.setRequestProperty("User-Agent", userAgentValue);
            in = conn.getInputStream();
            byte[] buffer = new byte[10000];
            long progressCounter = 0L;
            while ((numRead = in.read(buffer)) != -1) {
                if (Thread.currentThread().isInterrupted()) {
                    System.out.print("interrupted");
                    throw new IOException("Download was interrupted.");
                }
                if ((progressCounter += (long)numRead) / 20000L > 0L) {
                    this.logger.append(".");
                    progressCounter -= 20000L;
                }
                ((OutputStream)out).write(buffer, 0, numRead);
            }
        }
        finally {
            this.logger.log("");
            if (in != null) {
                in.close();
            }
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }

    static URI safeUri(URI uri) throws URISyntaxException {
        return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
    }

    private void addBasicAuthentication(URI address, URLConnection connection) throws IOException {
        String userInfo = this.calculateUserInfo(address);
        if (userInfo == null) {
            return;
        }
        if (!"https".equals(address.getScheme())) {
            this.logger.log("WARNING Using HTTP Basic Authentication over an insecure connection to download the Gradle distribution. Please consider using HTTPS.");
        }
        connection.setRequestProperty("Authorization", "Basic " + this.base64Encode(userInfo));
    }

    private String base64Encode(String userInfo) {
        ClassLoader loader = this.getClass().getClassLoader();
        try {
            Method getEncoderMethod = loader.loadClass("java.util.Base64").getMethod("getEncoder", new Class[0]);
            Method encodeMethod = loader.loadClass("java.util.Base64$Encoder").getMethod("encodeToString", byte[].class);
            Object encoder = getEncoderMethod.invoke(null, new Object[0]);
            return (String)encodeMethod.invoke(encoder, new Object[]{userInfo.getBytes("UTF-8")});
        }
        catch (Exception java7OrEarlier) {
            try {
                Method encodeMethod = loader.loadClass("javax.xml.bind.DatatypeConverter").getMethod("printBase64Binary", byte[].class);
                return (String)encodeMethod.invoke(null, new Object[]{userInfo.getBytes("UTF-8")});
            }
            catch (Exception java5OrEarlier) {
                throw new RuntimeException("Downloading Gradle distributions with HTTP Basic Authentication is not supported on your JVM.", java5OrEarlier);
            }
        }
    }

    private String calculateUserInfo(URI uri) {
        String username = System.getProperty("gradle.wrapperUser");
        String password = System.getProperty("gradle.wrapperPassword");
        if (username != null && password != null) {
            return username + ':' + password;
        }
        return uri.getUserInfo();
    }

    private String calculateUserAgent() {
        String javaVendor = System.getProperty("java.vendor");
        String javaVersion = System.getProperty("java.version");
        String javaVendorVersion = System.getProperty("java.vm.version");
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        return String.format("%s/%s (%s;%s;%s) (%s;%s;%s)", this.appName, this.appVersion, osName, osVersion, osArch, javaVendor, javaVersion, javaVendorVersion);
    }

    private static class ProxyAuthenticator
    extends Authenticator {
        private ProxyAuthenticator() {
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(System.getProperty("http.proxyUser"), System.getProperty("http.proxyPassword", "").toCharArray());
        }
    }
}

