(function() {
  var escope, expect, harmony;

  expect = require('chai').expect;

  harmony = require('../third_party/esprima');

  escope = require('..');

  describe('import declaration', function() {
    it('should import names from source', function() {
      var ast, globalScope, scope, scopeManager;
      ast = harmony.parse("import v from \"mod\";", {
        sourceType: 'module'
      });
      scopeManager = escope.analyze(ast, {
        ecmaVersion: 6,
        sourceType: 'module'
      });
      expect(scopeManager.scopes).to.have.length(2);
      globalScope = scopeManager.scopes[0];
      expect(globalScope.type).to.be.equal('global');
      expect(globalScope.variables).to.have.length(0);
      expect(globalScope.references).to.have.length(0);
      scope = scopeManager.scopes[1];
      expect(scope.type).to.be.equal('module');
      expect(scope.isStrict).to.be["true"];
      expect(scope.variables).to.have.length(1);
      expect(scope.variables[0].name).to.be.equal('v');
      expect(scope.variables[0].defs[0].type).to.be.equal('ImportBinding');
      return expect(scope.references).to.have.length(0);
    });
    it('should import namespaces', function() {
      var ast, globalScope, scope, scopeManager;
      ast = harmony.parse("import * as ns from \"mod\";", {
        sourceType: 'module'
      });
      scopeManager = escope.analyze(ast, {
        ecmaVersion: 6,
        sourceType: 'module'
      });
      expect(scopeManager.scopes).to.have.length(2);
      globalScope = scopeManager.scopes[0];
      expect(globalScope.type).to.be.equal('global');
      expect(globalScope.variables).to.have.length(0);
      expect(globalScope.references).to.have.length(0);
      scope = scopeManager.scopes[1];
      expect(scope.type).to.be.equal('module');
      expect(scope.isStrict).to.be["true"];
      expect(scope.variables).to.have.length(1);
      expect(scope.variables[0].name).to.be.equal('ns');
      expect(scope.variables[0].defs[0].type).to.be.equal('ImportBinding');
      return expect(scope.references).to.have.length(0);
    });
    it('should import insided names#1', function() {
      var ast, globalScope, scope, scopeManager;
      ast = harmony.parse("import {x} from \"mod\";", {
        sourceType: 'module'
      });
      scopeManager = escope.analyze(ast, {
        ecmaVersion: 6,
        sourceType: 'module'
      });
      expect(scopeManager.scopes).to.have.length(2);
      globalScope = scopeManager.scopes[0];
      expect(globalScope.type).to.be.equal('global');
      expect(globalScope.variables).to.have.length(0);
      expect(globalScope.references).to.have.length(0);
      scope = scopeManager.scopes[1];
      expect(scope.type).to.be.equal('module');
      expect(scope.isStrict).to.be["true"];
      expect(scope.variables).to.have.length(1);
      expect(scope.variables[0].name).to.be.equal('x');
      expect(scope.variables[0].defs[0].type).to.be.equal('ImportBinding');
      return expect(scope.references).to.have.length(0);
    });
    return it('should import insided names#2', function() {
      var ast, globalScope, scope, scopeManager;
      ast = harmony.parse("import {x as v} from \"mod\";", {
        sourceType: 'module'
      });
      scopeManager = escope.analyze(ast, {
        ecmaVersion: 6,
        sourceType: 'module'
      });
      expect(scopeManager.scopes).to.have.length(2);
      globalScope = scopeManager.scopes[0];
      expect(globalScope.type).to.be.equal('global');
      expect(globalScope.variables).to.have.length(0);
      expect(globalScope.references).to.have.length(0);
      scope = scopeManager.scopes[1];
      expect(scope.type).to.be.equal('module');
      expect(scope.isStrict).to.be["true"];
      expect(scope.variables).to.have.length(1);
      expect(scope.variables[0].name).to.be.equal('v');
      expect(scope.variables[0].defs[0].type).to.be.equal('ImportBinding');
      return expect(scope.references).to.have.length(0);
    });
  });

}).call(this);

//# sourceMappingURL=data:application/json;base64,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