/*
 *	Copyright (c) 2024 Fujitsu Limited. All rights reserved.
 */

/*
 *	Fujitsu FUJITSU-MONAKA processor
 *
 *	FUJITSU-MONAKA Specification
 *	Fujitsu Limited
 *	1.0, 30 September 2024
 */

static const arm_entry_t arm_monaka_pe[ ] = {
	{
		.name = "SW_INCR",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0000,
		.desc = "This event counts on writes to the PMSWINC register.",
	},
	{
		.name = "L1I_CACHE_REFILL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0001,
		.desc = "This event counts operations that cause a refill of the L1I cache. See L1I_CACHE_REFILL of ARMv9 Reference Manual for more information.",
	},
	{
		.name = "L1I_TLB_REFILL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0002,
		.desc = "This event counts operations that cause a TLB refill of the L1I TLB. See L1I_TLB_REFILL of ARMv9 Reference Manual for more information.",
	},
	{
		.name = "L1D_CACHE_REFILL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0003,
		.desc = "This event counts operations that cause a refill of the L1D cache. See L1D_CACHE_REFILL of ARMv9 Reference Manual for more information.",
	},
	{
		.name = "L1D_CACHE",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0004,
		.desc = "This event counts operations that cause a cache access to the L1D cache. See L1D_CACHE of ARMv9 Reference Manual for more information.",
	},
	{
		.name = "L1D_TLB_REFILL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0005,
		.desc = "This event counts operations that cause a TLB refill of the L1D TLB. See L1D_TLB_REFILL of ARMv9 Reference Manual for more information.",
	},
	{
		.name = "INST_RETIRED",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0008,
		.desc = "This event counts every architecturally executed instruction.",
	},
	{
		.name = "EXC_TAKEN",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0009,
		.desc = "This event counts each exception taken.",
	},
	{
		.name = "EXC_RETURN",
		.modmsk = ARMV9_ATTRS,
		.code = 0x000a,
		.desc = "This event counts each executed exception return instruction.",
	},
	{
		.name = "CID_WRITE_RETIRED",
		.modmsk = ARMV9_ATTRS,
		.code = 0x000b,
		.desc = "This event counts every write to CONTEXTIDR.",
	},
	{
		.name = "BR_MIS_PRED",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0010,
		.desc = "This event counts each correction to the predicted program flow that occurs because of a misprediction from, or no prediction from, the branch prediction resources and that relates to instructions that the branch prediction resources are capable of predicting.",
	},
	{
		.name = "CPU_CYCLES",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0011,
		.desc = "This event counts every cycle.",
	},
	{
		.name = "BR_PRED",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0012,
		.desc = "This event counts every branch or other change in the program flow that the branch prediction resources are capable of predicting.",
	},
	{
		.name = "MEM_ACCESS",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0013,
		.desc = "This event counts architecturally executed memory-reading instructions and memory-writing instructions, as defined by the LDST_SPEC events.",
	},
	{
		.name = "L1I_CACHE",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0014,
		.desc = "This event counts operations that cause a cache access to the L1I cache. See L1I_CACHE of ARMv9 Reference Manual for more information.",
	},
	{
		.name = "L1D_CACHE_WB",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0015,
		.desc = "This event counts every write-back of data from the L1D cache. See L1D_CACHE_WB of ARMv9 Reference Manual for more information.",
	},
	{
		.name = "L2D_CACHE",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0016,
		.desc = "This event counts operations that cause a cache access to the L2 cache. See L2D_CACHE of ARMv9 Reference Manual for more information.",
	},
	{
		.name = "L2D_CACHE_REFILL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0017,
		.desc = "This event counts operations that cause a refill of the L2 cache. See L2D_CACHE_REFILL of ARMv9 Reference Manual for more information.",
	},
	{
		.name = "L2D_CACHE_WB",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0018,
		.desc = "This event counts every write-back of data from the L2 cache caused by L2 replace, non-temporal-store and DC ZVA.",
	},
	{
		.name = "INST_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x001b,
		.desc = "This event counts every architecturally executed instruction.",
	},
	{
		.name = "BR_RETIRED",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0021,
		.desc = "This event counts architecturally executed branch instruction.",
	},
	{
		.name = "BR_MIS_PRED_RETIRED",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0022,
		.desc = "This event counts architecturally executed branch instruction which was mispredicted.",
	},
	{
		.name = "STALL_FRONTEND",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0023,
		.desc = "This event counts every cycle counted by the CPU_CYCLES event on that no operation was issued because there are no operations available to issue for this PE from the frontend.",
	},
	{
		.name = "STALL_BACKEND",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0024,
		.desc = "This event counts every cycle counted by the CPU_CYCLES event on that no operation was issued because the backend is unable to accept any operation.",
	},
	{
		.name = "L1D_TLB",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0025,
		.desc = "This event counts operations that cause a TLB access to the L1D TLB. See L1D_TLB of ARMv9 Reference Manual for more information.",
	},
	{
		.name = "L1I_TLB",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0026,
		.desc = "This event counts operations that cause a TLB access to the L1I TLB. See L1I_TLB of ARMv9 Reference Manual for more information.",
	},
	{
		.name = "L3D_CACHE",
		.modmsk = ARMV9_ATTRS,
		.code = 0x002b,
		.desc = "This event counts operations that cause a cache access to the L3 cache, as defined by the sum of L2D_CACHE_REFILL_L3D_CACHE and L2D_CACHE_WB_VICTIM_CLEAN events.",
	},
	{
		.name = "L2D_TLB_REFILL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x002d,
		.desc = "This event counts operations that cause a TLB refill of the L2D TLB. See L2D_TLB_REFILL of ARMv9 Reference Manual for more information.",
	},
	{
		.name = "L2I_TLB_REFILL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x002e,
		.desc = "This event counts operations that cause a TLB refill of the L2I TLB. See L2I_TLB_REFILL of ARMv9 Reference Manual for more information.",
	},
	{
		.name = "L2D_TLB",
		.modmsk = ARMV9_ATTRS,
		.code = 0x002f,
		.desc = "This event counts operations that cause a TLB access to the L2D TLB. See L2D_TLB of ARMv9 Reference Manual for more information.",
	},
	{
		.name = "L2I_TLB",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0030,
		.desc = "This event counts operations that cause a TLB access to the L2I TLB. See L2I_TLB of ARMv9 Reference Manual for more information.",
	},
	{
		.name = "DTLB_WALK",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0034,
		.desc = "This event counts data TLB access with at least one translation table walk.",
	},
	{
		.name = "ITLB_WALK",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0035,
		.desc = "This event counts instruction TLB access with at least one translation table walk.",
	},
	{
		.name = "LL_CACHE_RD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0036,
		.desc = "This event counts access counted by L3D_CACHE that is a Memory-read operation, as defined by the L2D_CACHE_REFILL_L3D_CACHE events.",
	},
	{
		.name = "LL_CACHE_MISS_RD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0037,
		.desc = "This event counts access counted by L3D_CACHE that is not completed by the L3 cache, and a Memory-read operation, as defined by the L2D_CACHE_REFILL_L3D_MISS events. Note: This event may count inaccurately.",
	},
	{
		.name = "L1D_CACHE_LMISS_RD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0039,
		.desc = "This event counts operations that cause a refill of the L1D cache that incurs additional latency.",
	},
	{
		.name = "OP_RETIRED",
		.modmsk = ARMV9_ATTRS,
		.code = 0x003a,
		.desc = "This event counts every architecturally executed micro-operation.",
	},
	{
		.name = "OP_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x003b,
		.desc = "This event counts every speculatively executed micro-operation.",
	},
	{
		.name = "STALL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x003c,
		.desc = "This event counts every cycle that no instruction was dispatched from decode unit.",
	},
	{
		.name = "STALL_SLOT_BACKEND",
		.modmsk = ARMV9_ATTRS,
		.code = 0x003d,
		.desc = "This event counts every cycle that no instruction was dispatched from decode unit due to the backend.",
	},
	{
		.name = "STALL_SLOT_FRONTEND",
		.modmsk = ARMV9_ATTRS,
		.code = 0x003e,
		.desc = "This event counts every cycle that no instruction was dispatched from decode unit due to the frontend.",
	},
	{
		.name = "STALL_SLOT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x003f,
		.desc = "This event counts every cycle that no instruction or operation Slot was dispatched from decode unit.",
	},
	{
		.name = "L1D_CACHE_RD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0040,
		.desc = "This event counts L1D CACHE caused by read access.",
	},
	{
		.name = "L1D_CACHE_WR",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0041,
		.desc = "This event counts L1D CACHE caused by write access.",
	},
	{
		.name = "L1D_CACHE_REFILL_RD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0042,
		.desc = "This event counts L1D_CACHE_REFILL caused by read access.",
	},
	{
		.name = "L1D_CACHE_REFILL_WR",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0043,
		.desc = "This event counts L1D_CACHE_REFILL caused by write access.",
	},
	{
		.name = "L2D_CACHE_RD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0050,
		.desc = "This event counts L2D_CACHE caused by read access.",
	},
	{
		.name = "L2D_CACHE_WR",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0051,
		.desc = "This event counts L2D_CACHE caused by write access.",
	},
	{
		.name = "L2D_CACHE_REFILL_RD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0052,
		.desc = "This event counts L2D_CACHE_REFILL caused by read access.",
	},
	{
		.name = "L2D_CACHE_REFILL_WR",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0053,
		.desc = "This event counts L2D_CACHE_REFILL caused by write access.",
	},
	{
		.name = "L2D_CACHE_WB_VICTIM",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0056,
		.desc = "This event counts every write-back of data from the L2 cache caused by L2 replace.",
	},
	{
		.name = "MEM_ACCESS_RD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0066,
		.desc = "This event counts architecturally executed memory-reading instructions, as defined by the LD_SPEC events.",
	},
	{
		.name = "LDREX_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x006c,
		.desc = "This event counts architecturally executed load-exclusive instructions.",
	},
	{
		.name = "STREX_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x006f,
		.desc = "This event counts architecturally executed store-exclusive instructions.",
	},
	{
		.name = "LD_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0070,
		.desc = "This event counts architecturally executed memory-reading instructions, as defined by the LD_RETIRED event.",
	},
	{
		.name = "ST_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0071,
		.desc = "This event counts architecturally executed memory-writing instructions, as defined by the ST_RETIRED event. This event counts DCZVA as a store operation.",
	},
	{
		.name = "LDST_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0072,
		.desc = "This event counts architecturally executed memory-reading instructions and memory-writing instructions, as defined by the LD_RETIRED and ST_RETIRED events.",
	},
	{
		.name = "DP_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0073,
		.desc = "This event counts architecturally executed integer data-processing instructions. See DP_SPEC of ARMv9 Reference Manual for more information.",
	},
	{
		.name = "ASE_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0074,
		.desc = "This event counts architecturally executed Advanced SIMD data-processing instructions.",
	},
	{
		.name = "VFP_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0075,
		.desc = "This event counts architecturally executed floating-point data-processing instructions.",
	},
	{
		.name = "PC_WRITE_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0076,
		.desc = "This event counts only software changes of the PC that defined by the instruction architecturally executed, condition code check pass, software change of the PC event.",
	},
	{
		.name = "CRYPTO_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0077,
		.desc = "This event counts architecturally executed cryptographic instructions, except PMULL and VMULL.",
	},
	{
		.name = "BR_IMMED_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0078,
		.desc = "This event counts architecturally executed immediate branch instructions.",
	},
	{
		.name = "BR_RETURN_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0079,
		.desc = "This event counts architecturally executed procedure return operations that defined by the BR_RETURN_RETIRED event.",
	},
	{
		.name = "BR_INDIRECT_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x007a,
		.desc = "This event counts architecturally executed indirect branch instructions that includes software change of the PC other than exception-generating instructions and immediate branch instructions.",
	},
	{
		.name = "ISB_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x007c,
		.desc = "This event counts architecturally executed Instruction Synchronization Barrier instructions.",
	},
	{
		.name = "DSB_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x007d,
		.desc = "This event counts architecturally executed Data Synchronization Barrier instructions.",
	},
	{
		.name = "DMB_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x007e,
		.desc = "This event counts architecturally executed Data Memory Barrier instructions, excluding the implied barrier operations of load/store operations with release consistency semantics.",
	},
	{
		.name = "CSDB_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x007f,
		.desc = "This event counts architecturally executed control speculation barrier instructions.",
	},
	{
		.name = "EXC_UNDEF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0081,
		.desc = "This event counts only other synchronous exceptions that are taken locally.",
	},
	{
		.name = "EXC_SVC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0082,
		.desc = "This event counts only Supervisor Call exceptions that are taken locally.",
	},
	{
		.name = "EXC_PABORT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0083,
		.desc = "This event counts only Instruction Abort exceptions that are taken locally.",
	},
	{
		.name = "EXC_DABORT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0084,
		.desc = "This event counts only Data Abort or SError interrupt exceptions that are taken locally.",
	},
	{
		.name = "EXC_IRQ",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0086,
		.desc = "This event counts only IRQ exceptions that are taken locally, including Virtual IRQ exceptions.",
	},
	{
		.name = "EXC_FIQ",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0087,
		.desc = "This event counts only FIQ exceptions that are taken locally, including Virtual FIQ exceptions.",
	},
	{
		.name = "EXC_SMC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0088,
		.desc = "This event counts only Secure Monitor Call exceptions. This event does not increment on SMC instructions trapped as a Hyp Trap exception.",
	},
	{
		.name = "EXC_HVC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x008a,
		.desc = "This event counts for both Hypervisor Call exceptions taken locally in the hypervisor and those taken as an exception from Non-secure EL1.",
	},
	{
		.name = "L3D_CACHE_RD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x00a0,
		.desc = "This event counts access counted by L3D_CACHE that is a Memory-read operation, as defined by the L2D_CACHE_REFILL_L3D_CACHE events.",
	},
	{
		.name = "FP_MV_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0105,
		.desc = "This event counts architecturally executed floating-point move operation.",
	},
	{
		.name = "PRD_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0108,
		.desc = "This event counts architecturally executed operations that using predicate register.",
	},
	{
		.name = "IEL_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0109,
		.desc = "This event counts architecturally executed inter-element manipulation operation.",
	},
	{
		.name = "IREG_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x010a,
		.desc = "This event counts architecturally executed inter-register manipulation operation.",
	},
	{
		.name = "FP_LD_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0112,
		.desc = "This event counts architecturally executed NOSIMD load operations that using SIMD&FP registers.",
	},
	{
		.name = "FP_ST_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0113,
		.desc = "This event counts architecturally executed NOSIMD store operations that using SIMD&FP registers.",
	},
	{
		.name = "BC_LD_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x011a,
		.desc = "This event counts architecturally executed SIMD broadcast floating-point load operation.",
	},
	{
		.name = "DCZVA_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x011b,
		.desc = "This event counts architecturally executed zero blocking operations due to the DC ZVA instruction.",
	},
	{
		.name = "EFFECTIVE_INST_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0121,
		.desc = "This event counts architecturally executed instructions, excluding the MOVPRFX instruction.",
	},
	{
		.name = "PRE_INDEX_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0123,
		.desc = "This event counts architecturally executed operations that uses pre-index as its addressing mode.",
	},
	{
		.name = "POST_INDEX_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0124,
		.desc = "This event counts architecturally executed operations that uses post-index as its addressing mode.",
	},
	{
		.name = "UOP_SPLIT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0139,
		.desc = "This event counts the occurrence count of the micro-operation split.",
	},
	{
		.name = "LD_COMP_WAIT_L1_MISS",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0182,
		.desc = "This event counts every cycle that no instruction was committed because the oldest and uncommitted load/store/prefetch operation waits for L2 cache access.",
	},
	{
		.name = "LD_COMP_WAIT_L1_MISS_EX",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0183,
		.desc = "This event counts every cycle that no instruction was committed because the oldest and uncommitted integer load operation waits for L2 cache access.",
	},
	{
		.name = "LD_COMP_WAIT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0184,
		.desc = "This event counts every cycle that no instruction was committed because the oldest and uncommitted load/store/prefetch operation waits for L1D cache, L2 cache, L3 cache and memory access.",
	},
	{
		.name = "LD_COMP_WAIT_EX",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0185,
		.desc = "This event counts every cycle that no instruction was committed because the oldest and uncommitted integer load operation waits for L1D cache, L2 cache, L3 cache and memory access.",
	},
	{
		.name = "LD_COMP_WAIT_PFP_BUSY",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0186,
		.desc = "This event counts every cycle that no instruction was committed due to the lack of an available prefetch port.",
	},
	{
		.name = "LD_COMP_WAIT_PFP_BUSY_EX",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0187,
		.desc = "This event counts the LD_COMP_WAIT_PFP_BUSY caused by an integer load operation.",
	},
	{
		.name = "LD_COMP_WAIT_PFP_BUSY_SWPF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0188,
		.desc = "This event counts the LD_COMP_WAIT_PFP_BUSY caused by a software prefetch instruction.",
	},
	{
		.name = "EU_COMP_WAIT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0189,
		.desc = "This event counts every cycle that no instruction was committed and the oldest and uncommitted instruction is an integer or floating-point/SIMD instruction. ",
	},
	{
		.name = "FL_COMP_WAIT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x018a,
		.desc = "This event counts every cycle that no instruction was committed and the oldest and uncommitted instruction is a floating-point/SIMD instruction.",
	},
	{
		.name = "BR_COMP_WAIT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x018b,
		.desc = "This event counts every cycle that no instruction was committed and the oldest and uncommitted instruction is a branch instruction.",
	},
	{
		.name = "ROB_EMPTY",
		.modmsk = ARMV9_ATTRS,
		.code = 0x018c,
		.desc = "This event counts every cycle that no instruction was committed because the CSE is empty.",
	},
	{
		.name = "ROB_EMPTY_STQ_BUSY",
		.modmsk = ARMV9_ATTRS,
		.code = 0x018d,
		.desc = "This event counts every cycle that no instruction was committed because the CSE is empty and the store port (SP) is full.",
	},
	{
		.name = "WFE_WFI_CYCLE",
		.modmsk = ARMV9_ATTRS,
		.code = 0x018e,
		.desc = "This event counts every cycle that the instruction unit is halted by the WFE/WFI instruction.",
	},
	{
		.name = "RETENTION_CYCLE",
		.modmsk = ARMV9_ATTRS,
		.code = 0x018f,
		.desc = "This event counts every cycle that the instruction unit is halted by the RETENTION state.",
	},
	{
		.name = "_0INST_COMMIT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0190,
		.desc = "This event counts every cycle that no instruction was committed, but counts at the time when commits MOVPRFX only. ",
	},
	{
		.name = "_1INST_COMMIT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0191,
		.desc = "This event counts every cycle that one instruction is committed.",
	},
	{
		.name = "_2INST_COMMIT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0192,
		.desc = "This event counts every cycle that two instructions are committed.",
	},
	{
		.name = "_3INST_COMMIT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0193,
		.desc = "This event counts every cycle that three instructions are committed.",
	},
	{
		.name = "_4INST_COMMIT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0194,
		.desc = "This event counts every cycle that four instructions are committed.",
	},
	{
		.name = "_5INST_COMMIT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0195,
		.desc = "This event counts every cycle that five instructions are committed.",
	},
	{
		.name = "UOP_ONLY_COMMIT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0198,
		.desc = "This event counts every cycle that only any micro-operations are committed.",
	},
	{
		.name = "SINGLE_MOVPRFX_COMMIT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0199,
		.desc = "This event counts every cycle that only the MOVPRFX instruction is committed.",
	},
	{
		.name = "LD_COMP_WAIT_L2_MISS",
		.modmsk = ARMV9_ATTRS,
		.code = 0x019c,
		.desc = "This event counts every cycle that no instruction was committed because the oldest and uncommitted load/store/prefetch operation waits for L2 cache miss.",
	},
	{
		.name = "LD_COMP_WAIT_L2_MISS_EX",
		.modmsk = ARMV9_ATTRS,
		.code = 0x019d,
		.desc = "This event counts every cycle that no instruction was committed because the oldest and uncommitted integer load operation waits for L2 cache miss.",
	},
	{
		.name = "EAGA_VAL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x01a0,
		.desc = "This event counts valid cycles of EAGA pipeline.",
	},
	{
		.name = "EAGB_VAL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x01a1,
		.desc = "This event counts valid cycles of EAGB pipeline.",
	},
	{
		.name = "PRX_VAL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x01a3,
		.desc = "This event counts valid cycles of PRX pipeline.",
	},
	{
		.name = "EXA_VAL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x01a4,
		.desc = "This event counts valid cycles of EXA pipeline.",
	},
	{
		.name = "EXB_VAL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x01a5,
		.desc = "This event counts valid cycles of EXB pipeline.",
	},
	{
		.name = "EXC_VAL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x01a6,
		.desc = "This event counts valid cycles of EXC pipeline.",
	},
	{
		.name = "EXD_VAL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x01a7,
		.desc = "This event counts valid cycles of EXD pipeline.",
	},
	{
		.name = "FLA_VAL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x01a8,
		.desc = "This event counts valid cycles of FLA pipeline.",
	},
	{
		.name = "FLB_VAL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x01a9,
		.desc = "This event counts valid cycles of FLB pipeline.",
	},
	{
		.name = "STEA_VAL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x01aa,
		.desc = "This event counts valid cycles of STEA pipeline.",
	},
	{
		.name = "STEB_VAL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x01ab,
		.desc = "This event counts valid cycles of STEB pipeline.",
	},
	{
		.name = "STFL_VAL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x01ac,
		.desc = "This event counts valid cycles of STFL pipeline.",
	},
	{
		.name = "STPX_VAL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x01ad,
		.desc = "This event counts valid cycles of STPX pipeline.",
	},
	{
		.name = "FLA_VAL_PRD_CNT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x01b0,
		.desc = "This event counts the number of 1's in the predicate bits of request in FLA pipeline, where it is corrected so that it becomes 32 when all bits are 1.",
	},
	{
		.name = "FLB_VAL_PRD_CNT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x01b1,
		.desc = "This event counts the number of 1's in the predicate bits of request in FLB pipeline, where it is corrected so that it becomes 32 when all bits are 1.",
	},
	{
		.name = "FLA_VAL_FOR_PRD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x01b2,
		.desc = "This event counts valid cycles of FLA pipeline.",
	},
	{
		.name = "FLB_VAL_FOR_PRD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x01b3,
		.desc = "This event counts valid cycles of FLB pipeline.",
	},
	{
		.name = "EA_CORE",
		.modmsk = ARMV9_ATTRS,
		.code = 0x01f0,
		.desc = "This event counts energy consumption of core.",
	},
	{
		.name = "L1D_CACHE_DM",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0200,
		.desc = "This event counts L1D_CACHE caused by demand access.",
	},
	{
		.name = "L1D_CACHE_DM_RD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0201,
		.desc = "This event counts L1D_CACHE caused by demand read access.",
	},
	{
		.name = "L1D_CACHE_DM_WR",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0202,
		.desc = "This event counts L1D_CACHE caused by demand write access.",
	},
	{
		.name = "L1I_CACHE_DM_RD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0207,
		.desc = "This event counts L1I_CACHE caused by demand read access.",
	},
	{
		.name = "L1D_CACHE_REFILL_DM",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0208,
		.desc = "This event counts L1D_CACHE_REFILL caused by demand access.",
	},
	{
		.name = "L1D_CACHE_REFILL_DM_RD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0209,
		.desc = "This event counts L1D_CACHE_REFILL caused by demand read access.",
	},
	{
		.name = "L1D_CACHE_REFILL_DM_WR",
		.modmsk = ARMV9_ATTRS,
		.code = 0x020a,
		.desc = "This event counts L1D_CACHE_REFILL caused by demand write access.",
	},
	{
		.name = "L1D_CACHE_BTC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x020d,
		.desc = "This event counts demand access that hits cache line with shared status and requests exclusive access in the Level 1 data cache, causing a coherence access to outside of the Level 1 caches of this PE.",
	},
	{
		.name = "L1I_CACHE_REFILL_DM_RD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x020f,
		.desc = "This event counts L1I_CACHE_REFILL caused by demand read access.",
	},
	{
		.name = "L1HWPF_STREAM_PF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0230,
		.desc = "This event counts streaming prefetch requests to L1D cache generated by hardware prefetcher.",
	},
	{
		.name = "L1HWPF_STRIDE_PF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0231,
		.desc = "This event counts stride prefetch requests to L1D cache generated by hardware prefetcher.",
	},
	{
		.name = "L1HWPF_PFTGT_PF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0232,
		.desc = "This event counts LDS prefetch requests to L1D cache generated by hardware prefetcher.",
	},
	{
		.name = "L2HWPF_STREAM_PF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0234,
		.desc = "This event counts streaming prefetch requests to L2 cache generated by hardware prefetcher.",
	},
	{
		.name = "L2HWPF_STRIDE_PF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0235,
		.desc = "This event counts stride prefetch requests to L2 cache generated by hardware prefetcher.",
	},
	{
		.name = "L2HWPF_OTHER",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0237,
		.desc = "This event counts prefetch requests to L2 cache generated by the other causes.",
	},
	{
		.name = "L3HWPF_STREAM_PF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0238,
		.desc = "This event counts streaming prefetch requests to L3 cache generated by hardware prefetcher.",
	},
	{
		.name = "L3HWPF_STRIDE_PF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0239,
		.desc = "This event counts stride prefetch requests to L3 cache generated by hardware prefetcher.",
	},
	{
		.name = "L3HWPF_OTHER",
		.modmsk = ARMV9_ATTRS,
		.code = 0x023b,
		.desc = "This event counts prefetch requests to L3 cache generated by the other causes.",
	},
	{
		.name = "L1IHWPF_NEXTLINE_PF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x023c,
		.desc = "This event counts next line's prefetch requests to L1I cache generated by hardware prefetcher.",
	},
	{
		.name = "L1_PIPE0_VAL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0240,
		.desc = "This event counts valid cycles of L1D cache pipeline#0.",
	},
	{
		.name = "L1_PIPE1_VAL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0241,
		.desc = "This event counts valid cycles of L1D cache pipeline#1.",
	},
	{
		.name = "L1_PIPE2_VAL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0242,
		.desc = "This event counts valid cycles of L1D cache pipeline#2.",
	},
	{
		.name = "L1_PIPE0_COMP",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0250,
		.desc = "This event counts completed requests in L1D cache pipeline#0.",
	},
	{
		.name = "L1_PIPE1_COMP",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0251,
		.desc = "This event counts completed requests in L1D cache pipeline#1.",
	},
	{
		.name = "L1_PIPE_ABORT_STLD_INTLK",
		.modmsk = ARMV9_ATTRS,
		.code = 0x025a,
		.desc = "This event counts aborted requests in L1D pipelines that due to store-load interlock.",
	},
	{
		.name = "L1I_PIPE_COMP",
		.modmsk = ARMV9_ATTRS,
		.code = 0x026c,
		.desc = "This event counts completed requests in L1I cache pipeline.",
	},
	{
		.name = "L1I_PIPE_VAL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x026d,
		.desc = "This event counts valid cycles of L1I cache pipeline.",
	},
	{
		.name = "L1_PIPE0_VAL_IU_TAG_ADRS_SCE",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0278,
		.desc = "This event counts requests in L1D cache pipeline#0 that its sce bit of tagged address is 1.",
	},
	{
		.name = "L1_PIPE1_VAL_IU_TAG_ADRS_SCE",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0279,
		.desc = "This event counts requests in L1D cache pipeline#1 that its sce bit of tagged address is 1.",
	},
	{
		.name = "L1_PIPE0_VAL_IU_NOT_SEC0",
		.modmsk = ARMV9_ATTRS,
		.code = 0x02a0,
		.desc = "This event counts requests in L1D cache pipeline#0 that its sector cache ID is not 0.",
	},
	{
		.name = "L1_PIPE1_VAL_IU_NOT_SEC0",
		.modmsk = ARMV9_ATTRS,
		.code = 0x02a1,
		.desc = "This event counts requests in L1D cache pipeline#1 that its sector cache ID is not 0.",
	},
	{
		.name = "L1_PIPE_COMP_GATHER_2FLOW",
		.modmsk = ARMV9_ATTRS,
		.code = 0x02b0,
		.desc = "This event counts the number of times where 2 elements of the gather instructions became 2-flows because 2 elements could not be combined.",
	},
	{
		.name = "L1_PIPE_COMP_GATHER_1FLOW",
		.modmsk = ARMV9_ATTRS,
		.code = 0x02b1,
		.desc = "This event counts the number of times where 2 elements of the gather instructions became 1-flow because 2 elements could be combined.",
	},
	{
		.name = "L1_PIPE_COMP_GATHER_0FLOW",
		.modmsk = ARMV9_ATTRS,
		.code = 0x02b2,
		.desc = "This event counts the number of times where 2 elements of the gather instructions became 0-flow because both predicate values are 0.",
	},
	{
		.name = "L1_PIPE_COMP_SCATTER_1FLOW",
		.modmsk = ARMV9_ATTRS,
		.code = 0x02b3,
		.desc = "This event counts the number of flows of the scatter instructions.",
	},
	{
		.name = "L1_PIPE0_COMP_PRD_CNT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x02b8,
		.desc = "This event counts the number of 1's in the predicate bits of request in L1D cache pipeline#0, where it is corrected so that it becomes 64 when all bits are 1.",
	},
	{
		.name = "L1_PIPE1_COMP_PRD_CNT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x02b9,
		.desc = "This event counts the number of 1's in the predicate bits of request in L1D cache pipeline#1, where it is corrected so that it becomes 64 when all bits are 1.",
	},
	{
		.name = "L2D_CACHE_DM",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0300,
		.desc = "This event counts L2D_CACHE caused by demand access.",
	},
	{
		.name = "L2D_CACHE_DM_RD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0301,
		.desc = "This event counts L2D_CACHE caused by demand read access.",
	},
	{
		.name = "L2D_CACHE_DM_WR",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0302,
		.desc = "This event counts L2D_CACHE caused by demand write access.",
	},
	{
		.name = "L2D_CACHE_HWPRF_ADJACENT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0305,
		.desc = "This event counts L2D_CACHE caused by hardware adjacent prefetch.",
	},
	{
		.name = "L2D_CACHE_REFILL_DM",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0308,
		.desc = "This event counts L2D_CACHE_REFILL caused by demand access.",
	},
	{
		.name = "L2D_CACHE_REFILL_DM_RD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0309,
		.desc = "This event counts L2D_CACHE_REFILL caused by demand read access.",
	},
	{
		.name = "L2D_CACHE_REFILL_DM_WR",
		.modmsk = ARMV9_ATTRS,
		.code = 0x030a,
		.desc = "This event counts L2D_CACHE_REFILL caused by demand write access.",
	},
	{
		.name = "L2D_CACHE_REFILL_DM_WR_EXCL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x030b,
		.desc = "This event counts L2D_CACHE_REFILL caused by demand write exclusive access.",
	},
	{
		.name = "L2D_CACHE_REFILL_DM_WR_ATOM",
		.modmsk = ARMV9_ATTRS,
		.code = 0x030c,
		.desc = "This event counts L2D_CACHE_REFILL caused by demand write atomic access.",
	},
	{
		.name = "L2D_CACHE_BTC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x030d,
		.desc = "This event counts demand access that hits cache line with shared status and requests exclusive access in the Level 1 data and Level 2 caches, causing a coherence access to outside of the Level 1 and Level 2 caches of this PE.",
	},
	{
		.name = "L2_PIPE_VAL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0330,
		.desc = "This event counts valid cycles of L2 cache pipeline.",
	},
	{
		.name = "L2_PIPE_COMP_ALL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0350,
		.desc = "This event counts completed requests in L2 cache pipeline.",
	},
	{
		.name = "L2_PIPE_COMP_PF_L2MIB_MCH",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0370,
		.desc = "This event counts operations where software or hardware prefetch hits an L2 cache refill buffer allocated by demand access.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_CACHE",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0390,
		.desc = "This event counts operations that cause a cache access to the L3 cache.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_CACHE_DM",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0391,
		.desc = "This event counts L2D_CACHE_REFILL_L3D_CACHE caused by demand access.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_CACHE_DM_RD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0392,
		.desc = "This event counts L2D_CACHE_REFILL_L3D_CACHE caused by demand read access.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_CACHE_DM_WR",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0393,
		.desc = "This event counts L2D_CACHE_REFILL_L3D_CACHE caused by demand write access.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_CACHE_PRF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0394,
		.desc = "This event counts L2D_CACHE_REFILL_L3D_CACHE caused by hardware prefetch or software prefetch.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_CACHE_HWPRF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0395,
		.desc = "This event counts L2D_CACHE_REFILL_L3D_CACHE caused by hardware prefetch.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_MISS",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0396,
		.desc = "This event counts operations that cause a miss of the L3 cache. Note: This event may count inaccurately.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_MISS_DM",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0397,
		.desc = "This event counts L2D_CACHE_REFILL_L3D_MISS caused by demand access.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_MISS_DM_RD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0398,
		.desc = "This event counts L2D_CACHE_REFILL_L3D_MISS caused by demand read access.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_MISS_DM_WR",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0399,
		.desc = "This event counts L2D_CACHE_REFILL_L3D_MISS caused by demand write access.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_MISS_PRF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x039a,
		.desc = "This event counts L2D_CACHE_REFILL_L3D_MISS caused by hardware prefetch or software prefetch. Note: This event may count inaccurately.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_MISS_HWPRF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x039b,
		.desc = "This event counts L2D_CACHE_REFILL_L3D_MISS caused by hardware prefetch. Note: This event may count inaccurately.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_HIT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x039c,
		.desc = "This event counts operations that cause a hit of the L3 cache. Note: This event may count inaccurately.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_HIT_DM",
		.modmsk = ARMV9_ATTRS,
		.code = 0x039d,
		.desc = "This event counts L2D_CACHE_REFILL_L3D_HIT caused by demand access.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_HIT_DM_RD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x039e,
		.desc = "This event counts L2D_CACHE_REFILL_L3D_HIT caused by demand read access.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_HIT_DM_WR",
		.modmsk = ARMV9_ATTRS,
		.code = 0x039f,
		.desc = "This event counts L2D_CACHE_REFILL_L3D_HIT caused by demand write access.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_HIT_PRF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x03a0,
		.desc = "This event counts L2D_CACHE_REFILL_L3D_HIT caused by hardware prefetch or software prefetch. Note: This event may count inaccurately.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_HIT_HWPRF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x03a1,
		.desc = "This event counts L2D_CACHE_REFILL_L3D_HIT caused by hardware prefetch. Note: This event may count inaccurately.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_MISS_DM_PFTGT_HIT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x03a3,
		.desc = "This event counts the number of L3 cache misses caused by demand access where the requests hit the PFTGT buffer.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_MISS_DM_RD_PFTGT_HIT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x03a4,
		.desc = "This event counts L2D_CACHE_REFILL_L3D_MISS_DM_PFTGT_HIT caused by read access.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_MISS_DM_WR_PFTGT_HIT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x03a5,
		.desc = "This event counts L2D_CACHE_REFILL_L3D_MISS_DM_PFTGT_HIT caused by write access.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_MISS_DM_L_MEM",
		.modmsk = ARMV9_ATTRS,
		.code = 0x03a6,
		.desc = "This event counts L2D_CACHE_REFILL_L3D_MISS_DM where the requests access the memory in the same socket as the requests.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_MISS_DM_FR_MEM",
		.modmsk = ARMV9_ATTRS,
		.code = 0x03a7,
		.desc = "This event counts L2D_CACHE_REFILL_L3D_MISS_DM where the requests access the memory in the different socket from the requests.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_MISS_DM_L_L2",
		.modmsk = ARMV9_ATTRS,
		.code = 0x03a8,
		.desc = "This event counts L2D_CACHE_REFILL_L3D_MISS_DM where the requests access the different L2 cache from the requests in the same Numa nodes as the requests.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_MISS_DM_NR_L2",
		.modmsk = ARMV9_ATTRS,
		.code = 0x03a9,
		.desc = "This event counts L2D_CACHE_REFILL_L3D_MISS_DM where the requests access L2 cache in the different Numa nodes from the requests in the same socket as the requests.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_MISS_DM_NR_L3",
		.modmsk = ARMV9_ATTRS,
		.code = 0x03aa,
		.desc = "This event counts L2D_CACHE_REFILL_L3D_MISS_DM where the requests access L3 cache in the different Numa nodes from the requests in the same socket as the requests.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_MISS_DM_FR_L2",
		.modmsk = ARMV9_ATTRS,
		.code = 0x03ab,
		.desc = "This event counts L2D_CACHE_REFILL_L3D_MISS_DM where the requests access L2 cache in the different socket from the requests.",
	},
	{
		.name = "L2D_CACHE_REFILL_L3D_MISS_DM_FR_L3",
		.modmsk = ARMV9_ATTRS,
		.code = 0x03ac,
		.desc = "This event counts L2D_CACHE_REFILL_L3D_MISS_DM where the requests access L3 cache in the different socket from the requests.",
	},
	{
		.name = "L2D_CACHE_WB_VICTIM_CLEAN",
		.modmsk = ARMV9_ATTRS,
		.code = 0x03b0,
		.desc = "This event counts every write-back of data from the L2 cache caused by L2 replace where the data is clean. In this case, the data will usually be written to L3 cache.",
	},
	{
		.name = "L2D_CACHE_WB_NT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x03b1,
		.desc = "This event counts every write-back of data from the L2 cache caused by non-temporal-store.",
	},
	{
		.name = "L2D_CACHE_WB_DCZVA",
		.modmsk = ARMV9_ATTRS,
		.code = 0x03b2,
		.desc = "This event counts every write-back of data from the L2 cache caused by DC ZVA.",
	},
	{
		.name = "L2D_CACHE_FB",
		.modmsk = ARMV9_ATTRS,
		.code = 0x03b3,
		.desc = "This event counts every flush-back (drop) of data from the L2 cache.",
	},
	{
		.name = "EA_L3",
		.modmsk = ARMV9_ATTRS,
		.code = 0x03f0,
		.desc = "This event counts energy consumption of L3 cache.",
	},
	{
		.name = "EA_LDO_LOSS",
		.modmsk = ARMV9_ATTRS,
		.code = 0x03f1,
		.desc = "This event counts energy consumption of LDO loss.",
	},
	{
		.name = "GCYCLES",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0880,
		.desc = "This event counts the number of cycles at 100MHz.",
	},
	{
		.name = "FL0_GCYCLES",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0890,
		.desc = "This event counts the number of cycles where the measured core is staying in the Frequency Level 0.",
	},
	{
		.name = "FL1_GCYCLES",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0891,
		.desc = "This event counts the number of cycles where the measured core is staying in the Frequency Level 1.",
	},
	{
		.name = "FL2_GCYCLES",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0892,
		.desc = "This event counts the number of cycles where the measured core is staying in the Frequency Level 2.",
	},
	{
		.name = "FL3_GCYCLES",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0893,
		.desc = "This event counts the number of cycles where the measured core is staying in the Frequency Level 3.",
	},
	{
		.name = "FL4_GCYCLES",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0894,
		.desc = "This event counts the number of cycles where the measured core is staying in the Frequency Level 4.",
	},
	{
		.name = "FL5_GCYCLES",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0895,
		.desc = "This event counts the number of cycles where the measured core is staying in the Frequency Level 5.",
	},
	{
		.name = "FL6_GCYCLES",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0896,
		.desc = "This event counts the number of cycles where the measured core is staying in the Frequency Level 6.",
	},
	{
		.name = "FL7_GCYCLES",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0897,
		.desc = "This event counts the number of cycles where the measured core is staying in the Frequency Level 7.",
	},
	{
		.name = "FL8_GCYCLES",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0898,
		.desc = "This event counts the number of cycles where the measured core is staying in the Frequency Level 8.",
	},
	{
		.name = "FL9_GCYCLES",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0899,
		.desc = "This event counts the number of cycles where the measured core is staying in the Frequency Level 9.",
	},
	{
		.name = "FL10_GCYCLES",
		.modmsk = ARMV9_ATTRS,
		.code = 0x089a,
		.desc = "This event counts the number of cycles where the measured core is staying in the Frequency Level 10.",
	},
	{
		.name = "FL11_GCYCLES",
		.modmsk = ARMV9_ATTRS,
		.code = 0x089b,
		.desc = "This event counts the number of cycles where the measured core is staying in the Frequency Level 11.",
	},
	{
		.name = "FL12_GCYCLES",
		.modmsk = ARMV9_ATTRS,
		.code = 0x089c,
		.desc = "This event counts the number of cycles where the measured core is staying in the Frequency Level 12.",
	},
	{
		.name = "FL13_GCYCLES",
		.modmsk = ARMV9_ATTRS,
		.code = 0x089d,
		.desc = "This event counts the number of cycles where the measured core is staying in the Frequency Level 13.",
	},
	{
		.name = "FL14_GCYCLES",
		.modmsk = ARMV9_ATTRS,
		.code = 0x089e,
		.desc = "This event counts the number of cycles where the measured core is staying in the Frequency Level 14.",
	},
	{
		.name = "FL15_GCYCLES",
		.modmsk = ARMV9_ATTRS,
		.code = 0x089f,
		.desc = "This event counts the number of cycles where the measured core is staying in the Frequency Level 15.",
	},
	{
		.name = "RETENTION_GCYCLES",
		.modmsk = ARMV9_ATTRS,
		.code = 0x08a0,
		.desc = "This event counts the number of cycles where the measured core is staying in the RETENTION state.",
	},
	{
		.name = "RETENTION_COUNT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x08a1,
		.desc = "This event counts the number of changes from the normal state to the RETENTION state.",
	},
	{
		.name = "L1I_TLB_4K",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c00,
		.desc = "This event counts operations that cause a TLB access to the L1I in 4KB page.",
	},
	{
		.name = "L1I_TLB_64K",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c01,
		.desc = "This event counts operations that cause a TLB access to the L1I in 64KB page.",
	},
	{
		.name = "L1I_TLB_2M",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c02,
		.desc = "This event counts operations that cause a TLB access to the L1I in 2MB page.",
	},
	{
		.name = "L1I_TLB_32M",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c03,
		.desc = "This event counts operations that cause a TLB access to the L1I in 32MB page.",
	},
	{
		.name = "L1I_TLB_512M",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c04,
		.desc = "This event counts operations that cause a TLB access to the L1I in 512MB page.",
	},
	{
		.name = "L1I_TLB_1G",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c05,
		.desc = "This event counts operations that cause a TLB access to the L1I in 1GB page.",
	},
	{
		.name = "L1I_TLB_16G",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c06,
		.desc = "This event counts operations that cause a TLB access to the L1I in 16GB page.",
	},
	{
		.name = "L1D_TLB_4K",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c08,
		.desc = "This event counts operations that cause a TLB access to the L1D in 4KB page.",
	},
	{
		.name = "L1D_TLB_64K",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c09,
		.desc = "This event counts operations that cause a TLB access to the L1D in 64KB page.",
	},
	{
		.name = "L1D_TLB_2M",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c0a,
		.desc = "This event counts operations that cause a TLB access to the L1D in 2MB page.",
	},
	{
		.name = "L1D_TLB_32M",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c0b,
		.desc = "This event counts operations that cause a TLB access to the L1D in 32MB page.",
	},
	{
		.name = "L1D_TLB_512M",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c0c,
		.desc = "This event counts operations that cause a TLB access to the L1D in 512MB page.",
	},
	{
		.name = "L1D_TLB_1G",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c0d,
		.desc = "This event counts operations that cause a TLB access to the L1D in 1GB page.",
	},
	{
		.name = "L1D_TLB_16G",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c0e,
		.desc = "This event counts operations that cause a TLB access to the L1D in 16GB page.",
	},
	{
		.name = "L1I_TLB_REFILL_4K",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c10,
		.desc = "This event counts operations that cause a TLB refill of the L1I in 4KB page.",
	},
	{
		.name = "L1I_TLB_REFILL_64K",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c11,
		.desc = "This event counts operations that cause a TLB refill of the L1I in 64KB page.",
	},
	{
		.name = "L1I_TLB_REFILL_2M",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c12,
		.desc = "This event counts operations that cause a TLB refill of the L1I in 2MB page.",
	},
	{
		.name = "L1I_TLB_REFILL_32M",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c13,
		.desc = "This event counts operations that cause a TLB refill of the L1I in 32MB page.",
	},
	{
		.name = "L1I_TLB_REFILL_512M",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c14,
		.desc = "This event counts operations that cause a TLB refill of the L1I in 512MB page.",
	},
	{
		.name = "L1I_TLB_REFILL_1G",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c15,
		.desc = "This event counts operations that cause a TLB refill of the L1I in 1GB page.",
	},
	{
		.name = "L1I_TLB_REFILL_16G",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c16,
		.desc = "This event counts operations that cause a TLB refill of the L1I in 16GB page.",
	},
	{
		.name = "L1D_TLB_REFILL_4K",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c18,
		.desc = "This event counts operations that cause a TLB refill of the L1D in 4KB page.",
	},
	{
		.name = "L1D_TLB_REFILL_64K",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c19,
		.desc = "This event counts operations that cause a TLB refill of the L1D in 64KB page.",
	},
	{
		.name = "L1D_TLB_REFILL_2M",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c1a,
		.desc = "This event counts operations that cause a TLB refill of the L1D in 2MB page.",
	},
	{
		.name = "L1D_TLB_REFILL_32M",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c1b,
		.desc = "This event counts operations that cause a TLB refill of the L1D in 32MB page.",
	},
	{
		.name = "L1D_TLB_REFILL_512M",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c1c,
		.desc = "This event counts operations that cause a TLB refill of the L1D in 512MB page.",
	},
	{
		.name = "L1D_TLB_REFILL_1G",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c1d,
		.desc = "This event counts operations that cause a TLB refill of the L1D in 1GB page.",
	},
	{
		.name = "L1D_TLB_REFILL_16G",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c1e,
		.desc = "This event counts operations that cause a TLB refill of the L1D in 16GB page.",
	},
	{
		.name = "L2I_TLB_4K",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c20,
		.desc = "This event counts operations that cause a TLB access to the L2I in 4KB page.",
	},
	{
		.name = "L2I_TLB_64K",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c21,
		.desc = "This event counts operations that cause a TLB access to the L2I in 64KB page.",
	},
	{
		.name = "L2I_TLB_2M",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c22,
		.desc = "This event counts operations that cause a TLB access to the L2I in 2MB page.",
	},
	{
		.name = "L2I_TLB_32M",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c23,
		.desc = "This event counts operations that cause a TLB access to the L2I in 32MB page.",
	},
	{
		.name = "L2I_TLB_512M",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c24,
		.desc = "This event counts operations that cause a TLB access to the L2I in 512MB page.",
	},
	{
		.name = "L2I_TLB_1G",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c25,
		.desc = "This event counts operations that cause a TLB access to the L2I in 1GB page.",
	},
	{
		.name = "L2I_TLB_16G",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c26,
		.desc = "This event counts operations that cause a TLB access to the L2I in 16GB page.",
	},
	{
		.name = "L2D_TLB_4K",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c28,
		.desc = "This event counts operations that cause a TLB access to the L2D in 4KB page.",
	},
	{
		.name = "L2D_TLB_64K",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c29,
		.desc = "This event counts operations that cause a TLB access to the L2D in 64KB page.",
	},
	{
		.name = "L2D_TLB_2M",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c2a,
		.desc = "This event counts operations that cause a TLB access to the L2D in 2MB page.",
	},
	{
		.name = "L2D_TLB_32M",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c2b,
		.desc = "This event counts operations that cause a TLB access to the L2D in 32MB page.",
	},
	{
		.name = "L2D_TLB_512M",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c2c,
		.desc = "This event counts operations that cause a TLB access to the L2D in 512MB page.",
	},
	{
		.name = "L2D_TLB_1G",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c2d,
		.desc = "This event counts operations that cause a TLB access to the L2D in 1GB page.",
	},
	{
		.name = "L2D_TLB_16G",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c2e,
		.desc = "This event counts operations that cause a TLB access to the L2D in 16GB page.",
	},
	{
		.name = "L2I_TLB_REFILL_4K",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c30,
		.desc = "This event counts operations that cause a TLB refill of the L2I in 4KB page.",
	},
	{
		.name = "L2I_TLB_REFILL_64K",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c31,
		.desc = "This event counts operations that cause a TLB refill of the L2I in 64KB page.",
	},
	{
		.name = "L2I_TLB_REFILL_2M",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c32,
		.desc = "This event counts operations that cause a TLB refill of the L2I in 2MB page.",
	},
	{
		.name = "L2I_TLB_REFILL_32M",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c33,
		.desc = "This event counts operations that cause a TLB refill of the L2I in 32MB page.",
	},
	{
		.name = "L2I_TLB_REFILL_512M",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c34,
		.desc = "This event counts operations that cause a TLB refill of the L2I in 512MB page.",
	},
	{
		.name = "L2I_TLB_REFILL_1G",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c35,
		.desc = "This event counts operations that cause a TLB refill of the L2I in 1GB page.",
	},
	{
		.name = "L2I_TLB_REFILL_16G",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c36,
		.desc = "This event counts operations that cause a TLB refill of the L2I in 16GB page.",
	},
	{
		.name = "L2D_TLB_REFILL_4K",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c38,
		.desc = "This event counts operations that cause a TLB refill of the L2D in 4KB page.",
	},
	{
		.name = "L2D_TLB_REFILL_64K",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c39,
		.desc = "This event counts operations that cause a TLB refill of the L2D in 64KB page.",
	},
	{
		.name = "L2D_TLB_REFILL_2M",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c3a,
		.desc = "This event counts operations that cause a TLB refill of the L2D in 2MB page.",
	},
	{
		.name = "L2D_TLB_REFILL_32M",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c3b,
		.desc = "This event counts operations that cause a TLB refill of the L2D in 32MB page.",
	},
	{
		.name = "L2D_TLB_REFILL_512M",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c3c,
		.desc = "This event counts operations that cause a TLB refill of the L2D in 512MB page.",
	},
	{
		.name = "L2D_TLB_REFILL_1G",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c3d,
		.desc = "This event counts operations that cause a TLB refill of the L2D in 1GB page.",
	},
	{
		.name = "L2D_TLB_REFILL_16G",
		.modmsk = ARMV9_ATTRS,
		.code = 0x0c3e,
		.desc = "This event counts operations that cause a TLB refill of the L2D in 16GB page.",
	},
	{
		.name = "CNT_CYCLES",
		.modmsk = ARMV9_ATTRS,
		.code = 0x4004,
		.desc = "This event counts the constant frequency cycles counter increments at a constant frequency equal to the rate of increment of the System counter.",
	},
	{
		.name = "STALL_BACKEND_MEM",
		.modmsk = ARMV9_ATTRS,
		.code = 0x4005,
		.desc = "This event counts every cycle that no instruction was dispatched from decode unit due to memory stall.",
	},
	{
		.name = "L1I_CACHE_LMISS",
		.modmsk = ARMV9_ATTRS,
		.code = 0x4006,
		.desc = "This event counts operations that cause a refill of the L1I cache that incurs additional latency.",
	},
	{
		.name = "L2D_CACHE_LMISS_RD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x4009,
		.desc = "This event counts operations that cause a refill of the L2 cache that incurs additional latency.",
	},
	{
		.name = "L3D_CACHE_LMISS_RD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x400b,
		.desc = "This event counts access counted by L3D_CACHE that is not completed by the L3 cache, and a Memory-read operation, as defined by the L2D_CACHE_REFILL_L3D_MISS events. Note: This event may count inaccurately.",
	},
	{
		.name = "TRB_WRAP",
		.modmsk = ARMV9_ATTRS,
		.code = 0x400c,
		.desc = "This event counts the event generated each time the current write pointer is wrapped to the base pointer.",
	},
	{
		.name = "PMU_OVFS",
		.modmsk = ARMV9_ATTRS,
		.code = 0x400d,
		.desc = "This event counts the event generated each time one of the condition occurs described in Arm Architecture Reference Manual for A-profile architecture. This event is only for output to the trace unit.",
	},
	{
		.name = "TRB_TRIG",
		.modmsk = ARMV9_ATTRS,
		.code = 0x400e,
		.desc = "This event counts the event generated when a Trace Buffer Extension Trigger Event occurs.",
	},
	{
		.name = "PMU_HOVFS",
		.modmsk = ARMV9_ATTRS,
		.code = 0x400f,
		.desc = "This event counts the event generated each time an event is counted by an event counter <n> and all of the condition occur described in Arm Architecture Reference Manual for A-profile architecture. This event is only for output to the trace unit.",
	},
	{
		.name = "TRCEXTOUT0",
		.modmsk = ARMV9_ATTRS,
		.code = 0x4010,
		.desc = "This event counts the event generated each time an event is signaled by the trace unit external event 0.",
	},
	{
		.name = "CTI_TRIGOUT4",
		.modmsk = ARMV9_ATTRS,
		.code = 0x4018,
		.desc = "This event counts the event generated each time an event is signaled on CTI output trigger 4.",
	},
	{
		.name = "SIMD_INST_RETIRED",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8000,
		.desc = "This event counts architecturally executed SIMD instructions, excluding the Advanced SIMD scalar instructions and the instructions listed in Non-SIMD SVE instructions section of ARMv9 Reference Manual.",
	},
	{
		.name = "SVE_INST_RETIRED",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8002,
		.desc = "This event counts architecturally executed SVE instructions, including the instructions listed in Non-SIMD SVE instructions section of ARMv9 Reference Manual.",
	},
	{
		.name = "ASE_INST_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8005,
		.desc = "This event counts architecturally executed Advanced SIMD operation.",
	},
	{
		.name = "SVE_INST_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8006,
		.desc = "This event counts architecturally executed SVE instructions, including the instructions listed in Non-SIMD SVE instructions section of ARMv9 Reference Manual.",
	},
	{
		.name = "ASE_SVE_INST_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8007,
		.desc = "This event counts architecturally executed Advanced SIMD or SVE operation.",
	},
	{
		.name = "UOP_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8008,
		.desc = "This event counts all architecturally executed micro-operation.",
	},
	{
		.name = "SVE_MATH_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x800e,
		.desc = "This event counts architecturally executed math function operations due to the SVE FTSMUL, FTMAD, FTSSEL, and FEXPA instructions.",
	},
	{
		.name = "FP_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8010,
		.desc = "This event counts architecturally executed operations due to scalar, Advanced SIMD, and SVE instructions listed in Floating-point instructions section of ARMv9 Reference Manual.",
	},
	{
		.name = "ASE_FP_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8011,
		.desc = "This event counts architecturally executed Advanced SIMD floating-point operation.",
	},
	{
		.name = "SVE_FP_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8012,
		.desc = "This event counts architecturally executed SVE floating-point operation.",
	},
	{
		.name = "ASE_SVE_FP_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8013,
		.desc = "This event counts architecturally executed Advanced SIMD or SVE floating-point operation.",
	},
	{
		.name = "FP_HP_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8014,
		.desc = "This event counts architecturally executed half-precision floating-point operation.",
	},
	{
		.name = "ASE_FP_HP_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8015,
		.desc = "This event counts architecturally executed Advanced SIMD half-precision floating-point operation.",
	},
	{
		.name = "SVE_FP_HP_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8016,
		.desc = "This event counts architecturally executed SVE half-precision floating-point operation.",
	},
	{
		.name = "ASE_SVE_FP_HP_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8017,
		.desc = "This event counts architecturally executed Advanced SIMD or SVE half-precision floating-point operation.",
	},
	{
		.name = "FP_SP_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8018,
		.desc = "This event counts architecturally executed single-precision floating-point operation.",
	},
	{
		.name = "ASE_FP_SP_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8019,
		.desc = "This event counts architecturally executed Advanced SIMD single-precision floating-point operation.",
	},
	{
		.name = "SVE_FP_SP_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x801a,
		.desc = "This event counts architecturally executed SVE single-precision floating-point operation.",
	},
	{
		.name = "ASE_SVE_FP_SP_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x801b,
		.desc = "This event counts architecturally executed Advanced SIMD or SVE single-precision floating-point operation.",
	},
	{
		.name = "FP_DP_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x801c,
		.desc = "This event counts architecturally executed double-precision floating-point operation.",
	},
	{
		.name = "ASE_FP_DP_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x801d,
		.desc = "This event counts architecturally executed Advanced SIMD double-precision floating-point operation.",
	},
	{
		.name = "SVE_FP_DP_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x801e,
		.desc = "This event counts architecturally executed SVE double-precision floating-point operation.",
	},
	{
		.name = "ASE_SVE_FP_DP_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x801f,
		.desc = "This event counts architecturally executed Advanced SIMD or SVE double-precision floating-point operation.",
	},
	{
		.name = "FP_DIV_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8020,
		.desc = "This event counts architecturally executed floating-point divide operation.",
	},
	{
		.name = "ASE_FP_DIV_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8021,
		.desc = "This event counts architecturally executed Advanced SIMD floating-point divide operation.",
	},
	{
		.name = "SVE_FP_DIV_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8022,
		.desc = "This event counts architecturally executed SVE floating-point divide operation.",
	},
	{
		.name = "ASE_SVE_FP_DIV_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8023,
		.desc = "This event counts architecturally executed Advanced SIMD or SVE floating-point divide operation.",
	},
	{
		.name = "FP_SQRT_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8024,
		.desc = "This event counts architecturally executed floating-point square root operation.",
	},
	{
		.name = "ASE_FP_SQRT_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8025,
		.desc = "This event counts architecturally executed Advanced SIMD floating-point square root operation.",
	},
	{
		.name = "SVE_FP_SQRT_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8026,
		.desc = "This event counts architecturally executed SVE floating-point square root operation.",
	},
	{
		.name = "ASE_SVE_FP_SQRT_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8027,
		.desc = "This event counts architecturally executed Advanced SIMD or SVE floating-point square root operation.",
	},
	{
		.name = "FP_FMA_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8028,
		.desc = "This event counts architecturally executed floating-point fused multiply-add and multiply-subtract operation.",
	},
	{
		.name = "ASE_FP_FMA_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8029,
		.desc = "This event counts architecturally executed Advanced SIMD floating-point FMA operation.",
	},
	{
		.name = "SVE_FP_FMA_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x802a,
		.desc = "This event counts architecturally executed SVE floating-point FMA operation.",
	},
	{
		.name = "ASE_SVE_FP_FMA_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x802b,
		.desc = "This event counts architecturally executed Advanced SIMD or SVE floating-point FMA operation.",
	},
	{
		.name = "FP_MUL_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x802c,
		.desc = "This event counts architecturally executed floating-point multiply operation.",
	},
	{
		.name = "ASE_FP_MUL_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x802d,
		.desc = "This event counts architecturally executed Advanced SIMD floating-point multiply operation.",
	},
	{
		.name = "SVE_FP_MUL_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x802e,
		.desc = "This event counts architecturally executed SVE floating-point multiply operation.",
	},
	{
		.name = "ASE_SVE_FP_MUL_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x802f,
		.desc = "This event counts architecturally executed Advanced SIMD or SVE floating-point multiply operation.",
	},
	{
		.name = "FP_ADDSUB_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8030,
		.desc = "This event counts architecturally executed floating-point add or subtract operation.",
	},
	{
		.name = "ASE_FP_ADDSUB_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8031,
		.desc = "This event counts architecturally executed Advanced SIMD floating-point add or subtract operation.",
	},
	{
		.name = "SVE_FP_ADDSUB_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8032,
		.desc = "This event counts architecturally executed SVE floating-point add or subtract operation.",
	},
	{
		.name = "ASE_SVE_FP_ADDSUB_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8033,
		.desc = "This event counts architecturally executed Advanced SIMD or SVE floating-point add or subtract operation.",
	},
	{
		.name = "FP_RECPE_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8034,
		.desc = "This event counts architecturally executed floating-point reciprocal estimate operations due to the Advanced SIMD scalar, Advanced SIMD vector, and SVE FRECPE and FRSQRTE instructions.",
	},
	{
		.name = "ASE_FP_RECPE_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8035,
		.desc = "This event counts architecturally executed Advanced SIMD floating-point reciprocal estimate operation.",
	},
	{
		.name = "SVE_FP_RECPE_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8036,
		.desc = "This event counts architecturally executed SVE floating-point reciprocal estimate operation.",
	},
	{
		.name = "ASE_SVE_FP_RECPE_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8037,
		.desc = "This event counts architecturally executed Advanced SIMD or SVE floating-point reciprocal estimate operation.",
	},
	{
		.name = "FP_CVT_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8038,
		.desc = "This event counts architecturally executed floating-point convert operations due to the scalar, Advanced SIMD, and SVE floating-point conversion instructions listed in Floating-point conversions section of ARMv9 Reference Manual.",
	},
	{
		.name = "ASE_FP_CVT_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8039,
		.desc = "This event counts architecturally executed Advanced SIMD floating-point convert operation.",
	},
	{
		.name = "SVE_FP_CVT_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x803a,
		.desc = "This event counts architecturally executed SVE floating-point convert operation.",
	},
	{
		.name = "ASE_SVE_FP_CVT_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x803b,
		.desc = "This event counts architecturally executed Advanced SIMD or SVE floating-point convert operation.",
	},
	{
		.name = "SVE_FP_AREDUCE_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x803c,
		.desc = "This event counts architecturally executed SVE floating-point accumulating reduction operation.",
	},
	{
		.name = "ASE_FP_PREDUCE_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x803d,
		.desc = "This event counts architecturally executed Advanced SIMD floating-point pairwise add step operation.",
	},
	{
		.name = "SVE_FP_VREDUCE_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x803e,
		.desc = "This event counts architecturally executed SVE floating-point vector reduction operation.",
	},
	{
		.name = "ASE_SVE_FP_VREDUCE_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x803f,
		.desc = "This event counts architecturally executed Advanced SIMD or SVE floating-point vector reduction operation.",
	},
	{
		.name = "INT_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8040,
		.desc = "This event counts architecturally executed operations due to scalar, Advanced SIMD, and SVE instructions listed in Integer instructions section of ARMv9 Reference Manual.",
	},
	{
		.name = "ASE_INT_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8041,
		.desc = "This event counts architecturally executed Advanced SIMD integer operation.",
	},
	{
		.name = "SVE_INT_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8042,
		.desc = "This event counts architecturally executed SVE integer operation.",
	},
	{
		.name = "ASE_SVE_INT_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8043,
		.desc = "This event counts architecturally executed Advanced SIMD or SVE integer operation.",
	},
	{
		.name = "INT_DIV_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8044,
		.desc = "This event counts architecturally executed integer divide operation.",
	},
	{
		.name = "INT_DIV64_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8045,
		.desc = "This event counts architecturally executed 64-bit integer divide operation.",
	},
	{
		.name = "SVE_INT_DIV_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8046,
		.desc = "This event counts architecturally executed SVE integer divide operation.",
	},
	{
		.name = "SVE_INT_DIV64_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8047,
		.desc = "This event counts architecturally executed SVE 64-bit integer divide operation.",
	},
	{
		.name = "INT_MUL_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8048,
		.desc = "This event counts architecturally executed integer multiply operation.",
	},
	{
		.name = "ASE_INT_MUL_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8049,
		.desc = "This event counts architecturally executed Advanced SIMD integer multiply operation.",
	},
	{
		.name = "SVE_INT_MUL_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x804a,
		.desc = "This event counts architecturally executed SVE integer multiply operation.",
	},
	{
		.name = "ASE_SVE_INT_MUL_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x804b,
		.desc = "This event counts architecturally executed Advanced SIMD or SVE integer multiply operation.",
	},
	{
		.name = "INT_MUL64_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x804c,
		.desc = "This event counts architecturally executed integer 64-bit x 64-bit multiply operation.",
	},
	{
		.name = "SVE_INT_MUL64_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x804d,
		.desc = "This event counts architecturally executed SVE integer 64-bit x 64-bit multiply operation.",
	},
	{
		.name = "INT_MULH64_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x804e,
		.desc = "This event counts architecturally executed integer 64-bit x 64-bit multiply returning high part operation.",
	},
	{
		.name = "SVE_INT_MULH64_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x804f,
		.desc = "This event counts architecturally executed SVE integer 64-bit x 64-bit multiply returning high part operation.",
	},
	{
		.name = "NONFP_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8058,
		.desc = "This event counts architecturally executed non-floating-point operation.",
	},
	{
		.name = "ASE_NONFP_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8059,
		.desc = "This event counts architecturally executed Advanced SIMD non-floating-point operation.",
	},
	{
		.name = "SVE_NONFP_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x805a,
		.desc = "This event counts architecturally executed SVE non-floating-point operation.",
	},
	{
		.name = "ASE_SVE_NONFP_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x805b,
		.desc = "This event counts architecturally executed Advanced SIMD or SVE non-floating-point operation.",
	},
	{
		.name = "ASE_INT_VREDUCE_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x805d,
		.desc = "This event counts architecturally executed Advanced SIMD integer reduction operation.",
	},
	{
		.name = "SVE_INT_VREDUCE_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x805e,
		.desc = "This event counts architecturally executed SVE integer reduction operation.",
	},
	{
		.name = "ASE_SVE_INT_VREDUCE_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x805f,
		.desc = "This event counts architecturally executed Advanced SIMD or SVE integer reduction operation.",
	},
	{
		.name = "SVE_PERM_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8060,
		.desc = "This event counts architecturally executed vector or predicate permute operation.",
	},
	{
		.name = "SVE_XPIPE_Z2R_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8065,
		.desc = "This event counts architecturally executed vector to general-purpose scalar cross-pipeline transfer operation.",
	},
	{
		.name = "SVE_XPIPE_R2Z_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8066,
		.desc = "This event counts architecturally executed general-purpose scalar to vector cross-pipeline transfer operation.",
	},
	{
		.name = "SVE_PGEN_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8068,
		.desc = "This event counts architecturally executed predicate-generating operation.",
	},
	{
		.name = "SVE_PGEN_FLG_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8069,
		.desc = "This event counts architecturally executed predicate-generating operation that sets condition flags.",
	},
	{
		.name = "SVE_PPERM_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x806d,
		.desc = "This event counts architecturally executed predicate permute operation.",
	},
	{
		.name = "SVE_PRED_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8074,
		.desc = "This event counts architecturally executed SIMD data-processing and load/store operations due to SVE instructions with a Governing predicate operand that determines the Active elements.",
	},
	{
		.name = "SVE_MOVPRFX_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x807c,
		.desc = "This event counts architecturally executed operations due to MOVPRFX instructions, whether or not they were fused with the prefixed instruction.",
	},
	{
		.name = "SVE_MOVPRFX_Z_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x807d,
		.desc = "This event counts architecturally executed operation counted by SVE_MOVPRFX_SPEC where the operation uses zeroing predication.",
	},
	{
		.name = "SVE_MOVPRFX_M_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x807e,
		.desc = "This event counts architecturally executed operation counted by SVE_MOVPRFX_SPEC where the operation uses merging predication.",
	},
	{
		.name = "SVE_MOVPRFX_U_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x807f,
		.desc = "This event counts architecturally executed operations due to MOVPRFX instructions that were not fused with the prefixed instruction.",
	},
	{
		.name = "ASE_SVE_LD_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8085,
		.desc = "This event counts architecturally executed operations that read from memory due to Advanced SIMD or SVE load instructions.",
	},
	{
		.name = "ASE_SVE_ST_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8086,
		.desc = "This event counts architecturally executed operations that write to memory due to Advanced SIMD or SVE store instructions.",
	},
	{
		.name = "PRF_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8087,
		.desc = "This event counts architecturally executed prefetch operations due to scalar PRFM, PRFUM and SVE PRF instructions.",
	},
	{
		.name = "BASE_LD_REG_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8089,
		.desc = "This event counts architecturally executed operations that read from memory due to an instruction that loads a general-purpose register.",
	},
	{
		.name = "BASE_ST_REG_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x808a,
		.desc = "This event counts architecturally executed operations that write to memory due to an instruction that stores a general-purpose register, excluding the DC ZVA instruction.",
	},
	{
		.name = "SVE_LDR_REG_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8091,
		.desc = "This event counts architecturally executed operations that read from memory due to an SVE LDR instruction.",
	},
	{
		.name = "SVE_STR_REG_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8092,
		.desc = "This event counts architecturally executed operations that write to memory due to an SVE STR instruction.",
	},
	{
		.name = "SVE_LDR_PREG_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8095,
		.desc = "This event counts architecturally executed operations that read from memory due to an SVE LDR (predicate) instruction.",
	},
	{
		.name = "SVE_STR_PREG_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8096,
		.desc = "This event counts architecturally executed operations that write to memory due to an SVE STR (predicate) instruction.",
	},
	{
		.name = "SVE_PRF_CONTIG_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x809f,
		.desc = "This event counts architecturally executed operations that prefetch memory due to an SVE predicated single contiguous element prefetch instruction.",
	},
	{
		.name = "SVE_LDNT_CONTIG_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x80a1,
		.desc = "This event counts architecturally executed operation that reads from memory with a non-temporal hint due to an SVE non-temporal contiguous element load instruction.",
	},
	{
		.name = "SVE_STNT_CONTIG_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x80a2,
		.desc = "This event counts architecturally executed operation that writes to memory with a non-temporal hint due to an SVE non-temporal contiguous element store instruction.",
	},
	{
		.name = "ASE_SVE_LD_MULTI_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x80a5,
		.desc = "This event counts architecturally executed operations that read from memory due to Advanced SIMD or SVE multiple vector contiguous structure load instructions.",
	},
	{
		.name = "ASE_SVE_ST_MULTI_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x80a6,
		.desc = "This event counts architecturally executed operations that write to memory due to Advanced SIMD or SVE multiple vector contiguous structure store instructions.",
	},
	{
		.name = "SVE_LD_GATHER_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x80ad,
		.desc = "This event counts architecturally executed operations that read from memory due to SVE non-contiguous gather-load instructions.",
	},
	{
		.name = "SVE_ST_SCATTER_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x80ae,
		.desc = "This event counts architecturally executed operations that write to memory due to SVE non-contiguous scatter-store instructions.",
	},
	{
		.name = "SVE_PRF_GATHER_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x80af,
		.desc = "This event counts architecturally executed operations that prefetch memory due to SVE non-contiguous gather-prefetch instructions.",
	},
	{
		.name = "SVE_LDFF_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x80bc,
		.desc = "This event counts architecturally executed memory read operations due to SVE First-fault and Non-fault load instructions.",
	},
	{
		.name = "FP_SCALE_OPS_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x80c0,
		.desc = "This event counts architecturally executed SVE arithmetic operation. See FP_SCALE_OPS_SPEC of ARMv9 Reference Manual for more information. This event counter is incremented by (128 / CSIZE) and by twice that amount for operations that would also be counted by SVE_FP_FMA_SPEC.",
	},
	{
		.name = "FP_FIXED_OPS_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x80c1,
		.desc = "This event counts architecturally executed v8SIMD&FP arithmetic operation. See FP_FIXED_OPS_SPEC of ARMv9 Reference Manual for more information. This event counter is incremented by the specified number of elements for Advanced SIMD operations or by 1 for scalar operations, and by twice those amounts for operations that would also be counted by FP_FMA_SPEC.",
	},
	{
		.name = "FP_HP_SCALE_OPS_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x80c2,
		.desc = "This event counts architecturally executed SVE half-precision arithmetic operation. See FP_HP_SCALE_OPS_SPEC of ARMv9 Reference Manual for more information. This event counter is incremented by 8, or by 16 for operations that would also be counted by SVE_FP_FMA_SPEC.",
	},
	{
		.name = "FP_HP_FIXED_OPS_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x80c3,
		.desc = "This event counts architecturally executed v8SIMD&FP half-precision arithmetic operation. See FP_HP_FIXED_OPS_SPEC of ARMv9 Reference Manual for more information. This event counter is incremented by the number of 16-bit elements for Advanced SIMD operations, or by 1 for scalar operations, and by twice those amounts for operations that would also be counted by FP_FMA_SPEC.",
	},
	{
		.name = "FP_SP_SCALE_OPS_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x80c4,
		.desc = "This event counts architecturally executed SVE single-precision arithmetic operation. See FP_SP_SCALE_OPS_SPEC of ARMv9 Reference Manual for more information. This event counter is incremented by 4, or by 8 for operations that would also be counted by SVE_FP_FMA_SPEC.",
	},
	{
		.name = "FP_SP_FIXED_OPS_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x80c5,
		.desc = "This event counts architecturally executed v8SIMD&FP single-precision arithmetic operation. See FP_SP_FIXED_OPS_SPEC of ARMv9 Reference Manual for more information. This event counter is incremented by the number of 32-bit elements for Advanced SIMD operations, or by 1 for scalar operations, and by twice those amounts for operations that would also be counted by FP_FMA_SPEC.",
	},
	{
		.name = "FP_DP_SCALE_OPS_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x80c6,
		.desc = "This event counts architecturally executed SVE double-precision arithmetic operation. See FP_DP_SCALE_OPS_SPEC of ARMv9 Reference Manual for more information. This event counter is incremented by 2, or by 4 for operations that would also be counted by SVE_FP_FMA_SPEC.",
	},
	{
		.name = "FP_DP_FIXED_OPS_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x80c7,
		.desc = "This event counts architecturally executed v8SIMD&FP double-precision arithmetic operation. See FP_DP_FIXED_OPS_SPEC of ARMv9 Reference Manual for more information. This event counter is incremented by 2 for Advanced SIMD operations, or by 1 for scalar operations, and by twice those amounts for operations that would also be counted by FP_FMA_SPEC.",
	},
	{
		.name = "INT_SCALE_OPS_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x80c8,
		.desc = "This event counts each integer ALU operation counted by SVE_INT_SPEC. See ALU operation counts section of ARMv9 Reference Manual for information on the counter increment for different types of instruction.",
	},
	{
		.name = "INT_FIXED_OPS_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x80c9,
		.desc = "This event counts each integer ALU operation counted by INT_SPEC that is not counted by SVE_INT_SPEC. See ALU operation counts section of ARMv9 Reference Manual for information on the counter increment for different types of instruction.",
	},
	{
		.name = "ASE_SVE_FP_DOT_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x80f3,
		.desc = "This event counts architecturally executed microarchitectural Advanced SIMD or SVE floating-point dot-product operation.",
	},
	{
		.name = "ASE_SVE_FP_MMLA_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x80f7,
		.desc = "This event counts architecturally executed microarchitectural Advanced SIMD or SVE floating-point matrix multiply operation.",
	},
	{
		.name = "ASE_SVE_INT_DOT_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x80fb,
		.desc = "This event counts architecturally executed microarchitectural Advanced SIMD or SVE integer dot-product operation.",
	},
	{
		.name = "ASE_SVE_INT_MMLA_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x80ff,
		.desc = "This event counts architecturally executed microarchitectural Advanced SIMD or SVE integer matrix multiply operation.",
	},
	{
		.name = "DTLB_WALK_PERCYC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8128,
		.desc = "This event counts the number of DTLB_WALK events in progress on each Processor cycle.",
	},
	{
		.name = "ITLB_WALK_PERCYC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8129,
		.desc = "This event counts the number of ITLB_WALK events in progress on each Processor cycle.",
	},
	{
		.name = "DTLB_STEP",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8136,
		.desc = "This event counts translation table walk access made by a refill of the data TLB.",
	},
	{
		.name = "ITLB_STEP",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8137,
		.desc = "This event counts translation table walk access made by a refill of the instruction TLB.",
	},
	{
		.name = "DTLB_WALK_LARGE",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8138,
		.desc = "This event counts translation table walk counted by DTLB_WALK where the result of the walk yields a large page size.",
	},
	{
		.name = "ITLB_WALK_LARGE",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8139,
		.desc = "This event counts translation table walk counted by ITLB_WALK where the result of the walk yields a large page size.",
	},
	{
		.name = "DTLB_WALK_SMALL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x813a,
		.desc = "This event counts translation table walk counted by DTLB_WALK where the result of the walk yields a small page size.",
	},
	{
		.name = "ITLB_WALK_SMALL",
		.modmsk = ARMV9_ATTRS,
		.code = 0x813b,
		.desc = "This event counts translation table walk counted by ITLB_WALK where the result of the walk yields a small page size.",
	},
	{
		.name = "L1D_CACHE_MISS",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8144,
		.desc = "This event counts demand access that misses in the Level 1 data cache, causing an access to outside of the Level 1 caches of this PE.",
	},
	{
		.name = "L1I_CACHE_HWPRF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8145,
		.desc = "This event counts L1I_CACHE caused by hardware prefetch.",
	},
	{
		.name = "L2D_CACHE_MISS",
		.modmsk = ARMV9_ATTRS,
		.code = 0x814c,
		.desc = "This event counts demand access that misses in the Level 1 data and Level 2 caches, causing an access to outside of the Level 1 and Level 2 caches of this PE.",
	},
	{
		.name = "L1D_CACHE_HWPRF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8154,
		.desc = "This event counts L1D_CACHE caused by hardware prefetch.",
	},
	{
		.name = "L2D_CACHE_HWPRF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8155,
		.desc = "This event counts L2D_CACHE caused by hardware prefetch.",
	},
	{
		.name = "STALL_FRONTEND_MEMBOUND",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8158,
		.desc = "This event counts every cycle counted by STALL_FRONTEND when no instructions are delivered from the memory system.",
	},
	{
		.name = "STALL_FRONTEND_L1I",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8159,
		.desc = "This event counts every cycle counted by STALL_FRONTEND_MEMBOUND when there is a demand instruction miss in the first level of instruction cache.",
	},
	{
		.name = "STALL_FRONTEND_L2I",
		.modmsk = ARMV9_ATTRS,
		.code = 0x815a,
		.desc = "This event counts every cycle counted by STALL_FRONTEND_MEMBOUND when there is a demand instruction miss in the second level of instruction cache.",
	},
	{
		.name = "STALL_FRONTEND_MEM",
		.modmsk = ARMV9_ATTRS,
		.code = 0x815b,
		.desc = "This event counts every cycle counted by STALL_FRONTEND_MEMBOUND when there is a demand instruction miss in the last level of instruction cache within the PE clock domain or a non-cacheable instruction fetch in progress.",
	},
	{
		.name = "STALL_FRONTEND_TLB",
		.modmsk = ARMV9_ATTRS,
		.code = 0x815c,
		.desc = "This event counts every cycle counted by STALL_FRONTEND_MEMBOUND when there is a demand instruction miss in the instruction TLB.",
	},
	{
		.name = "STALL_FRONTEND_CPUBOUND",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8160,
		.desc = "This event counts every cycle counted by STALL_FRONTEND when the frontend is stalled on a frontend processor resource, not including memory.",
	},
	{
		.name = "STALL_FRONTEND_FLOW",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8161,
		.desc = "This event counts every cycle counted by STALL_FRONTEND_CPUBOUND when the frontend is stalled on unavailability of prediction flow resources.",
	},
	{
		.name = "STALL_FRONTEND_FLUSH",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8162,
		.desc = "This event counts every cycle counted by STALL_FRONTEND_CPUBOUND when the frontend is recovering from a pipeline flush.",
	},
	{
		.name = "STALL_FRONTEND_RENAME",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8163,
		.desc = "This event counts every cycle counted by STALL_FRONTEND_CPUBOUND when operations are available from the frontend but at least one is not ready to be sent to the backend because no rename register is available.",
	},
	{
		.name = "STALL_BACKEND_MEMBOUND",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8164,
		.desc = "This event counts every cycle counted by STALL_BACKEND when the backend is waiting for a memory access to complete.",
	},
	{
		.name = "STALL_BACKEND_L1D",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8165,
		.desc = "This event counts every cycle counted by STALL_BACKEND_MEMBOUND when there is a demand data miss in L1D cache.",
	},
	{
		.name = "STALL_BACKEND_L2D",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8166,
		.desc = "This event counts every cycle counted by STALL_BACKEND_MEMBOUND when there is a demand data miss in L2 cache.",
	},
	{
		.name = "STALL_BACKEND_TLB",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8167,
		.desc = "This event counts every cycle counted by STALL_BACKEND_MEMBOUND when there is a demand data miss in the data TLB.",
	},
	{
		.name = "STALL_BACKEND_ST",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8168,
		.desc = "This event counts every cycle counted by STALL_BACKEND_MEMBOUND when the backend is stalled waiting for a store.",
	},
	{
		.name = "STALL_BACKEND_CPUBOUND",
		.modmsk = ARMV9_ATTRS,
		.code = 0x816a,
		.desc = "This event counts every cycle counted by STALL_BACKEND when the backend is stalled on a processor resource, not including memory.",
	},
	{
		.name = "STALL_BACKEND_BUSY",
		.modmsk = ARMV9_ATTRS,
		.code = 0x816b,
		.desc = "This event counts every cycle counted by STALL_BACKEND when operations are available from the frontend but the backend is not able to accept an operation because an execution unit is busy.",
	},
	{
		.name = "STALL_BACKEND_ILOCK",
		.modmsk = ARMV9_ATTRS,
		.code = 0x816c,
		.desc = "This event counts every cycle counted by STALL_BACKEND when operations are available from the frontend but at least one is not ready to be sent to the backend because of an input dependency.",
	},
	{
		.name = "STALL_BACKEND_RENAME",
		.modmsk = ARMV9_ATTRS,
		.code = 0x816d,
		.desc = "This event counts every cycle counted by STALL_BACKEND_CPUBOUND when operations are available from the frontend but at least one is not ready to be sent to the backend because no rename register is available.",
	},
	{
		.name = "STALL_BACKEND_ATOMIC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x816e,
		.desc = "This event counts every cycle counted by STALL_BACKEND_MEMBOUND when the backend is processing an Atomic operation.",
	},
	{
		.name = "STALL_BACKEND_MEMCPYSET",
		.modmsk = ARMV9_ATTRS,
		.code = 0x816f,
		.desc = "This event counts every cycle counted by STALL_BACKEND_MEMBOUND when the backend is processing a Memory Copy or Set instruction.",
	},
	{
		.name = "UOP_RETIRED",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8186,
		.desc = "This event counts micro-operation that would be executed in a Simple sequential execution of the program.",
	},
	{
		.name = "DTLB_WALK_BLOCK",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8188,
		.desc = "This event counts translation table walk counted by DTLB_WALK where the result of the walk yields a Block.",
	},
	{
		.name = "ITLB_WALK_BLOCK",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8189,
		.desc = "This event counts translation table walk counted by ITLB_WALK where the result of the walk yields a Block.",
	},
	{
		.name = "DTLB_WALK_PAGE",
		.modmsk = ARMV9_ATTRS,
		.code = 0x818a,
		.desc = "This event counts translation table walk counted by DTLB_WALK where the result of the walk yields a Page.",
	},
	{
		.name = "ITLB_WALK_PAGE",
		.modmsk = ARMV9_ATTRS,
		.code = 0x818b,
		.desc = "This event counts translation table walk counted by ITLB_WALK where the result of the walk yields a Page.",
	},
	{
		.name = "L1I_CACHE_REFILL_HWPRF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x81b8,
		.desc = "This event counts L1I_CACHE_REFILL caused by hardware prefetch.",
	},
	{
		.name = "L1D_CACHE_REFILL_HWPRF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x81bc,
		.desc = "This event counts L1D_CACHE_REFILL caused by hardware prefetch.",
	},
	{
		.name = "L2D_CACHE_REFILL_HWPRF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x81bd,
		.desc = "This event counts L2D_CACHE_REFILL caused by hardware prefetch.",
	},
	{
		.name = "L1I_CACHE_HIT_RD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x81c0,
		.desc = "This event counts demand fetch counted by L1I_CACHE_DM_RD that hits in the Level 1 instruction cache.",
	},
	{
		.name = "L1D_CACHE_HIT_RD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x81c4,
		.desc = "This event counts demand read counted by L1D_CACHE_RD that hits in the Level 1 data cache.",
	},
	{
		.name = "L2D_CACHE_HIT_RD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x81c5,
		.desc = "This event counts demand read counted by L2D_CACHE_RD that hits in the Level 2 cache.",
	},
	{
		.name = "L1D_CACHE_HIT_WR",
		.modmsk = ARMV9_ATTRS,
		.code = 0x81c8,
		.desc = "This event counts demand write counted by L1D_CACHE_WR that hits in the Level 1 data cache.",
	},
	{
		.name = "L2D_CACHE_HIT_WR",
		.modmsk = ARMV9_ATTRS,
		.code = 0x81c9,
		.desc = "This event counts demand write counted by L2D_CACHE_WR that hits in the Level 2 cache.",
	},
	{
		.name = "L1I_CACHE_HIT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8200,
		.desc = "This event counts access counted by L1I_CACHE that hits in the Level 1 instruction cache.",
	},
	{
		.name = "L1D_CACHE_HIT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8204,
		.desc = "This event counts access counted by L1D_CACHE that hits in the Level 1 data cache.",
	},
	{
		.name = "L2D_CACHE_HIT",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8205,
		.desc = "This event counts access counted by L2D_CACHE that hits in the Level 2 cache.",
	},
	{
		.name = "L1I_LFB_HIT_RD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8240,
		.desc = "This event counts demand access counted by L1I_CACHE_HIT_RD that hits a cache line that is in the process of being loaded into the Level 1 instruction cache.",
	},
	{
		.name = "L1D_LFB_HIT_RD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8244,
		.desc = "This event counts demand access counted by L1D_CACHE_HIT_RD that hits a cache line that is in the process of being loaded into the Level 1 data cache.",
	},
	{
		.name = "L2D_LFB_HIT_RD",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8245,
		.desc = "This event counts demand access counted by L2D_CACHE_HIT_RD that hits a recently fetched line in the Level 2 cache.",
	},
	{
		.name = "L1D_LFB_HIT_WR",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8248,
		.desc = "This event counts demand access counted by L1D_CACHE_HIT_WR that hits a cache line that is in the process of being loaded into the Level 1 data cache.",
	},
	{
		.name = "L2D_LFB_HIT_WR",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8249,
		.desc = "This event counts demand access counted by L2D_CACHE_HIT_WR that hits a recently fetched line in the Level 2 cache.",
	},
	{
		.name = "L1I_CACHE_PRF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8280,
		.desc = "This event counts L1I_CACHE caused by hardware prefetch or software prefetch.",
	},
	{
		.name = "L1D_CACHE_PRF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8284,
		.desc = "This event counts L1D_CACHE caused by hardware prefetch or software prefetch.",
	},
	{
		.name = "L2D_CACHE_PRF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8285,
		.desc = "This event counts L2D_CACHE caused by hardware prefetch or software prefetch.",
	},
	{
		.name = "L1I_CACHE_REFILL_PRF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8288,
		.desc = "This event counts L1I_CACHE_REFILL caused by hardware prefetch or software prefetch.",
	},
	{
		.name = "L1D_CACHE_REFILL_PRF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x828c,
		.desc = "This event counts L1D_CACHE_REFILL caused by hardware prefetch or software prefetch.",
	},
	{
		.name = "L2D_CACHE_REFILL_PRF",
		.modmsk = ARMV9_ATTRS,
		.code = 0x828d,
		.desc = "This event counts L2D_CACHE_REFILL caused by hardware prefetch or software prefetch.",
	},
	{
		.name = "L1D_CACHE_REFILL_PERCYC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8320,
		.desc = "This counter counts by the number of cache refills counted by L1D_CACHE_REFILL in progress on each Processor cycle.",
	},
	{
		.name = "L2D_CACHE_REFILL_PERCYC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8321,
		.desc = "This counter counts by the number of cache refills counted by L2D_CACHE_REFILL in progress on each Processor cycle.",
	},
	{
		.name = "L1I_CACHE_REFILL_PERCYC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8324,
		.desc = "This counter counts by the number of cache refills counted by L1I_CACHE_REFILL in progress on each Processor cycle.",
	},
	{
		.name = "ASE_FP_VREDUCE_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8431,
		.desc = "This event counts architecturally executed Advanced SIMD floating-point vector reduction operation.",
	},
	{
		.name = "SVE_FP_PREDUCE_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8432,
		.desc = "This event counts architecturally executed SVE floating-point pairwise add step operation.",
	},
	{
		.name = "ASE_FP_BF16_MIN_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8443,
		.desc = "This event counts architecturally executed Advanced SIMD data processing operations, smallest type is BFloat16 floating-point.",
	},
	{
		.name = "ASE_FP_FP8_MIN_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8444,
		.desc = "This event counts architecturally executed Advanced SIMD data processing operations, smallest type is 8-bit floating-point.",
	},
	{
		.name = "ASE_SVE_FP_BF16_MIN_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x844b,
		.desc = "This event counts architecturally executed Advanced SIMD data processing or SVE data processing operations, smallest type is BFloat16 floating-point.",
	},
	{
		.name = "ASE_SVE_FP_FP8_MIN_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x844c,
		.desc = "This event counts architecturally executed Advanced SIMD data processing or SVE data processing operations, smallest type is 8-bit floating-point.",
	},
	{
		.name = "SVE_FP_BF16_MIN_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8463,
		.desc = "This event counts architecturally executed SVE data processing operations, smallest type is BFloat16 floating-point.",
	},
	{
		.name = "SVE_FP_FP8_MIN_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8464,
		.desc = "This event counts architecturally executed SVE data processing operations, smallest type is 8-bit floating-point.",
	},
	{
		.name = "FP_BF16_MIN_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8473,
		.desc = "This event counts architecturally executed data processing operations, smallest type is BFloat16 floating-point.",
	},
	{
		.name = "FP_FP8_MIN_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8474,
		.desc = "This event counts architecturally executed data processing operations, smallest type is 8-bit floating-point.",
	},
	{
		.name = "FP_BF16_FIXED_MIN_OPS_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8483,
		.desc = "This event counts architecturally executed non-scalable element arithmetic operations, smallest type is BFloat16 floating-point.",
	},
	{
		.name = "FP_FP8_FIXED_MIN_OPS_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x8484,
		.desc = "This event counts architecturally executed non-scalable element arithmetic operations, smallest type is 8-bit floating-point.",
	},
	{
		.name = "FP_BF16_SCALE_MIN_OPS_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x848b,
		.desc = "This event counts architecturally executed scalable element arithmetic operations, smallest type is BFloat16 floating-point.",
	},
	{
		.name = "FP_FP8_SCALE_MIN_OPS_SPEC",
		.modmsk = ARMV9_ATTRS,
		.code = 0x848c,
		.desc = "This event counts architecturally executed scalable element arithmetic operations, smallest type is 8-bit floating-point.",
	},
};
